package com.urbanairship;

import android.content.Context;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class LocationOptions extends Options {
    public boolean locationServiceEnabled = false;
    public boolean allowGPSForLocationTracking = true;
    public int updateIntervalMeters = 500;
    public long updateIntervalSeconds = 900;
    public long backgroundReportingIntervalSeconds = 900;
    public int horizontalAccuracy = 2;
    public int powerRequirement = 1;
    public boolean altitudeRequired = false;
    public boolean bearingRequired = false;
    public boolean speedRequired = false;
    public boolean costAllowed = false;

    public static LocationOptions loadDefaultOptions(Context context) {
        LocationOptions locationOptions = new LocationOptions();
        locationOptions.loadFromProperties(context);
        return locationOptions;
    }

    @Override // com.urbanairship.Options
    public String getDefaultPropertiesFilename() {
        return "location.properties";
    }

    @Override // com.urbanairship.Options
    public boolean isValid() {
        try {
            LocationOptions.class.getField("locationServiceEnabled");
            return true;
        } catch (NoSuchFieldException e) {
            Logger.error("LocationOptions appears to be obfuscated and will not read the location.properties file. If using Proguard, add the following to your proguard.cfg:");
            Logger.error("\t-keepclasseswithmembernames public class * extends com.urbanairship.Options {");
            Logger.error("\t\tpublic *;");
            Logger.error("\t}");
            return true;
        } catch (SecurityException e2) {
            return true;
        }
    }
}
