package com.unity3d.player;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.MediaController;
import java.io.FileInputStream;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public final class y extends FrameLayout implements SensorEventListener, MediaPlayer.OnBufferingUpdateListener, MediaPlayer.OnCompletionListener, MediaPlayer.OnPreparedListener, MediaPlayer.OnVideoSizeChangedListener, SurfaceHolder.Callback, MediaController.MediaPlayerControl {
    private final UnityPlayer a;
    private final Context b;
    private final SurfaceView c;
    private final SurfaceHolder d;
    private final String e;
    private final int f;
    private final int g;
    private final boolean h;
    private final long i;
    private final long j;
    private final FrameLayout k;
    private final SensorManager l;
    private final WindowManager m;
    private int n;
    private int o;
    private int p;
    private int q;
    private MediaPlayer r;
    private MediaController s;
    private boolean t;
    private boolean u;
    private int v;
    private boolean w;
    private int x;
    private boolean y;

    /* JADX INFO: Access modifiers changed from: protected */
    public y(UnityPlayer unityPlayer, Context context, String str, int i, int i2, int i3, boolean z, long j, long j2) {
        super(context);
        this.t = false;
        this.u = false;
        this.v = 0;
        this.w = false;
        this.x = 0;
        this.a = unityPlayer;
        this.b = context;
        this.k = this;
        this.c = new SurfaceView(context);
        this.d = this.c.getHolder();
        this.d.addCallback(this);
        this.d.setType(3);
        this.k.setBackgroundColor(i);
        this.k.addView(this.c);
        this.l = (SensorManager) this.b.getSystemService("sensor");
        this.m = (WindowManager) this.b.getSystemService("window");
        this.e = str;
        this.f = i2;
        this.g = i3;
        this.h = z;
        this.i = j;
        this.j = j2;
        setFocusable(true);
        setFocusableInTouchMode(true);
        this.l.registerListener(this, this.l.getDefaultSensor(1), 1);
        this.y = true;
    }

    private void a() {
        doCleanUp();
        try {
            this.r = new MediaPlayer();
            if (this.h) {
                this.r.setDataSource(this.b, Uri.parse(this.e));
            } else if (this.j != 0) {
                FileInputStream fileInputStream = new FileInputStream(this.e);
                this.r.setDataSource(fileInputStream.getFD(), this.i, this.j);
                fileInputStream.close();
            } else {
                try {
                    AssetFileDescriptor openFd = getResources().getAssets().openFd(this.e);
                    this.r.setDataSource(openFd.getFileDescriptor(), openFd.getStartOffset(), openFd.getLength());
                    openFd.close();
                } catch (IOException e) {
                    FileInputStream fileInputStream2 = new FileInputStream(this.e);
                    this.r.setDataSource(fileInputStream2.getFD());
                    fileInputStream2.close();
                }
            }
            this.r.setDisplay(this.d);
            this.r.setOnBufferingUpdateListener(this);
            this.r.setOnCompletionListener(this);
            this.r.setOnPreparedListener(this);
            this.r.setOnVideoSizeChangedListener(this);
            this.r.setAudioStreamType(3);
            this.r.prepare();
            if (this.f == 0 || this.f == 1) {
                this.s = new MediaController(this.b);
                this.s.setMediaPlayer(this);
                this.s.setAnchorView(this.c);
                this.s.setEnabled(true);
                this.s.show();
            }
        } catch (Exception e2) {
            onDestroy();
        }
    }

    private void b() {
        if (isPlaying()) {
            return;
        }
        updateVideoLayout();
        if (this.w) {
            return;
        }
        start();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final boolean canPause() {
        return true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final boolean canSeekBackward() {
        return true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final boolean canSeekForward() {
        return true;
    }

    protected final void doCleanUp() {
        if (this.r != null) {
            this.r.release();
            this.r = null;
        }
        this.p = 0;
        this.q = 0;
        this.u = false;
        this.t = false;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final int getBufferPercentage() {
        if (this.h) {
            return this.v;
        }
        return 100;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final int getCurrentPosition() {
        if (this.r == null) {
            return 0;
        }
        return this.r.getCurrentPosition();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final int getDuration() {
        if (this.r == null) {
            return 0;
        }
        return this.r.getDuration();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final boolean isPlaying() {
        boolean z = this.u && this.t;
        return this.r == null ? !z : this.r.isPlaying() || !z;
    }

    @Override // android.hardware.SensorEventListener
    public final void onAccuracyChanged(Sensor sensor, int i) {
    }

    @Override // android.media.MediaPlayer.OnBufferingUpdateListener
    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int i) {
        this.v = i;
    }

    @Override // android.media.MediaPlayer.OnCompletionListener
    public final void onCompletion(MediaPlayer mediaPlayer) {
        onDestroy();
    }

    protected final void onDestroy() {
        onPause();
        doCleanUp();
        UnityPlayer unityPlayer = this.a;
        UnityPlayer.a(new Runnable() { // from class: com.unity3d.player.y.1
            @Override // java.lang.Runnable
            public final void run() {
                y.this.a.hideVideoPlayer();
            }
        });
    }

    @Override // android.view.View, android.view.KeyEvent.Callback
    public final boolean onKeyDown(int i, KeyEvent keyEvent) {
        if (i != 4 && (this.f != 2 || i == 0 || keyEvent.isSystem())) {
            return this.s != null ? this.s.onKeyDown(i, keyEvent) : super.onKeyDown(i, keyEvent);
        }
        onDestroy();
        return true;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void onPause() {
        this.l.unregisterListener(this);
        if (!this.w) {
            pause();
            this.w = false;
        }
        if (this.r != null) {
            this.x = this.r.getCurrentPosition();
        }
        this.y = false;
    }

    @Override // android.media.MediaPlayer.OnPreparedListener
    public final void onPrepared(MediaPlayer mediaPlayer) {
        this.u = true;
        if (this.u && this.t) {
            b();
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void onResume() {
        if (!this.y) {
            this.l.registerListener(this, this.l.getDefaultSensor(1), 1);
            if (!this.w) {
                start();
            }
        }
        this.y = true;
    }

    @Override // android.hardware.SensorEventListener
    public final void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 1) {
            this.a.nativeDeviceOrientation(r.a(sensorEvent, this.m.getDefaultDisplay().getOrientation(), this.a.getOrientation()));
        }
    }

    @Override // android.view.View
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction() & 255;
        if (this.f != 2 || action != 0) {
            return this.s != null ? this.s.onTouchEvent(motionEvent) : super.onTouchEvent(motionEvent);
        }
        onDestroy();
        return true;
    }

    @Override // android.media.MediaPlayer.OnVideoSizeChangedListener
    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int i, int i2) {
        if (i == 0 || i2 == 0) {
            return;
        }
        this.t = true;
        this.p = i;
        this.q = i2;
        if (this.u && this.t) {
            b();
        }
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final void pause() {
        if (this.r == null) {
            return;
        }
        this.r.pause();
        this.w = true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final void seekTo(int i) {
        if (this.r == null) {
            return;
        }
        this.r.seekTo(i);
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public final void start() {
        if (this.r == null) {
            return;
        }
        this.r.start();
        this.w = false;
    }

    @Override // android.view.SurfaceHolder.Callback
    public final void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        this.n = i2;
        this.o = i3;
    }

    @Override // android.view.SurfaceHolder.Callback
    public final void surfaceCreated(SurfaceHolder surfaceHolder) {
        a();
        seekTo(this.x);
    }

    @Override // android.view.SurfaceHolder.Callback
    public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        doCleanUp();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void updateVideoLayout() {
        WindowManager windowManager = (WindowManager) this.b.getSystemService("window");
        this.n = windowManager.getDefaultDisplay().getWidth();
        this.o = windowManager.getDefaultDisplay().getHeight();
        int i = this.n;
        int i2 = this.o;
        if (this.g == 1 || this.g == 2) {
            float f = this.p / this.q;
            if (this.n / this.o <= f) {
                i2 = (int) (this.n / f);
            } else {
                i = (int) (this.o * f);
            }
        } else if (this.g == 0) {
            i = this.p;
            i2 = this.q;
        }
        this.k.updateViewLayout(this.c, new FrameLayout.LayoutParams(i, i2, 17));
    }
}
