package com.unity3d.player;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UnityPlayerProxyActivity extends Activity {
    /* JADX INFO: Access modifiers changed from: protected */
    public static void copyPlayerPrefs(Context context, String[] strArr) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(context.getPackageName(), 0);
        if (sharedPreferences.getAll().isEmpty()) {
            SharedPreferences.Editor edit = sharedPreferences.edit();
            for (String str : strArr) {
                Map<String, ?> all = context.getSharedPreferences(str, 0).getAll();
                if (!all.isEmpty()) {
                    for (Map.Entry<String, ?> entry : all.entrySet()) {
                        Object value = entry.getValue();
                        if (value.getClass() == Integer.class) {
                            edit.putInt(entry.getKey(), ((Integer) value).intValue());
                        } else if (value.getClass() == Float.class) {
                            edit.putFloat(entry.getKey(), ((Float) value).floatValue());
                        } else if (value.getClass() == String.class) {
                            edit.putString(entry.getKey(), (String) value);
                        }
                    }
                    edit.commit();
                }
            }
        }
    }

    @Override // android.app.Activity
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        String[] strArr = {"com.unity3d.player.UnityPlayerActivity", "com.unity3d.player.UnityPlayerNativeActivity"};
        copyPlayerPrefs(this, strArr);
        try {
            Intent intent = new Intent(this, Class.forName(strArr[Build.VERSION.SDK_INT >= 9 ? (char) 1 : (char) 0]));
            intent.addFlags(65536);
            Bundle extras = getIntent().getExtras();
            if (extras != null) {
                intent.putExtras(extras);
            }
            startActivity(intent);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } finally {
            finish();
        }
    }
}
