package com.unity3d.player;

import android.app.NativeActivity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UnityPlayerNativeActivity extends NativeActivity {
    protected UnityPlayer mUnityPlayer;

    @Override // android.app.NativeActivity, android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mUnityPlayer.configurationChanged(configuration);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.app.NativeActivity, android.app.Activity
    public void onCreate(Bundle bundle) {
        this.mUnityPlayer = new UnityPlayer(this);
        requestWindowFeature(1);
        super.onCreate(bundle);
        getWindow().takeSurface(null);
        setTheme(16973831);
        getWindow().setFormat(4);
        if (this.mUnityPlayer.getSettings().getBoolean("hide_status_bar", true)) {
            getWindow().setFlags(1024, 1024);
        }
        this.mUnityPlayer.init(this.mUnityPlayer.getSettings().getInt("gles_mode", 1), false);
        View view = this.mUnityPlayer.getView();
        setContentView(view);
        view.requestFocus();
    }

    @Override // android.app.NativeActivity, android.app.Activity
    protected void onDestroy() {
        super.onDestroy();
        this.mUnityPlayer.quit();
    }

    @Override // android.app.NativeActivity, android.app.Activity
    protected void onPause() {
        super.onPause();
        this.mUnityPlayer.pause();
        if (isFinishing()) {
            this.mUnityPlayer.quit();
        }
    }

    @Override // android.app.NativeActivity, android.app.Activity
    protected void onResume() {
        super.onResume();
        this.mUnityPlayer.resume();
    }

    @Override // android.app.NativeActivity, android.app.Activity, android.view.Window.Callback
    public void onWindowFocusChanged(boolean z) {
        super.onWindowFocusChanged(z);
        this.mUnityPlayer.windowFocusChanged(z);
    }
}
