package com.unity3d.player;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UnityPlayerActivity extends Activity {
    private UnityPlayer a;

    @Override // android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.a.configurationChanged(configuration);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.app.Activity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        setTheme(16973831);
        requestWindowFeature(1);
        this.a = new UnityPlayer(this);
        if (this.a.getSettings().getBoolean("hide_status_bar", true)) {
            getWindow().setFlags(1024, 1024);
        }
        this.a.init(this.a.getSettings().getInt("gles_mode", 1), false);
        View view = this.a.getView();
        setContentView(view);
        view.requestFocus();
    }

    @Override // android.app.Activity
    protected void onDestroy() {
        super.onDestroy();
        this.a.quit();
    }

    @Override // android.app.Activity, android.view.KeyEvent.Callback
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        return this.a.onKeyDown(i, keyEvent);
    }

    @Override // android.app.Activity, android.view.KeyEvent.Callback
    public boolean onKeyUp(int i, KeyEvent keyEvent) {
        return this.a.onKeyUp(i, keyEvent);
    }

    @Override // android.app.Activity
    protected void onPause() {
        super.onPause();
        this.a.pause();
        if (isFinishing()) {
            this.a.quit();
        }
    }

    @Override // android.app.Activity
    protected void onResume() {
        super.onResume();
        this.a.resume();
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public void onWindowFocusChanged(boolean z) {
        super.onWindowFocusChanged(z);
        this.a.windowFocusChanged(z);
    }
}
