package com.unity3d.player;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.flurry.android.Constants;
import com.prime31.EtceteraProxyActivity;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyConstants;
import com.unity3d.player.a;
import com.unity3d.player.i;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.fmod.FMODAudioDevice;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UnityPlayer extends FrameLayout implements GLSurfaceView.Renderer, a.InterfaceC0006a {
    private static b J;
    public static Activity currentActivity = null;
    private static boolean u = true;
    private final r A;
    private String B;
    private NetworkInfo C;
    private Bundle D;
    private List E;
    private y F;
    private ProgressBar G;
    private Runnable H;
    private Runnable I;
    private float K;
    private float L;
    private BroadcastReceiver M;
    private boolean N;
    private int O;
    private boolean P;
    s a;
    private boolean b;
    private boolean c;
    private final l d;
    private final t e;
    private boolean f;
    private x g;
    private Bundle h;
    private SharedPreferences i;
    private ContextWrapper j;
    private boolean k;
    private UnityGL l;
    private q m;
    private PowerManager.WakeLock n;
    private PowerManager.WakeLock o;
    private PowerManager.WakeLock p;
    private SensorManager q;
    private WindowManager r;
    private FMODAudioDevice s;
    private Vibrator t;
    private boolean v;
    private int w;
    private int x;
    private int y;
    private int z;

    static {
        J = null;
        J = new b();
    }

    public UnityPlayer(ContextWrapper contextWrapper) {
        super(contextWrapper);
        this.b = false;
        this.c = false;
        this.f = false;
        this.g = new x();
        this.h = null;
        this.i = null;
        this.t = null;
        this.v = true;
        this.y = 0;
        this.z = 0;
        this.B = null;
        this.C = null;
        this.D = new Bundle();
        this.E = new ArrayList();
        this.a = null;
        this.G = null;
        this.H = new Runnable() { // from class: com.unity3d.player.UnityPlayer.3
            @Override // java.lang.Runnable
            public final void run() {
                int nativeActivityIndicatorStyle = UnityPlayer.this.nativeActivityIndicatorStyle();
                if (nativeActivityIndicatorStyle >= 0) {
                    if (UnityPlayer.this.G == null) {
                        UnityPlayer.this.G = new ProgressBar(UnityPlayer.this.j, null, new int[]{16842874, 16843401, 16842873, 16843400}[nativeActivityIndicatorStyle]);
                        UnityPlayer.this.G.setIndeterminate(true);
                        UnityPlayer.this.G.setLayoutParams(new FrameLayout.LayoutParams(-2, -2, 51));
                        UnityPlayer.this.addView(UnityPlayer.this.G);
                    }
                    UnityPlayer.this.G.setVisibility(0);
                    UnityPlayer.this.bringChildToFront(UnityPlayer.this.G);
                }
            }
        };
        this.I = new Runnable() { // from class: com.unity3d.player.UnityPlayer.4
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.G != null) {
                    UnityPlayer.this.G.setVisibility(8);
                    UnityPlayer.this.G = null;
                }
            }
        };
        this.K = 0.0f;
        this.L = 0.0f;
        this.M = new BroadcastReceiver() { // from class: com.unity3d.player.UnityPlayer.17
            @Override // android.content.BroadcastReceiver
            public void onReceive(Context context, Intent intent) {
                try {
                    UnityPlayer.this.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.17.1
                        @Override // java.lang.Runnable
                        public final void run() {
                            UnityPlayer.this.nativeJoystickRemoved();
                        }
                    });
                } catch (Exception e) {
                }
            }
        };
        this.N = false;
        this.O = 1;
        this.P = true;
        this.e = new t(this);
        this.j = contextWrapper;
        try {
            this.k = Class.forName("android.app.NativeActivity").isAssignableFrom(this.j.getClass());
        } catch (Exception e) {
        }
        this.d = this.k ? new o(contextWrapper) : null;
        String packageName = this.j.getPackageName();
        if (contextWrapper instanceof Activity) {
            currentActivity = (Activity) contextWrapper;
            this.h = currentActivity.getIntent().getExtras();
            UnityPlayerProxyActivity.copyPlayerPrefs(contextWrapper, new String[]{"com.unity3d.player.UnityPlayerActivity", "com.unity3d.player.UnityPlayerNativeActivity", currentActivity.getLocalClassName()});
        }
        this.i = contextWrapper.getSharedPreferences(packageName, 0);
        a();
        j();
        nativeFile(this.j.getPackageCodePath());
        l();
        this.A = new r(contextWrapper, this);
        if (Build.VERSION.SDK_INT >= 8) {
            this.f = true;
        }
    }

    public static native void UnitySendMessage(String str, String str2, String str3);

    private static int a(MotionEvent motionEvent) {
        if (p.e) {
            k kVar = p.k;
            return k.a(motionEvent);
        }
        return 0;
    }

    private static String a(String str) {
        byte[] bArr;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream fileInputStream = new FileInputStream(str);
            long length = new File(str).length();
            fileInputStream.skip(length - Math.min(length, 65558L));
            byte[] bArr2 = new byte[1024];
            for (int i = 0; i != -1; i = fileInputStream.read(bArr2)) {
                messageDigest.update(bArr2, 0, i);
            }
            bArr = messageDigest.digest();
        } catch (FileNotFoundException e) {
            bArr = null;
        } catch (IOException e2) {
            bArr = null;
        } catch (NoSuchAlgorithmException e3) {
            bArr = null;
        }
        if (bArr == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte b : bArr) {
            stringBuffer.append(Integer.toString((b & Constants.UNKNOWN) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    private String a(String str, File file) {
        String externalStorageState = Environment.getExternalStorageState();
        if (this.j.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0 && "mounted".equals(externalStorageState)) {
            File file2 = new File(Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + this.j.getPackageName() + str);
            if (file2.exists() || file2.mkdirs()) {
                return file2.getPath();
            }
        }
        return file.getPath();
    }

    private void a() {
        try {
            InputStream open = this.j.getAssets().open("bin/Data/settings.xml");
            XmlPullParserFactory newInstance = XmlPullParserFactory.newInstance();
            newInstance.setNamespaceAware(true);
            XmlPullParser newPullParser = newInstance.newPullParser();
            newPullParser.setInput(open, null);
            String str = null;
            String str2 = null;
            for (int eventType = newPullParser.getEventType(); eventType != 1; eventType = newPullParser.next()) {
                if (eventType == 2) {
                    str2 = newPullParser.getName();
                    String str3 = str;
                    for (int i = 0; i < newPullParser.getAttributeCount(); i++) {
                        if (newPullParser.getAttributeName(i).equalsIgnoreCase(TapjoyConstants.TJC_EVENT_IAP_NAME)) {
                            str3 = newPullParser.getAttributeValue(i);
                        }
                    }
                    str = str3;
                } else if (eventType == 3) {
                    str2 = null;
                } else if (eventType == 4 && str != null) {
                    if (str2.equalsIgnoreCase("integer")) {
                        this.D.putInt(str, Integer.parseInt(newPullParser.getText()));
                    } else if (str2.equalsIgnoreCase("string")) {
                        this.D.putString(str, newPullParser.getText());
                    } else if (str2.equalsIgnoreCase("bool")) {
                        this.D.putBoolean(str, Boolean.parseBoolean(newPullParser.getText()));
                    } else if (str2.equalsIgnoreCase("float")) {
                        this.D.putFloat(str, Float.parseFloat(newPullParser.getText()));
                    }
                    str = null;
                }
            }
        } catch (Exception e) {
            m.Log(6, "Unable to locate player settings. " + e.getLocalizedMessage());
            b();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(final int i, boolean z) {
        RectF a;
        PowerManager powerManager = (PowerManager) this.j.getSystemService("power");
        this.n = powerManager.newWakeLock(26, "Unity-ProjectRequestedWakeLock");
        this.o = powerManager.newWakeLock(26, "Unity-VideoPlayerWakeLock");
        this.p = powerManager.newWakeLock(26, "Unity-StartupWakeLock");
        a(true);
        c();
        initJni();
        new PlayerPrefs(this.i);
        nativeInitWWW(WWW.class);
        if (Build.PRODUCT.compareToIgnoreCase("blaze") == 0 && Build.MODEL.toLowerCase().startsWith("kindle")) {
            this.m = new q(this.j);
            this.e.a(this.m);
        }
        this.q = (SensorManager) this.j.getSystemService("sensor");
        this.r = (WindowManager) this.j.getSystemService("window");
        if (this.l == null) {
            w wVar = new w(this.j, i, z, false, this.D.getBoolean("32bit_display", false), this.D.getBoolean("24bit_depth", false) ? 24 : 16, this.D.getInt("default_aa", 0), this) { // from class: com.unity3d.player.UnityPlayer.22
                private /* synthetic */ View a;

                {
                    this.a = this;
                }

                @Override // com.unity3d.player.w, android.view.View
                public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
                    return this.a.onTouchEvent(motionEvent);
                }

                @Override // android.view.View
                public final boolean onKeyPreIme(int i2, KeyEvent keyEvent) {
                    return this.a.onKeyPreIme(i2, keyEvent) || super.onKeyPreIme(i2, keyEvent);
                }
            };
            if (p.c) {
                p.i.a((GLSurfaceView) wVar, true);
            }
            wVar.setFocusable(true);
            wVar.setFocusableInTouchMode(true);
            if (p.c) {
                p.i.a(wVar);
            }
            this.l = wVar;
        }
        this.l.setRenderer(this);
        this.g.c();
        final int i2 = getSettings().getInt("splash_mode");
        this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.23
            @Override // java.lang.Runnable
            public final void run() {
                UnityPlayer.this.nativeInit(i, i2);
            }
        });
        nativeSetExtras(this.h);
        if (this.d != null && (a = this.d.a()) != null) {
            nativeEnableTouchpad(a.width(), a.height());
        }
        resume();
        windowFocusChanged(true);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void a(Runnable runnable) {
        new Thread(runnable).start();
    }

    private static void a(String str, PowerManager.WakeLock wakeLock, boolean z) {
        try {
            if (z != wakeLock.isHeld()) {
                if (z) {
                    wakeLock.acquire();
                    if (!wakeLock.isHeld()) {
                        m.Log(5, String.format("Unable to acquire %s wake-lock. Make sure 'android.permission.WAKE_LOCK' has been set in the manifest.", str));
                    }
                } else if (!z) {
                    wakeLock.release();
                }
            }
        } catch (Exception e) {
            m.Log(5, String.format("Unable to acquire/release %s wake-lock. Make sure 'android.permission.WAKE_LOCK' has been set in the manifest.", str));
        }
    }

    private void a(boolean z) {
        if (b("android.permission.WAKE_LOCK")) {
            a("startup", this.p, z);
        }
    }

    private boolean a(int i, KeyEvent keyEvent) {
        return keyEvent.getAction() == 0 ? super.onKeyDown(i, keyEvent) : super.onKeyUp(i, keyEvent);
    }

    private static String[] a(Context context) {
        String packageName = context.getPackageName();
        Vector vector = new Vector();
        try {
            int i = context.getPackageManager().getPackageInfo(packageName, 0).versionCode;
            if (Environment.getExternalStorageState().equals("mounted")) {
                File file = new File(Environment.getExternalStorageDirectory().toString() + "/Android/obb/" + packageName);
                if (file.exists()) {
                    if (i > 0) {
                        String str = file + File.separator + "main." + i + "." + packageName + ".obb";
                        if (new File(str).isFile()) {
                            vector.add(str);
                        }
                    }
                    if (i > 0) {
                        String str2 = file + File.separator + "patch." + i + "." + packageName + ".obb";
                        if (new File(str2).isFile()) {
                            vector.add(str2);
                        }
                    }
                }
            }
            String[] strArr = new String[vector.size()];
            vector.toArray(strArr);
            return strArr;
        } catch (PackageManager.NameNotFoundException e) {
            return new String[0];
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b() {
        if (!(this.j instanceof Activity) || ((Activity) this.j).isFinishing()) {
            return;
        }
        ((Activity) this.j).finish();
    }

    private void b(Runnable runnable) {
        if (this.j instanceof Activity) {
            ((Activity) this.j).runOnUiThread(runnable);
        } else {
            m.Log(5, "Not running Unity from an Activity; ignored...");
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b(boolean z) {
        a(EtceteraProxyActivity.PROXY_VIDEO, this.o, z);
    }

    private boolean b(int i, KeyEvent keyEvent) {
        if (!this.g.h()) {
            if (i == 4) {
                kill();
                return true;
            }
            return true;
        } else if (isFinishing()) {
            return false;
        } else {
            if (i == 25 || i == 24) {
                return a(i, keyEvent);
            }
            final int i2 = (i == 4 && keyEvent.getMetaState() == 2) ? 101 : i;
            final int unicodeChar = keyEvent.getUnicodeChar(keyEvent.getMetaState());
            final boolean z = keyEvent.getAction() == 0;
            final int scanCode = keyEvent.getScanCode();
            final int deviceId = keyEvent.getDeviceId();
            queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.5
                @Override // java.lang.Runnable
                public final void run() {
                    UnityPlayer.this.nativeKeyState(i2, unicodeChar, z, scanCode, deviceId);
                }
            });
            return true;
        }
    }

    private boolean b(MotionEvent motionEvent) {
        final float f;
        if (!this.k) {
            int pointerCount = motionEvent.getPointerCount();
            int i = 0;
            while (i < pointerCount) {
                if (i == 0) {
                    int action = motionEvent.getAction();
                    final int i2 = i == ((action & 255) >> 8) ? action & 255 : 2;
                    final float x = motionEvent.getX(i);
                    final float y = motionEvent.getY(i);
                    final float f2 = this.K;
                    final float f3 = this.L;
                    if (p.d) {
                        i iVar = p.j;
                        f = i.a(motionEvent, i);
                    } else {
                        f = 0.0f;
                    }
                    final int a = a(motionEvent);
                    queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.7
                        @Override // java.lang.Runnable
                        public final void run() {
                            int i3;
                            int i4;
                            switch (i2) {
                                case 0:
                                    i4 = a;
                                    i3 = 0;
                                    break;
                                case 1:
                                    i4 = a;
                                    i3 = 1;
                                    break;
                                case 2:
                                    i3 = 3;
                                    i4 = 0;
                                    break;
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                default:
                                    i4 = 0;
                                    i3 = 0;
                                    break;
                                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                                    i3 = 2;
                                    i4 = 0;
                                    break;
                            }
                            UnityPlayer.this.nativeQueueGUIEvent(i3, x, y, i4);
                            float f4 = x;
                            float f5 = UnityPlayer.this.x - y;
                            UnityPlayer.this.nativeSetMouseDelta(x - f2, -(y - f3), i2 == 8 ? f : 0.0f);
                            UnityPlayer.this.nativeSetMousePosition(f4, f5);
                            if (i2 == 0) {
                                UnityPlayer.this.nativeSetMouseButton(0, true);
                            } else if (i2 == 1) {
                                UnityPlayer.this.nativeSetMouseButton(0, false);
                            }
                        }
                    });
                    this.K = x;
                    this.L = y;
                }
                i++;
            }
        }
        return true;
    }

    private boolean b(String str) {
        return this.j.checkCallingOrSelfPermission(str) == 0;
    }

    private void c() {
        if (this.k) {
            nativeForwardEventsToDalvik(new n((Activity) this.j).a());
        }
    }

    private void c(boolean z) {
        if (this.N) {
            if (z) {
                this.q.registerListener(this.A, this.q.getDefaultSensor(4), this.O);
                this.q.registerListener(this.A, this.q.getDefaultSensor(9), this.O);
                this.q.registerListener(this.A, this.q.getDefaultSensor(10), this.O);
                this.q.registerListener(this.A, this.q.getDefaultSensor(11), this.O);
                return;
            }
            this.q.unregisterListener(this.A, this.q.getDefaultSensor(4));
            this.q.unregisterListener(this.A, this.q.getDefaultSensor(9));
            this.q.unregisterListener(this.A, this.q.getDefaultSensor(10));
            this.q.unregisterListener(this.A, this.q.getDefaultSensor(11));
        }
    }

    private boolean c(MotionEvent motionEvent) {
        if (!this.k && p.d) {
            final i.a[] a = p.j.a(motionEvent);
            queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.8
                @Override // java.lang.Runnable
                public final void run() {
                    i.a[] aVarArr;
                    for (i.a aVar : a) {
                        int i = aVar.a + 1;
                        for (int i2 = 0; i2 < aVar.b.length; i2++) {
                            UnityPlayer.this.nativeSetJoystickPosition(i, i2, aVar.b[i2]);
                        }
                    }
                }
            });
        }
        return true;
    }

    private void d() {
        for (a aVar : this.E) {
            aVar.c();
        }
    }

    private void d(boolean z) {
        if (this.P) {
            if (z) {
                this.q.registerListener(this.A, this.q.getDefaultSensor(2), 1);
            } else {
                this.q.unregisterListener(this.A, this.q.getDefaultSensor(2));
            }
        }
    }

    private void e() {
        for (a aVar : this.E) {
            try {
                aVar.a(this);
            } catch (Exception e) {
                m.Log(6, "Unable to initialize camera: " + e.getMessage());
                aVar.c();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void f() {
        if (this.m != null) {
            this.m.a(this.w, this.x);
        }
    }

    private void g() {
        if (this.g.f()) {
            if (this.F != null) {
                b(true);
                this.F.onResume();
                return;
            }
            this.g.c(true);
            e();
            this.l.onResume();
            this.j.registerReceiver(this.M, new IntentFilter("android.hardware.usb.action.USB_DEVICE_DETACHED"));
            this.q.registerListener(this.A, this.q.getDefaultSensor(1), 1);
            c(true);
            d(true);
            this.A.e();
            this.B = null;
            this.C = null;
            if (this.g.h()) {
                l();
            }
            if ((indexOfChild((View) this.l) == -1) && (this.l instanceof w)) {
                this.e.d((View) this.l);
            }
            if (this.g.h()) {
                this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.26
                    @Override // java.lang.Runnable
                    public final void run() {
                        UnityPlayer.this.nativeResume();
                    }
                });
            }
            if (u && this.s == null) {
                this.s = new FMODAudioDevice();
            }
            if (this.s != null && !this.s.isRunning()) {
                this.s.start();
            }
            if (p.c && (this.l instanceof View)) {
                p.i.c((View) this.l);
            }
        }
    }

    private void h() {
        if (this.j instanceof Activity) {
            float f = 0.0f;
            if (!getSettings().getBoolean("hide_status_bar", true)) {
                Rect rect = new Rect();
                ((Activity) this.j).getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                f = rect.top;
            }
            nativeSetTouchDeltaY(f);
        }
    }

    private void i() {
        unityAndroidInit("assets/bin/", this.j.getApplicationInfo().dataDir + "/lib");
        unityAndroidPrepareGameLoop();
        this.g.d();
    }

    private final native void initJni();

    private static void j() {
        System.loadLibrary("mono");
        int a = J.a();
        if ((a & 2) != 0 && ((a & 128) == 0 || (a & 8) == 0)) {
            m.Log(6, "CPU features not supported! (no ARMv6+ / VFP)");
            return;
        }
        try {
            System.loadLibrary(TapjoyConstants.TJC_PLUGIN_UNITY);
            x.a();
        } catch (UnsatisfiedLinkError e) {
            m.Log(5, "Unable to load libraries: " + e);
        }
    }

    private boolean k() {
        return this.j.getPackageManager().hasSystemFeature("android.hardware.camera") || this.j.getPackageManager().hasSystemFeature("android.hardware.camera.front");
    }

    private void l() {
        String[] a;
        if (this.D.getBoolean("useObb")) {
            for (String str : a(this.j)) {
                String a2 = a(str);
                if (this.D.getBoolean(a2)) {
                    nativeFile(str);
                }
                this.D.remove(a2);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final native int nativeActivityIndicatorStyle();

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeDone();

    private final native void nativeEnableTouchpad(float f, float f2);

    private final native void nativeFile(String str);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeFocusChanged(boolean z);

    private final native String nativeGetGLContext();

    private final native String nativeGetGLScreen();

    private final native int nativeGetLicensePolicy();

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeInit(int i, int i2);

    private final native void nativeInitWWW(Class cls);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeJoyButtonState(int i, int i2, boolean z);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeKeyState(int i, int i2, boolean z, int i3, int i4);

    /* JADX INFO: Access modifiers changed from: private */
    public final native boolean nativePause();

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeQueueGUIEvent(int i, float f, float f2, int i2);

    private final native void nativeRecreateGfxState();

    private final native boolean nativeRender();

    private final native boolean nativeRequested32bitDisplayBuffer();

    private final native int nativeRequestedAA();

    private final native void nativeResize(int i, int i2, int i3, int i4);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeResume();

    private final native void nativeSetExtras(Bundle bundle);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetInputCanceled(boolean z);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetInputString(String str);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetJoystickPosition(int i, int i2, float f);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetMouseButton(int i, boolean z);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetMouseDelta(float f, float f2, float f3);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSetMousePosition(float f, float f2);

    private final native void nativeSetTouchDeltaY(float f);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeSoftInputClosed();

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeTouch(int i, float f, float f2, int i2, long j, int i3);

    /* JADX INFO: Access modifiers changed from: private */
    public final native void nativeVideoFrameCallback(int i, byte[] bArr, int i2, int i3);

    private final native boolean unityAndroidInit(String str, String str2);

    private final native void unityAndroidPrepareGameLoop();

    protected boolean Location_IsServiceEnabledByUser() {
        return this.A.a();
    }

    protected void Location_SetDesiredAccuracy(float f) {
        this.A.b(f);
    }

    protected void Location_SetDistanceFilter(float f) {
        this.A.a(f);
    }

    protected void Location_StartUpdatingLocation() {
        this.A.b();
    }

    protected void Location_StopUpdatingLocation() {
        this.A.c();
    }

    protected void closeCamera(int i) {
        for (a aVar : this.E) {
            if (aVar.a() == i) {
                aVar.c();
                this.E.remove(aVar);
                return;
            }
        }
    }

    public void configurationChanged(Configuration configuration) {
        if (this.l instanceof SurfaceView) {
            ((SurfaceView) this.l).getHolder().setSizeFromLayout();
        }
        if (this.c && configuration.hardKeyboardHidden == 2) {
            ((InputMethodManager) this.j.getSystemService("input_method")).toggleSoftInput(0, 1);
        }
        if (this.F != null) {
            this.F.updateVideoLayout();
        }
    }

    protected boolean dispatchTouchEvent(int i, int i2, final int i3, final float f, final float f2, final long j, final int i4) {
        if (this.g.h() && !this.k) {
            final int i5 = i2 & 255;
            if (i != ((65280 & i2) >> 8)) {
                i5 = 2;
            }
            queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.6
                @Override // java.lang.Runnable
                public final void run() {
                    UnityPlayer.this.nativeTouch(i3, f, f2, i5, j, i4);
                }
            });
        }
        return true;
    }

    protected void enableSensorCompensation(boolean z) {
        this.A.a = z;
    }

    protected void forwardMotionEventToDalvik(long j, long j2, int i, int i2, int[] iArr, float[] fArr, int i3, float f, float f2, int i4, int i5, int i6, int i7, int i8, long[] jArr, float[] fArr2) {
        if (this.d != null) {
            this.d.a(j, j2, i, i2, iArr, fArr, i3, f, f2, i4, i5, i6, i7, i8, jArr, fArr2);
        }
    }

    protected String getCPUType() {
        return J.b();
    }

    protected String getCacheDir() {
        return a("/cache", this.j.getCacheDir());
    }

    protected int getCameraOrientation(int i) {
        if (p.b) {
            h hVar = p.h;
            return h.b(i);
        }
        return 0;
    }

    protected int[] getConnectedJoysticks() {
        if (p.d) {
            return p.j.a();
        }
        return null;
    }

    protected int getDeviceOrientation() {
        int orientation = this.r.getDefaultDisplay().getOrientation();
        boolean z = getResources().getConfiguration().orientation == 2;
        int i = Build.VERSION.SDK_INT >= 9 ? 8 : 0;
        int i2 = Build.VERSION.SDK_INT < 9 ? 1 : 9;
        if (orientation == 0) {
            return z ? 0 : 1;
        } else if (orientation == 1) {
            if (z) {
                return 0;
            }
            return i2;
        } else if (orientation == 2) {
            return z ? i : i2;
        } else if (orientation == 3 && z) {
            return i;
        } else {
            return 1;
        }
    }

    protected String getDeviceUniqueIdentifier() {
        try {
            if (this.B == null) {
                this.B = ((TelephonyManager) this.j.getSystemService("phone")).getDeviceId();
            }
            String str = this.B;
            if (str != null) {
                if (str.length() != 0) {
                    return str;
                }
            }
        } catch (Exception e) {
            m.Log(5, "android.permission.READ_PHONE_STATE not available?");
        }
        return Settings.Secure.getString(this.j.getContentResolver(), TapjoyConstants.TJC_ANDROID_ID);
    }

    protected String getFilesDir() {
        return a("/files", this.j.getFilesDir());
    }

    protected int getGyroUpdateDelay() {
        return this.O;
    }

    protected int getInternetReachability() {
        try {
            if (this.C == null) {
                this.C = ((ConnectivityManager) this.j.getSystemService("connectivity")).getActiveNetworkInfo();
            }
            NetworkInfo networkInfo = this.C;
            if (networkInfo != null && networkInfo.isConnected()) {
                return networkInfo.getType() + 1;
            }
            return 0;
        } catch (Exception e) {
            m.Log(5, "android.permission.ACCESS_NETWORK_STATE not available?");
            return 0;
        }
    }

    protected boolean getIsGyroAvailable() {
        return this.j.getPackageManager().hasSystemFeature("android.hardware.sensor.gyroscope");
    }

    protected boolean getIsGyroEnabled() {
        return this.N;
    }

    protected int[] getJoystickAxes(int i) {
        if (p.d) {
            i iVar = p.j;
            return i.a(i);
        }
        return null;
    }

    protected String getJoystickName(int i) {
        if (p.d) {
            i iVar = p.j;
            return i.b(i);
        }
        return null;
    }

    protected int getNumCameras() {
        if (k()) {
            if (p.b) {
                h hVar = p.h;
                return h.a();
            }
            return 1;
        }
        return 0;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public int getOrientation() {
        if (this.j instanceof Activity) {
            return ((Activity) this.j).getRequestedOrientation();
        }
        return 1;
    }

    protected String getPackageName() {
        return this.j.getPackageName();
    }

    protected float getScreenDPI() {
        if (this.j instanceof Activity) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((Activity) this.j).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            return (displayMetrics.xdpi + displayMetrics.ydpi) * 0.5f;
        }
        return 0.0f;
    }

    protected int getScreenOrientationAngle() {
        return (360 - (this.r.getDefaultDisplay().getOrientation() * 90)) % 360;
    }

    protected int getScreenTimeout() {
        return Settings.System.getInt(this.j.getContentResolver(), "screen_off_timeout", 15000) / 1000;
    }

    public Bundle getSettings() {
        return this.D;
    }

    protected int getTotalMemory() {
        return J.c();
    }

    public View getView() {
        return this;
    }

    protected boolean hasWakeLock() {
        return this.n.isHeld();
    }

    protected void hideSoftInput() {
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.12
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.c) {
                    ((InputMethodManager) UnityPlayer.this.j.getSystemService("input_method")).toggleSoftInput(1, 0);
                    UnityPlayer.this.c = false;
                } else if (UnityPlayer.this.a != null) {
                    UnityPlayer.this.a.dismiss();
                    UnityPlayer.this.a = null;
                }
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void hideVideoPlayer() {
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.18
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.F == null) {
                    return;
                }
                UnityPlayer.this.removeView(UnityPlayer.this.F);
                UnityPlayer.this.F = null;
                UnityPlayer.this.resume();
                UnityPlayer.this.b(false);
            }
        });
    }

    public void init(final int i, final boolean z) {
        if (!x.b()) {
            AlertDialog create = new AlertDialog.Builder(this.j).setTitle("Failure to initialize!").setPositiveButton("OK", new DialogInterface.OnClickListener() { // from class: com.unity3d.player.UnityPlayer.1
                @Override // android.content.DialogInterface.OnClickListener
                public final void onClick(DialogInterface dialogInterface, int i2) {
                    UnityPlayer.this.b();
                }
            }).setMessage("Your hardware does not support this application, sorry!").create();
            create.setCancelable(false);
            create.show();
        } else if (!Build.MANUFACTURER.equalsIgnoreCase("samsung") || Build.VERSION.SDK_INT >= 8 || (J.a() & 16) == 0) {
            a(i, z);
        } else {
            AlertDialog create2 = new AlertDialog.Builder(this.j).setTitle("Old Android OS detected!").setPositiveButton("OK", new DialogInterface.OnClickListener() { // from class: com.unity3d.player.UnityPlayer.11
                @Override // android.content.DialogInterface.OnClickListener
                public final void onClick(DialogInterface dialogInterface, int i2) {
                    UnityPlayer.this.a(i, z);
                }
            }).setMessage("This application requires at least Android OS version 2.2 on Samsung devices. Your device seems to be running an older OS version.\nPlease contact your carrier or the hardware vendor and ask them how to install a more recent version. It is a simple process that your provider's customer service can help you with.").create();
            create2.setCancelable(false);
            create2.show();
        }
    }

    protected int[] initCamera(int i, int i2, int i3, int i4) {
        a aVar = new a(i, i2, i3, i4);
        try {
            aVar.a(this);
            this.E.add(aVar);
            Camera.Size b = aVar.b();
            return new int[]{b.width, b.height};
        } catch (Exception e) {
            m.Log(6, "Unable to initialize camera: " + e.getMessage());
            aVar.c();
            return null;
        }
    }

    protected boolean isCameraFrontFacing(int i) {
        if (p.b) {
            h hVar = p.h;
            return h.a(i);
        }
        return false;
    }

    protected boolean isCompassAvailable() {
        return this.j.getPackageManager().hasSystemFeature("android.hardware.sensor.compass");
    }

    protected boolean isCompassEnabled() {
        return this.P;
    }

    protected boolean isFinishing() {
        return (this.j instanceof Activity) && ((Activity) this.j).isFinishing();
    }

    protected boolean isSensorCompensationEnabled() {
        return this.A.a;
    }

    protected void kill() {
        Process.killProcess(Process.myPid());
    }

    protected boolean loadLibrary(String str) {
        try {
            System.loadLibrary(str);
            return true;
        } catch (Exception e) {
            m.Log(6, "Unknown error " + e);
            return false;
        } catch (UnsatisfiedLinkError e2) {
            m.Log(6, "Unable to find " + str);
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeAttitude(float f, float f2, float f3, float f4, long j);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeCompass(float f, float f2, float f3, float f4, float f5, double d);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeDeviceOrientation(int i);

    final native void nativeForwardEventsToDalvik(boolean z);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeGravity(float f, float f2, float f3, long j);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeGyro(float f, float f2, float f3, long j);

    final native void nativeJoystickRemoved();

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeLinearAcc(float f, float f2, float f3, long j);

    /* JADX INFO: Access modifiers changed from: package-private */
    public final native void nativeSensor(float f, float f2, float f3, long j);

    /* JADX INFO: Access modifiers changed from: protected */
    public native void nativeSetLocation(float f, float f2, float f3, float f4, double d);

    /* JADX INFO: Access modifiers changed from: protected */
    public native void nativeSetLocationStatus(int i);

    @Override // com.unity3d.player.a.InterfaceC0006a
    public void onCameraFrame(final a aVar, final byte[] bArr) {
        if (isFinishing()) {
            return;
        }
        final int a = aVar.a();
        final Camera.Size b = aVar.b();
        queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.15
            @Override // java.lang.Runnable
            public final void run() {
                UnityPlayer.this.nativeVideoFrameCallback(a, bArr, b.width, b.height);
                aVar.a(bArr);
            }
        });
    }

    @Override // android.opengl.GLSurfaceView.Renderer
    public void onDrawFrame(GL10 gl10) {
        if (isFinishing()) {
            return;
        }
        if (!nativeRender()) {
            b();
            return;
        }
        if (this.g.h()) {
            if (!this.g.i()) {
                this.g.e();
                a(false);
            }
        } else if (this.v) {
            this.v = false;
            return;
        } else {
            i();
            nativeResize(this.w, this.x, this.w, this.x);
            nativeResume();
            windowFocusChanged(true);
        }
        if (this.l instanceof w) {
            final w wVar = (w) this.l;
            if (wVar.a(nativeRequested32bitDisplayBuffer(), nativeRequestedAA())) {
                b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.2
                    @Override // java.lang.Runnable
                    public final void run() {
                        if (p.c) {
                            p.i.a((GLSurfaceView) wVar, false);
                        }
                        wVar.onPause();
                        UnityPlayer.this.e.e(wVar);
                        wVar.b();
                        UnityPlayer.this.e.d(wVar);
                        wVar.onResume();
                        if (p.c) {
                            p.i.a((GLSurfaceView) wVar, true);
                        }
                    }
                });
            }
        }
    }

    @Override // android.view.View, android.view.KeyEvent.Callback
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        return b(i, keyEvent);
    }

    @Override // android.view.View
    public boolean onKeyPreIme(int i, KeyEvent keyEvent) {
        return (this.c && i == 4) ? b(i, keyEvent) : super.onKeyPreIme(i, keyEvent);
    }

    @Override // android.view.View, android.view.KeyEvent.Callback
    public boolean onKeyUp(int i, KeyEvent keyEvent) {
        return b(i, keyEvent);
    }

    @Override // android.opengl.GLSurfaceView.Renderer
    public void onSurfaceChanged(GL10 gl10, int i, int i2) {
        int i3;
        int i4;
        if ((this.l instanceof SurfaceView) && ((this.y != 0 || this.z != 0) && (this.y != i || this.z != i2))) {
            setScreenSize(this.y, this.z, p.c ? p.i.b((SurfaceView) this.l) : false);
            i = this.y;
            i2 = this.z;
        }
        if (this.l instanceof View) {
            i4 = ((View) this.l).getWidth();
            i3 = ((View) this.l).getHeight();
        } else {
            i3 = i2;
            i4 = i;
        }
        this.w = i;
        this.x = i2;
        nativeResize(i, i2, i4, i3);
        h();
    }

    @Override // android.opengl.GLSurfaceView.Renderer
    public void onSurfaceCreated(GL10 gl10, EGLConfig eGLConfig) {
        nativeRecreateGfxState();
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int i;
        if (this.g.h() && !this.k) {
            if (p.b) {
                h hVar = p.h;
                i = h.a(motionEvent);
            } else {
                i = 4098;
            }
            if (i == 8194) {
                return b(motionEvent);
            }
            if (i == 16777232) {
                return c(motionEvent);
            }
            int pointerCount = motionEvent.getPointerCount();
            for (int i2 = 0; i2 < pointerCount; i2++) {
                int pointerId = motionEvent.getPointerId(i2);
                int historySize = motionEvent.getHistorySize();
                for (int i3 = 0; i3 < historySize; i3++) {
                    dispatchTouchEvent(i2, 2, pointerId, motionEvent.getHistoricalX(i2, i3), motionEvent.getHistoricalY(i2, i3), motionEvent.getHistoricalEventTime(i3), i);
                }
                dispatchTouchEvent(i2, motionEvent.getAction(), pointerId, motionEvent.getX(i2), motionEvent.getY(i2), motionEvent.getEventTime(), i);
            }
            return true;
        }
        return true;
    }

    protected void openURL(String str) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri parse = Uri.parse(str);
        intent.setData(parse);
        if (parse.isRelative()) {
            intent.setDataAndType(Uri.fromFile(new File(str)), MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(str)));
        }
        this.j.startActivity(intent);
    }

    public void pause() {
        if (this.F != null) {
            this.F.onPause();
            b(false);
            return;
        }
        a(false);
        if (this.g.g()) {
            this.g.c(false);
            this.g.b(true);
            d();
            if (this.s != null) {
                this.s.stop();
            }
            if (this.g.h()) {
                final Semaphore semaphore = new Semaphore(0);
                if (isFinishing()) {
                    this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.24
                        @Override // java.lang.Runnable
                        public final void run() {
                            UnityPlayer.this.nativeDone();
                            semaphore.release();
                        }
                    });
                } else {
                    this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.25
                        @Override // java.lang.Runnable
                        public final void run() {
                            UnityPlayer.this.f();
                            if (!UnityPlayer.this.nativePause()) {
                                semaphore.release();
                                return;
                            }
                            UnityPlayer.this.nativeDone();
                            semaphore.release(2);
                        }
                    });
                }
                try {
                    semaphore.tryAcquire(10L, TimeUnit.SECONDS);
                } catch (InterruptedException e) {
                }
                if (semaphore.drainPermits() > 0) {
                    quit();
                }
            }
            this.j.unregisterReceiver(this.M);
            if (this.f && (this.l instanceof w)) {
                if (this.m != null) {
                    this.m.a();
                }
                this.e.e((View) this.l);
            }
            this.l.onPause();
            c(false);
            d(false);
            this.q.unregisterListener(this.A);
            this.A.d();
            setWakeLock(false);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void queueEvent(final Runnable runnable) {
        if (this.g.h() && !isFinishing()) {
            this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.21
                @Override // java.lang.Runnable
                public final void run() {
                    if (UnityPlayer.this.isFinishing()) {
                        return;
                    }
                    runnable.run();
                }
            });
        }
    }

    public void quit() {
        if (x.b()) {
            removeAllViews();
            this.l.a();
        }
        kill();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void reportSoftInputStr(final String str, final int i, final boolean z) {
        if (i == 1) {
            hideSoftInput();
        }
        queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.14
            @Override // java.lang.Runnable
            public final void run() {
                if (z) {
                    UnityPlayer.this.nativeSetInputString("");
                    UnityPlayer.this.nativeSetInputCanceled(true);
                } else if (str != null) {
                    UnityPlayer.this.nativeSetInputString(str);
                }
                if (i == 1) {
                    UnityPlayer.this.nativeSoftInputClosed();
                }
            }
        });
    }

    public void resume() {
        if (!this.g.i()) {
            a(true);
        }
        this.g.b(false);
        g();
    }

    protected void setCompassEnabled(boolean z) {
        boolean z2 = false;
        if (this.P == z) {
            return;
        }
        if (!z) {
            d(false);
            this.P = z;
            queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.20
                @Override // java.lang.Runnable
                public final void run() {
                    UnityPlayer.this.nativeCompass(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0d);
                }
            });
            return;
        }
        if (z && isCompassAvailable()) {
            z2 = true;
        }
        this.P = z2;
        d(true);
    }

    protected void setGyroEnabled(boolean z) {
        boolean z2 = false;
        if (this.N == z) {
            return;
        }
        if (!z) {
            c(false);
            this.N = z;
            queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.19
                @Override // java.lang.Runnable
                public final void run() {
                    UnityPlayer.this.nativeGyro(0.0f, 0.0f, 0.0f, -1L);
                }
            });
            return;
        }
        if (z && getIsGyroAvailable()) {
            z2 = true;
        }
        this.N = z2;
        c(true);
    }

    protected void setGyroUpdateDelay(int i) {
        this.O = i;
    }

    protected void setHideInputField(boolean z) {
        this.b = z;
    }

    protected void setOrientation(int i) {
        if (this.j instanceof Activity) {
            Activity activity = (Activity) this.j;
            if (i != activity.getRequestedOrientation()) {
                if (Build.VERSION.SDK_INT >= 9 || !(i == 9 || i == 8)) {
                    activity.setRequestedOrientation(i);
                }
            }
        }
    }

    protected void setScreenSize(final int i, final int i2, final boolean z) {
        final boolean z2 = true;
        if (!(this.l instanceof SurfaceView)) {
            m.Log(5, "setScreenSize: Unable to retrieve surface holder");
            return;
        }
        final SurfaceView surfaceView = (SurfaceView) this.l;
        surfaceView.getHolder().getSurfaceFrame();
        final boolean z3 = (surfaceView.getWidth() == i && surfaceView.getHeight() == i2) || (i == 0 && i2 == 0);
        if (i != -1 || i2 != -1) {
            z2 = false;
        }
        if (z2) {
            if (this.y == 0) {
                int i3 = this.z;
            }
        } else if (z3) {
            this.y = 0;
            this.z = 0;
        } else {
            this.y = i;
            this.z = i2;
        }
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.9
            @Override // java.lang.Runnable
            public final void run() {
                if (!z2) {
                    if (z3) {
                        surfaceView.getHolder().setSizeFromLayout();
                    } else {
                        surfaceView.getHolder().setFixedSize(i, i2);
                    }
                    surfaceView.invalidate();
                }
                if (p.c) {
                    p.i.a(surfaceView, z);
                }
            }
        });
    }

    protected void setSoftInputStr(final String str) {
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.13
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.a == null || str == null) {
                    return;
                }
                UnityPlayer.this.a.a(str);
            }
        });
    }

    protected void setWakeLock(boolean z) {
        a("project", this.n, z);
    }

    protected void showSoftInput(final String str, final int i, final boolean z, final boolean z2, final boolean z3, final boolean z4, final String str2) {
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.10
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.b) {
                    ((InputMethodManager) this.j.getSystemService("input_method")).toggleSoftInput(0, 1);
                    UnityPlayer.this.c = true;
                    return;
                }
                UnityPlayer unityPlayer = UnityPlayer.this;
                ContextWrapper contextWrapper = UnityPlayer.this.j;
                UnityPlayer unityPlayer2 = this;
                String str3 = str;
                int i2 = i;
                boolean z5 = z;
                boolean z6 = z2;
                boolean z7 = z3;
                boolean z8 = z4;
                unityPlayer.a = new s(contextWrapper, unityPlayer2, str3, i2, z5, z6, z7, str2);
                UnityPlayer.this.a.show();
            }
        });
    }

    protected void showVideoPlayer(final String str, final int i, final int i2, final int i3, final boolean z, final int i4, final int i5) {
        b(new Runnable() { // from class: com.unity3d.player.UnityPlayer.16
            @Override // java.lang.Runnable
            public final void run() {
                if (UnityPlayer.this.F != null) {
                    return;
                }
                UnityPlayer.this.b(true);
                UnityPlayer.this.pause();
                UnityPlayer.this.F = new y(UnityPlayer.this, UnityPlayer.this.j, str, i, i2, i3, z, i4, i5);
                UnityPlayer.this.addView(UnityPlayer.this.F);
                UnityPlayer.this.F.requestFocus();
            }
        });
    }

    protected void startActivityIndicator() {
        b(this.H);
    }

    protected void stopActivityIndicator() {
        b(this.I);
    }

    protected void vibrate(int i) {
        if (this.t == null) {
            this.t = (Vibrator) this.j.getSystemService("vibrator");
        }
        try {
            if (i == 0) {
                this.t.cancel();
            } else {
                this.t.vibrate(i);
            }
        } catch (Exception e) {
            m.Log(5, "android.permission.VIBRATE not available?");
        }
    }

    protected boolean vibrationSupported() {
        if (this.t == null) {
            this.t = (Vibrator) this.j.getSystemService("vibrator");
        }
        if (p.c) {
            return p.i.a(this.t);
        }
        return true;
    }

    public void windowFocusChanged(final boolean z) {
        this.g.a(z);
        if (z && this.a != null) {
            reportSoftInputStr("", 1, true);
        }
        if (this.g.h()) {
            this.l.queueEvent(new Runnable() { // from class: com.unity3d.player.UnityPlayer.27
                @Override // java.lang.Runnable
                public final void run() {
                    UnityPlayer.this.nativeFocusChanged(z);
                }
            });
        }
        g();
    }
}
