package com.ubisoft.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.drawable.ColorDrawable;
import android.util.Log;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
class LoadingSpinner {
    private static Activity m_context;
    private static ProgressDialog m_progressDialog;

    LoadingSpinner() {
    }

    public static void setContext(Activity context) {
        m_context = context;
        m_context.runOnUiThread(new Runnable() { // from class: com.ubisoft.utils.LoadingSpinner.1
            @Override // java.lang.Runnable
            public void run() {
                Log.d("LoadingSpinner", "===== Creating ProgressDialog");
                LoadingSpinner.m_progressDialog = new ProgressDialog(LoadingSpinner.m_context);
                LoadingSpinner.m_progressDialog.requestWindowFeature(1);
                LoadingSpinner.m_progressDialog.setMessage("Loading...");
                LoadingSpinner.m_progressDialog.setCancelable(false);
                LoadingSpinner.m_progressDialog.getWindow().setBackgroundDrawable(new ColorDrawable(0));
            }
        });
    }

    public static void showLoading() {
        m_context.runOnUiThread(new Runnable() { // from class: com.ubisoft.utils.LoadingSpinner.2
            @Override // java.lang.Runnable
            public void run() {
                Log.d("LoadingSpinner", "===== show ProgressDialog");
                LoadingSpinner.m_progressDialog.show();
            }
        });
    }

    public static void hideLoading() {
        m_context.runOnUiThread(new Runnable() { // from class: com.ubisoft.utils.LoadingSpinner.3
            @Override // java.lang.Runnable
            public void run() {
                Log.d("LoadingSpinner", "===== dismiss ProgressDialog");
                LoadingSpinner.m_progressDialog.dismiss();
            }
        });
    }
}
