package com.ubisoft.social;

import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.widget.WebDialog;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class WebDialogListener implements WebDialog.OnCompleteListener {
    public void onComplete(Bundle values, FacebookException error) {
        if (error != null) {
            if (error instanceof FacebookOperationCanceledException) {
                Log("facebook dialgo cancled....");
                FacebookBindings.FacebookDialogCallback("facebookDialogDidNotComplete", "");
                return;
            }
            Log("facebook dialog got error" + error.getMessage());
            FacebookBindings.FacebookDialogCallback("facebookDialogDidFailWithError", error.getMessage());
            return;
        }
        String postId = values.getString("post_id");
        if (postId != null) {
            String queryParams = values.toString();
            Log("facebook dialog message sent sucess....");
            FacebookBindings.FacebookDialogCallback("facebookDialogDidCompleteWithUrl", queryParams);
            FacebookBindings.FacebookDialogCallback("facebookDialogDidComplete", "");
            return;
        }
        Log("facebook dialog cancled....");
        FacebookBindings.FacebookDialogCallback("facebookDialogDidNotComplete", "");
    }

    private void Log(String string) {
        Log.e("FacebookAndroidPlugin", string);
    }
}
