package com.ubisoft.social;

import android.app.Activity;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.IOException;
import java.util.Locale;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class Utils {
    public static final String TAG = "FacebookAndroid";
    private static boolean pendingPublishReauthorization = false;
    private static Activity s_activity;
    private static Bundle s_bundle;
    private static String s_dialog;

    public static Activity GetGameActivity() {
        return s_activity;
    }

    public static void SetGameActivity(Activity p_activity) {
        if (p_activity != null) {
            Log.v(TAG, "Activity set");
        } else {
            Log.v(TAG, "Activity Called but not set");
        }
        s_activity = p_activity;
    }

    public static void SetPendingReauthorization(boolean _state) {
        pendingPublishReauthorization = _state;
    }

    public static boolean GetPendingReauthorization() {
        return pendingPublishReauthorization;
    }

    public static void SetBundle(Bundle _bundle) {
        s_bundle = _bundle;
    }

    public static void SetDialog(String _dialog) {
        s_dialog = _dialog;
    }

    public static Bundle getBundle() {
        return s_bundle;
    }

    public static String getDialog() {
        return s_dialog;
    }

    public static String getExternalStoragePath() {
        try {
            return String.valueOf(s_activity.getExternalFilesDir(null).getCanonicalPath()) + "/";
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMCC() {
        return Integer.toString(s_activity.getResources().getConfiguration().mcc);
    }

    public static String getMNC() {
        return Integer.toString(s_activity.getResources().getConfiguration().mnc);
    }

    public static String getCountry() {
        TelephonyManager TM = (TelephonyManager) s_activity.getSystemService("phone");
        String NetworkIsoCountry = TM.getNetworkCountryIso();
        if (!NetworkIsoCountry.equals("")) {
            Log.w(TAG, "country from carrier : " + NetworkIsoCountry);
            return NetworkIsoCountry;
        }
        String localeCountry = Locale.getDefault().getCountry();
        Log.w(TAG, "country from locale : " + localeCountry);
        return localeCountry;
    }
}
