package com.ubisoft.social;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.facebook.Session;
import com.facebook.SessionState;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class FacebookLoginActivity extends Activity {
    private static final String TAG = "FacebookAndroid";
    private SharedPreferences m_Prefs;
    private Session session;
    private Session.StatusCallback statusCallback = new SessionStatusCallback(this, null);

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    private class SessionStatusCallback implements Session.StatusCallback {
        private SessionStatusCallback() {
        }

        /* synthetic */ SessionStatusCallback(FacebookLoginActivity facebookLoginActivity, SessionStatusCallback sessionStatusCallback) {
            this();
        }

        public void call(Session session, SessionState state, Exception exception) {
            Log.i("FacebookAndroid", "facebook status call back here  : " + session.getState());
            FacebookLoginActivity.this.updateView();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void updateView() {
        Session session = Session.getActiveSession();
        if (session.isOpened()) {
            Log.i("FacebookAndroid", "Reuse Facebook session access token : " + session.getAccessToken());
            FacebookBindings.FacebookCallback("facebookLoginSucceeded", session.getAccessToken());
            Log.i("FacebookAndroid", "onCreate exiting the activty");
            finish();
        } else if (session.isClosed()) {
            Log.d("Android", "===========FacebookLoginActivity facebookLoginDidFail==========");
            FacebookBindings.FacebookCallback("facebookLoginDidFail", "");
        }
    }

    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d("Android", "===========FacebookLoginActivity onCreate==========");
        FacebookBindings.mActivity = this;
        Intent intent = getIntent();
        String appID = intent.getStringExtra("AppID");
        byte requestID = intent.getByteExtra("RequestID", (byte) -1);
        boolean autoConnect = intent.getBooleanExtra("AutoConnect", true);
        Log.i("FacebookAndroid", "AppID = " + appID);
        Log.i("FacebookAndroid", "RequestID = " + ((int) requestID));
        Log.i("FacebookAndroid", "AutoConnect = " + autoConnect);
        this.m_Prefs = getSharedPreferences("FacebookLoginActivity", 0);
        SharedPreferences.Editor editor = this.m_Prefs.edit();
        editor.putString("FacebookAndroid:facebook_app_id", appID);
        editor.commit();
        this.session = createSession(appID);
        Log.e("facebook", "facebook session created state is " + this.session.getState().equals(SessionState.CREATED_TOKEN_LOADED));
        if (!this.session.getState().isOpened() && !this.session.getState().isClosed()) {
            Log.e("facebook", "facebook session created ");
            Session.OpenRequest request = new Session.OpenRequest(this).setCallback(this.statusCallback);
            this.session.openForRead(request);
            return;
        }
        updateView();
    }

    private Session createSession(String applicationId) {
        Session activeSession = Session.getActiveSession();
        if (activeSession == null || activeSession.getState().isClosed()) {
            Session activeSession2 = new Session.Builder(Utils.GetGameActivity()).setApplicationId(applicationId).build();
            Session.setActiveSession(activeSession2);
            return activeSession2;
        }
        return activeSession;
    }

    @Override // android.app.Activity
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.i("FacebookAndroid", "Enter onActivityResult");
        if (Session.getActiveSession() != null) {
            Session.getActiveSession().onActivityResult(this, requestCode, resultCode, data);
        }
        Log.i("FacebookAndroid", "Leave onActivityResult exiting the activity");
        Log.d("Android", "=========onActivityResult Finish========");
        FacebookBindings.mActivity = null;
        finish();
    }
}
