package com.ubisoft.social;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.widget.WebDialog;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class FacebookDialogActivity extends Activity {
    private static final String TAG = "FacebookAndroid";
    private Session session;
    private Session.StatusCallback statusCallback = new SessionStatusCallback(this, null);
    private final List<String> PERMISSIONS = Arrays.asList("publish_actions");

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    private class SessionStatusCallback implements Session.StatusCallback {
        private SessionStatusCallback() {
        }

        /* synthetic */ SessionStatusCallback(FacebookDialogActivity facebookDialogActivity, SessionStatusCallback sessionStatusCallback) {
            this();
        }

        public void call(Session session, SessionState state, Exception exception) {
            Log.i("FacebookAndroid", "facebook status call back here  : " + session.getState());
            if (Utils.GetPendingReauthorization() && state.equals(SessionState.OPENED_TOKEN_UPDATED)) {
                Utils.SetPendingReauthorization(false);
                FacebookDialogActivity.ShowDialog(Utils.getDialog(), Utils.getBundle());
            } else if (state.equals(SessionState.CLOSED) || state.equals(SessionState.CLOSED_LOGIN_FAILED)) {
                FacebookBindings.FacebookDialogCallback("facebookDialogDidNotComplete", "");
            }
        }
    }

    private boolean isSubsetOf(Collection<String> subset, Collection<String> superset) {
        for (String string : subset) {
            if (!superset.contains(string)) {
                return false;
            }
        }
        return true;
    }

    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d("FacebookAndroid", "===========FacebookFetchPermissionsActivity onCreate==========");
        FacebookBindings.mActivity = this;
        this.session = Session.getActiveSession();
        if (this.session != null) {
            List<String> permissions = this.session.getPermissions();
            if (!isSubsetOf(this.PERMISSIONS, permissions) && !Utils.GetPendingReauthorization()) {
                Utils.SetPendingReauthorization(true);
                this.session.addCallback(this.statusCallback);
                Session.NewPermissionsRequest newPermissionsRequest = new Session.NewPermissionsRequest(this, this.PERMISSIONS);
                this.session.requestNewPublishPermissions(newPermissionsRequest);
                return;
            }
            ShowDialog(Utils.getDialog(), Utils.getBundle());
            finish();
            return;
        }
        Log.d("FacebookAndroid", "===========FacebookDialogActivity : Facebook Session Not found onCreate==========");
        FacebookBindings.FacebookDialogCallback("facebookDialogDidNotComplete", "");
    }

    public static void ShowDialog(String dialogType, final Bundle bundle) {
        Activity gameActivity = Utils.GetGameActivity();
        Log.v("FacebookAndroid", "Enter FacebookDialogActivity.ShowDialog(" + dialogType + ")");
        if (gameActivity != null) {
            Log.v("FacebookAndroid", "game activity not null....");
            gameActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.social.FacebookDialogActivity.1
                @Override // java.lang.Runnable
                public void run() {
                    try {
                        WebDialog dialog = new WebDialog.FeedDialogBuilder(Utils.GetGameActivity(), Session.getActiveSession(), bundle).setOnCompleteListener(new WebDialogListener()).build();
                        dialog.show();
                    } catch (Exception e) {
                        Log.e("FacebookAndroid", "facebook post exception " + e);
                    }
                }
            });
        } else {
            Log.e("FacebookAndroid", "Null Activity : No active game activity found : FacebookDialogActivity");
        }
        Log.v("FacebookAndroid", "Leave FacebookDialogActivity.ShowDialog");
    }

    @Override // android.app.Activity
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.i("FacebookAndroid", "Enter onActivityResult FacebookDialogActivity");
        if (Session.getActiveSession() != null) {
            Session.getActiveSession().onActivityResult(this, requestCode, resultCode, data);
        }
        Log.i("FacebookAndroid", "Leave onActivityResult exiting the FacebookDialogActivity");
        finish();
    }
}
