package com.ubisoft.social;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.facebook.Settings;
import com.facebook.android.Facebook;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class FacebookBindings {
    private static final String TAG = "FacebookAndroid";
    private static Facebook m_Facebook;
    private static Field m_unityPlayerActivityField;
    private static Class<?> m_unityPlayerClasss;
    private static Method m_unitySendMessageMethod;
    private static FacebookBindings m_instacnce = null;
    public static Activity mActivity = null;
    public static Activity m_gameActivity = null;
    public static boolean pendingPublishReauthorization = false;

    private static void UnitySendMessage(String go, String m, String p) {
        Log.d("Android", "================UnitySendMessage================");
        if (m_unitySendMessageMethod != null) {
            try {
                Log.d("Android", "================m_unitySendMessageMethod================");
                Log.i("FacebookAndroid", "UnitySendMessage : " + go + " callback :" + m + " param: " + p);
                Log.d("Android", "==========go = " + go);
                Log.d("Android", "==========m = " + m);
                Log.d("Android", "==========p = " + p);
                m_unitySendMessageMethod.invoke(null, go, m, p);
                if (mActivity != null) {
                    Log.d("Android", "=========mActivity Not Null======");
                    mActivity.finish();
                } else {
                    Log.d("Android", "=========mActivity Null=======");
                }
                return;
            } catch (IllegalAccessException e) {
                Log.d("Android", "================IllegalAccessException================");
                Log.i("FacebookAndroid", "could not find UnitySendMessage method: " + e.getMessage());
                return;
            } catch (IllegalArgumentException e2) {
                Log.d("Android", "================IllegalArgumentException================");
                Log.i("FacebookAndroid", "could not find UnitySendMessage method: " + e2.getMessage());
                return;
            } catch (InvocationTargetException e3) {
                Log.d("Android", "================InvocationTargetException================");
                Log.i("FacebookAndroid", "could not find UnitySendMessage method: " + e3.getMessage());
                return;
            }
        }
        Log.d("Android", "================else UnitySendMessage================");
        Log.i("FacebookAndroid", "UnitySendMessage: " + go + ", " + m + ", " + p);
    }

    public static void FacebookCallback(String callbackfuntion, String param) {
        Log.d("Android", "==========FacebookCallback========");
        UnitySendMessage("FacebookManager", callbackfuntion, param);
    }

    public static void GraphAPICallback(String p_friends, byte p_requestID) {
        Log.d("Android", "==========GraphAPICallback========");
        String json = GraphAPICallbackToJSON(p_friends, p_requestID);
        UnitySendMessage("FacebookManager", "graphAPICallback", json);
    }

    public static void FacebookDialogCallback(String callbackfuntion, String param) {
        Log.d("Android", "==========FacebookDialogCallback========");
        UnitySendMessage("FacebookManager", callbackfuntion, param);
    }

    public static FacebookBindings instance() {
        if (m_instacnce == null) {
            Log.d("Android", "==========FacebookBindings instance========");
            m_instacnce = new FacebookBindings();
            try {
                Log.d("Android", "==========FacebookBindings try========");
                m_unityPlayerClasss = Class.forName("com.unity3d.player.UnityPlayer");
                m_unitySendMessageMethod = m_unityPlayerClasss.getMethod("UnitySendMessage", String.class, String.class, String.class);
                m_unityPlayerActivityField = m_unityPlayerClasss.getField("currentActivity");
                m_gameActivity = (Activity) m_unityPlayerActivityField.get(m_unityPlayerClasss);
                Utils.SetGameActivity(m_gameActivity);
            } catch (ClassNotFoundException e) {
                Log.d("Android", "==========FacebookBindings catch (ClassNotFoundException e) ========");
                Log.i("FacebookAndroid", "could not find UnityPlayer class: " + e.getMessage());
            } catch (Exception e2) {
                Log.d("Android", "==========FacebookBindings catch (Exception e)========");
                Log.i("FacebookAndroid", "unkown exception occurred locating UnityPlayer.currentActivity: " + e2.getMessage());
            }
        }
        return m_instacnce;
    }

    private static String GraphAPICallbackToJSON(String p_friends, byte p_requestID) {
        JSONObject root = new JSONObject();
        try {
            root.put("p_friends", p_friends);
            root.put("requestID", (int) p_requestID);
            return root.toString();
        } catch (JSONException e) {
            Log.e("FacebookAndroid", "error encoding JSON: " + e.getMessage());
            return "";
        }
    }

    public static void FacebookAuthorize(String p_appID, byte p_requestID, String[] p_permissions) {
        Log.d("Android", "========FacebookAuthorize=======");
        Log.v("FacebookAndroid", "Enter FacebookBindings.FacebookAuthorize(" + p_appID + ", " + ((int) p_requestID) + ")");
        Context c = Utils.GetGameActivity();
        if (c != null) {
            Intent intent = new Intent(c, FacebookLoginActivity.class);
            intent.putExtra("AppID", p_appID);
            intent.putExtra("RequestID", p_requestID);
            intent.putExtra("AutoConnect", false);
            if (p_permissions != null) {
                Log.d("Android", "========FacebookAuthorize if (p_permissions != null)=======");
                Log.d("Android", "========FacebookAuthorize if p_permissions.length = " + p_permissions.length);
                String[] permissionArray = new String[p_permissions.length];
                for (int i = 0; i < p_permissions.length; i++) {
                    Log.v("FacebookAndroid", "Enter FacebookBindings.FacebookAuthorize: permissions : " + p_permissions[i]);
                    permissionArray[i] = p_permissions[i];
                }
                intent.putExtra("FbPermissions", permissionArray);
            }
            Log.d("Android", "========FacebookAuthorize startActivity=======");
            c.startActivity(intent);
        } else {
            Log.e("FacebookAndroid", "Null Activity : You need to initialise the mobile SDK before calling: FacebookBindings.FacebookAuthorize");
        }
        Log.v("FacebookAndroid", "Leave FacebookBindings.FacebookAuthorize");
    }

    public static void FacebookAutoConnect(String p_appID, byte p_requestID) {
        Log.v("FacebookAndroid", "Enter FacebookBindings.FacebookAutoConnect(" + p_appID + ", " + ((int) p_requestID) + ")");
        Context c = Utils.GetGameActivity();
        if (c != null) {
            Intent intent = new Intent(c, FacebookLoginActivity.class);
            intent.putExtra("AppID", p_appID);
            intent.putExtra("RequestID", p_requestID);
            intent.putExtra("AutoConnect", true);
            c.startActivity(intent);
        } else {
            Log.e("FacebookAndroid", "Null Activity : You need to initialise the mobile SDK before calling: FacebookBindings.FacebookAuthorize");
        }
        Log.v("FacebookAndroid", "Leave FacebookBindings.FacebookAuthorize");
    }

    public static void FacebookDialog(String dialogType, Bundle bundle) {
        Log.v("FacebookAndroid", "Enter FacebookBindings.FacebookDialog(" + dialogType + ")");
        Activity c = m_gameActivity;
        Utils.SetDialog(dialogType);
        Utils.SetBundle(bundle);
        if (c != null) {
            Intent intent = new Intent(c, FacebookDialogActivity.class);
            c.startActivity(intent);
        } else {
            Log.e("FacebookAndroid", "Null Activity : No game activity is active : FacebookBindings.FacebookAuthorize");
        }
        Log.v("FacebookAndroid", "Leave FacebookBindings.FacebookDialog");
    }

    public static void informFacebookInstall(String appID) {
        Log.i("FacebookAndroid", "informFacebookInstall from plugin...." + (m_gameActivity != null));
        if (Settings.getAttributionId(m_gameActivity.getContentResolver()) != null) {
            Settings.publishInstallAsync(m_gameActivity, appID);
        }
    }

    public static void GraphAPIRequest(String p_request, Bundle p_requestParams, String p_httpMethod, byte p_requestID) {
        Log.v("FacebookAndroid", "Enter FacebookBindings.GraphAPIRequest(" + p_request + ", " + p_requestParams + ")");
        if (m_Facebook == null) {
            Log.w("FacebookAndroid", "Facebook variable is not initialized, ignore Graph API request");
        } else {
            Log.v("FacebookAndroid", "Leave FacebookBindings.GraphAPIRequest");
        }
    }
}
