package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class WebNewsActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "WebNewsActivity";

    @Override // android.app.Activity
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        String URL = intent.getStringExtra("URL");
        RelativeLayout.LayoutParams buttonLayoutParam = new RelativeLayout.LayoutParams(-2, -2);
        buttonLayoutParam.addRule(11);
        Button buttonClose = new Button(this);
        buttonClose.setLayoutParams(buttonLayoutParam);
        buttonClose.setText("Close");
        buttonClose.setOnClickListener(this);
        RelativeLayout.LayoutParams textViewParam = new RelativeLayout.LayoutParams(-2, -2);
        textViewParam.addRule(13);
        textViewParam.addRule(15);
        TextView moreGamesTextView = new TextView(this);
        moreGamesTextView.setLayoutParams(textViewParam);
        moreGamesTextView.setText("Get More Games !");
        LinearLayout.LayoutParams relLayoutParam = new LinearLayout.LayoutParams(-1, -2);
        RelativeLayout relLayout = new RelativeLayout(this);
        relLayout.setLayoutParams(relLayoutParam);
        relLayout.addView(buttonClose);
        relLayout.addView(moreGamesTextView);
        LinearLayout.LayoutParams webViewLayoutParam = new LinearLayout.LayoutParams(-1, -1);
        WebView webView = new WebView(this);
        webView.setLayoutParams(webViewLayoutParam);
        LinearLayout.LayoutParams layoutParam = new LinearLayout.LayoutParams(-1, -1);
        LinearLayout l1 = new LinearLayout(this);
        l1.setLayoutParams(layoutParam);
        l1.setOrientation(1);
        l1.addView(relLayout);
        l1.addView(webView);
        addContentView(l1, layoutParam);
        try {
            webView.getSettings().setJavaScriptEnabled(true);
            webView.loadUrl(URL);
        } catch (Exception e) {
            Log.e(TAG, e.getMessage());
        }
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View v) {
        finish();
    }
}
