package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class WebNews extends NewsManagerBase {
    private static final String PREFS_ID_ADS_ID = "WebNews_ID";
    private static final String PREFS_NAME = "WebNewsPrefFile";
    private static final String TAG = "WebNews";
    private static WebNews mObjWebNews;
    private int mCurAdOnServer;
    private boolean mHasNewWebNews;
    private boolean mIsNewsAvailable;
    private String mURL;
    private long mUpdateInterval;
    private WebView mWebView;

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ DataTrackeringListener getDataTrackingListener() {
        return super.getDataTrackingListener();
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ void setDataTrackingListener(DataTrackeringListener dataTrackeringListener) {
        super.setDataTrackingListener(dataTrackeringListener);
    }

    public boolean isNewsAvailable() {
        return this.mIsNewsAvailable;
    }

    public boolean hasNewWebNews() {
        return this.mHasNewWebNews;
    }

    public void setURL(String URL) {
        this.mURL = URL;
    }

    public void setMinimumUpdateIntervalSeconds(long updateInterval) {
        this.mUpdateInterval = updateInterval;
    }

    private WebNews(Context context, String packageName_) {
        super(context, packageName_);
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        int iPrevAdID = settings.getInt(PREFS_ID_ADS_ID, -1);
        this.mHasNewWebNews = iPrevAdID == -1;
        this.mIsNewsAvailable = false;
        this.mCurAdOnServer = -1;
    }

    public static void createInstance(Context context, String packageName_) {
        if (mObjWebNews != null) {
            mObjWebNews = null;
        }
        mObjWebNews = new WebNews(context, packageName_);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void createWebView() {
        try {
            this.mWebView = new WebView(this.context);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.addJavascriptInterface(this, "MY_JS");
            this.mWebView.setWebViewClient(new WebViewClient() { // from class: com.ubisoft.crosspromotion.WebNews.1
                @Override // android.webkit.WebViewClient
                public void onPageFinished(WebView view, String url) {
                    Log.v(WebNews.TAG, "onPageFinished");
                    view.loadUrl("javascript:window.MY_JS.receiveVersionFromJs(document.getElementById('version').innerHTML);");
                }

                @Override // android.webkit.WebViewClient
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    Log.v(WebNews.TAG, "onPageStarted ");
                    WebNews.this.mIsNewsAvailable = true;
                }
            });
        } catch (Exception e) {
            Log.e(TAG, "exception " + e.getMessage());
        }
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    void fetchNewsFromServer() {
        Log.d(TAG, "fetchNewsFromServer started");
        Activity currentActivity = (Activity) this.context;
        final String url = this.mURL;
        currentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.WebNews.2
            @Override // java.lang.Runnable
            public void run() {
                WebNews.this.mWebView.loadUrl(url);
            }
        });
    }

    public void receiveVersionFromJs(String str) {
        Log.v(TAG, "receiveVersionFromJs " + str);
        int iAdID = Integer.parseInt(str);
        SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
        int iPrevAdID = settings.getInt(PREFS_ID_ADS_ID, -1);
        this.mCurAdOnServer = iAdID;
        if (iPrevAdID != iAdID) {
            this.mHasNewWebNews = true;
        }
    }

    public static WebNews getInstance() {
        if (mObjWebNews == null) {
            Log.e(TAG, "Web News Instance is not created. : ");
        }
        return mObjWebNews;
    }

    public void startComponent() {
        if (isMemoryCriteriaSatisfied(this.context) && mObjWebNews != null) {
            Log.v(TAG, "WebNews Started");
            Activity currentActivity = (Activity) this.context;
            final long updateInterval = this.mUpdateInterval;
            currentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.WebNews.3
                @Override // java.lang.Runnable
                public void run() {
                    WebNews.this.createWebView();
                    if (updateInterval != 0) {
                        Timer timer = new Timer();
                        timer.schedule(new TimerTask() { // from class: com.ubisoft.crosspromotion.WebNews.3.1
                            @Override // java.util.TimerTask, java.lang.Runnable
                            public void run() {
                                WebNews.this.fetchNewsFromServer();
                            }
                        }, 0L, updateInterval);
                    }
                }
            });
        }
    }

    public void showWebNewsDialog() {
        Log.v(TAG, "showWebNewsDialog");
        if (this.mIsNewsAvailable) {
            this.m_counter++;
            if (this.dataTrackingListener != null) {
                this.dataTrackingListener.onLogEvent("CrossPromotion : WebNews shown");
            }
            SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putInt(PREFS_ID_ADS_ID, this.mCurAdOnServer);
            editor.commit();
            Intent intent = new Intent(this.context, WebNewsActivity.class);
            intent.putExtra("URL", this.mURL);
            this.context.startActivity(intent);
            Log.v(TAG, "Started WebNewsActivity Intent");
            this.mHasNewWebNews = false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public void downloadingCompleted(boolean isSuccess, Vector<Integer> vec_adsID) {
    }
}
