package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.flurry.android.AdCreative;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UrgentNewsActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "UrgentNewsActivity";
    protected DataTrackeringListener dataTrackingListener;
    FrameLayout mFrameLayout;
    ImageView mImageURL;
    ImageView mImageURLDlg;
    String mStrDirPath;
    String mStrFileName;

    public void setDataTrackingListener(DataTrackeringListener dataTrackingListener) {
        this.dataTrackingListener = dataTrackingListener;
    }

    @Override // android.app.Activity
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setDataTrackingListener(UrgentNews.getInstance().getDataTrackingListener());
        FrameLayout.LayoutParams flParam = new FrameLayout.LayoutParams(-2, -2);
        flParam.gravity = 17;
        this.mImageURLDlg = new ImageView(this);
        this.mImageURLDlg.setLayoutParams(flParam);
        this.mImageURL = new ImageView(this);
        this.mImageURL.setLayoutParams(flParam);
        FrameLayout.LayoutParams frmLayParam = new FrameLayout.LayoutParams(-1, -1);
        frmLayParam.gravity = 17;
        this.mFrameLayout = new FrameLayout(this);
        this.mFrameLayout.setLayoutParams(frmLayParam);
        Intent intent = getIntent();
        String packageName = intent.getStringExtra("packageName");
        this.mStrDirPath = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/Android/data/" + packageName;
        this.mStrFileName = "urgentNews.json";
        File file = new File(this.mStrDirPath, this.mStrFileName);
        StringBuilder text = new StringBuilder();
        try {
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                while (true) {
                    String line = br.readLine();
                    if (line == null) {
                        break;
                    }
                    text.append(line);
                }
                String strJson = new String(text);
                Log.d(TAG, strJson);
                if (!parseAndProcessJson(strJson)) {
                    Log.d(TAG, " !parseAndProcessJson");
                    finish();
                }
            } else {
                Log.d(TAG, " !file.exists()");
                finish();
            }
        } catch (IOException e) {
            Log.d(TAG, "Exception " + e.getMessage());
        }
        setContentView(this.mFrameLayout, frmLayParam);
    }

    boolean parseAndProcessJson(String strJson) {
        float scalefactor;
        String strImageUrl = "";
        try {
            JSONArray jsonReply = new JSONArray(strJson);
            JSONObject jobj = jsonReply.getJSONObject(0);
            try {
                String strTemp = jobj.getString("imageUrl");
                int indexOfSlash = strTemp.lastIndexOf(47);
                strImageUrl = strTemp.substring(indexOfSlash + 1);
            } catch (Exception e) {
                Log.d(TAG, "parseAndProcessJson " + e.getMessage());
            }
            try {
                String strTemp2 = jobj.getString("imageUrlDlg");
                int indexOfSlash2 = strTemp2.lastIndexOf(47);
                String strImageUrlDlg = strTemp2.substring(indexOfSlash2 + 1);
                String str = String.valueOf(this.mStrDirPath) + "/" + strImageUrl;
                Bitmap bm = LoadImage(String.valueOf(this.mStrDirPath) + "/" + strImageUrlDlg);
                if (bm != null) {
                    Display display = getWindowManager().getDefaultDisplay();
                    int displayWidth = display.getWidth();
                    int displayHeight = display.getHeight();
                    float bmWidth = bm.getWidth();
                    float bmHeight = bm.getHeight();
                    if (displayWidth < displayHeight) {
                        scalefactor = (displayWidth - (displayWidth / 10)) / bmWidth;
                    } else {
                        scalefactor = (displayHeight - (displayHeight / 10)) / bmHeight;
                    }
                    try {
                        Bitmap bitmap = Bitmap.createScaledBitmap(bm, (int) (bmWidth * scalefactor), (int) (bmHeight * scalefactor), false);
                        this.mImageURLDlg.setImageBitmap(bitmap);
                        this.mFrameLayout.addView(this.mImageURLDlg);
                        try {
                            int iButtons = jobj.getInt("buttons");
                            int bitmapWidth = bitmap.getWidth();
                            int bitmapHeight = bitmap.getHeight();
                            for (int i = 1; i <= iButtons; i++) {
                                int x = jobj.getInt("x" + i);
                                int y = jobj.getInt("y" + i);
                                int width = jobj.getInt(AdCreative.kFixWidth + i);
                                int height = jobj.getInt(AdCreative.kFixHeight + i);
                                Button btn = new Button(this);
                                btn.setBackgroundColor(0);
                                btn.setWidth((int) (width * scalefactor));
                                btn.setHeight((int) (height * scalefactor));
                                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                                lp.gravity = 51;
                                lp.leftMargin = (int) (((displayWidth / 2) - (bitmapWidth / 2)) + (x * scalefactor));
                                lp.topMargin = (int) (((displayHeight / 2) - (bitmapHeight / 2)) + (y * scalefactor));
                                if (i != iButtons) {
                                    btn.setTag(jobj.getString("targetUrl" + i));
                                }
                                this.mFrameLayout.addView(btn, lp);
                                Log.d(TAG, "Button Added " + i + "leftMargin " + lp.leftMargin + "topMargin " + lp.topMargin);
                                btn.setOnClickListener(this);
                            }
                            return true;
                        } catch (Exception e2) {
                            Log.d(TAG, "parseAndProcessJson " + e2.getMessage());
                            return false;
                        }
                    } catch (Exception e1) {
                        Log.d(TAG, "Bitmap not created " + e1.getMessage());
                        return false;
                    }
                }
                return false;
            } catch (Exception e3) {
                Log.d(TAG, "parseAndProcessJson " + e3.getMessage());
                return false;
            }
        } catch (Exception e4) {
            Log.d(TAG, "parseAndProcessJson " + e4.getMessage());
            return false;
        }
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View v) {
        Object obj = v.getTag();
        if (obj == null) {
            if (this.dataTrackingListener != null) {
                this.dataTrackingListener.onLogEvent("CrossPromotion : UrgentNews Closed");
            }
            finish();
            return;
        }
        String strURL = (String) obj;
        if (this.dataTrackingListener != null) {
            HashMap<String, String> params = new HashMap<>();
            params.put("URL", strURL);
            this.dataTrackingListener.onLogEvent("CrossPromotion : UrgentNews continued to URL", params);
        }
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse(strURL));
        startActivity(browserIntent);
        finish();
    }

    private Bitmap LoadImage(String strURL) {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile(strURL);
        } catch (Exception e) {
            Log.d(TAG, "LoadImage Could not load " + strURL + "Execption: " + e.getMessage());
        }
        if (bitmap == null) {
            Log.e(TAG, "LoadImage NULL");
        }
        return bitmap;
    }
}
