package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class UrgentNews extends NewsManagerBase {
    private static final String PREFS_ID_ADS_ID = "UrgentNews_adsID";
    private static final String PREFS_ID_COUNTER = "UrgentNews_Counter";
    private static final String PREFS_ID_ISLAUNCHED = "UrgentNews_isLaunched";
    private static final String PREFS_ID_IS_SUCCESS = "UrgentNews_isSuccess";
    private static final String PREFS_NAME = "UrgentNewsPrefFile";
    private static final String TAG = "UrgentNews";
    private static UrgentNews mObjUrgentNews;
    private DownloadManager mDThread;
    private String mURL;
    private long mUpdateInterval;

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ DataTrackeringListener getDataTrackingListener() {
        return super.getDataTrackingListener();
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ void setDataTrackingListener(DataTrackeringListener dataTrackeringListener) {
        super.setDataTrackingListener(dataTrackeringListener);
    }

    public void setURL(String URL) {
        this.mURL = URL;
    }

    public void setMinimumUpdateIntervalSeconds(long updateInterval) {
        this.mUpdateInterval = updateInterval;
    }

    private UrgentNews(Context context, String packageName_) {
        super(context, packageName_);
    }

    public static void createInstance(Context context, String packageName_) {
        if (mObjUrgentNews != null) {
            mObjUrgentNews = null;
        }
        mObjUrgentNews = new UrgentNews(context, packageName_);
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    void fetchNewsFromServer() {
        if (this.mDThread != null && this.mDThread.isAlive()) {
            Log.d(TAG, "fetchNewsFromServer returning");
            return;
        }
        Log.d(TAG, "fetchNewsFromServer started");
        try {
            SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
            boolean isSuccess = settings.getBoolean(PREFS_ID_IS_SUCCESS, false);
            String strCurSavedAdsIDs = settings.getString(PREFS_ID_ADS_ID, "-1");
            if (isSuccess) {
                this.mDThread = new DownloadManager(this.mURL, this.packageName, "urgentNews.json", this, strCurSavedAdsIDs);
            } else {
                this.mDThread = new DownloadManager(this.mURL, this.packageName, "urgentNews.json", this, "-1");
            }
            this.mDThread.setUrgentNewsDownloader(true);
            this.mDThread.start();
        } catch (Exception e) {
            Log.d(TAG, "fetchNewsFromServer exception " + e.getMessage());
        }
        Log.d(TAG, "fetchNewsFromServer end");
    }

    public static UrgentNews getInstance() {
        if (mObjUrgentNews == null) {
            Log.e(TAG, "Urgent News Instance is not created Call create instance first ");
        }
        return mObjUrgentNews;
    }

    public void startComponent() {
        Log.e(TAG, "UrgentNews started");
        if (isMemoryCriteriaSatisfied(this.context) && mObjUrgentNews != null) {
            Activity currentActivity = (Activity) this.context;
            final long updateInterval = this.mUpdateInterval;
            currentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.UrgentNews.1
                @Override // java.lang.Runnable
                public void run() {
                    if (updateInterval != 0) {
                        Timer timer = new Timer();
                        timer.schedule(new TimerTask() { // from class: com.ubisoft.crosspromotion.UrgentNews.1.1
                            @Override // java.util.TimerTask, java.lang.Runnable
                            public void run() {
                                UrgentNews.this.fetchNewsFromServer();
                            }
                        }, 0L, updateInterval);
                    }
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean canLaunchUrgentNews() {
        boolean canLaunch = false;
        SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
        boolean isAlreadyLaunched = settings.getBoolean(PREFS_ID_ISLAUNCHED, false);
        if (isAlreadyLaunched) {
            Log.e(TAG, "canLaunchUrgentNews isAlreadyLaunched");
            return false;
        }
        int iCounter = 0;
        this.m_counter = settings.getInt(PREFS_ID_COUNTER, 0);
        String strDirPath = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/Android/data/" + this.packageName;
        File file = new File(strDirPath, "urgentNews.json");
        StringBuilder text = new StringBuilder();
        try {
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                while (true) {
                    String line = br.readLine();
                    if (line == null) {
                        break;
                    }
                    text.append(line);
                }
                String strJson = new String(text);
                JSONArray jsonReply = new JSONArray(strJson);
                JSONObject jobj = jsonReply.getJSONObject(0);
                iCounter = jobj.getInt("launchesUntilView");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error while checking can launch counter parameter." + e.getMessage());
        }
        this.m_counter++;
        if (iCounter == 0) {
            canLaunch = true;
        }
        if (this.m_counter >= iCounter) {
            canLaunch = true;
        }
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(PREFS_ID_COUNTER, this.m_counter);
        if (canLaunch) {
            this.m_counter = 0;
        }
        editor.commit();
        return canLaunch;
    }

    public void showUrgentNewsDialog() {
        boolean canLaunch = canLaunchUrgentNews();
        if (canLaunch && this.mDThread != null && !this.mDThread.isAlive()) {
            this.m_counter++;
            if (this.dataTrackingListener != null) {
                this.dataTrackingListener.onLogEvent("CrossPromotion : UrgentNews shown");
            }
            Activity currentActivity = (Activity) this.context;
            final String packageName_ = this.packageName;
            currentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.UrgentNews.2
                @Override // java.lang.Runnable
                public void run() {
                    SharedPreferences settings = UrgentNews.this.context.getSharedPreferences(UrgentNews.PREFS_NAME, 0);
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putBoolean(UrgentNews.PREFS_ID_ISLAUNCHED, true);
                    editor.commit();
                    Intent intent = new Intent(UrgentNews.this.context, UrgentNewsActivity.class);
                    intent.putExtra("packageName", packageName_);
                    UrgentNews.this.context.startActivity(intent);
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public void downloadingCompleted(boolean isSuccess, Vector<Integer> vec_adsID) {
        String strAds = "";
        int count = vec_adsID.size();
        for (int i = 0; i < count; i++) {
            if (i != 0) {
                strAds = String.valueOf(strAds) + ",";
            }
            Integer integer = vec_adsID.elementAt(i);
            strAds = String.valueOf(strAds) + integer.intValue();
        }
        SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
        String downloadedStrAds = settings.getString(PREFS_ID_ADS_ID, "");
        if (!downloadedStrAds.equalsIgnoreCase(strAds)) {
            SharedPreferences.Editor editor = settings.edit();
            editor.putBoolean(PREFS_ID_IS_SUCCESS, isSuccess);
            editor.putString(PREFS_ID_ADS_ID, strAds);
            editor.putInt(PREFS_ID_COUNTER, 0);
            if (isSuccess) {
                editor.putBoolean(PREFS_ID_ISLAUNCHED, false);
            }
            editor.commit();
        }
    }
}
