package com.ubisoft.crosspromotion;

import android.graphics.Point;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class SlideInAnimator implements CustomAnimator {
    AnimationSource animationSource;
    long duration;

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void startAnimationForSource(AnimationSource animationSource, ImageView imgView, Point margin, int imgWidth, int imgHeight) {
        float fromXDelta = 0.0f;
        float fromYDelta = 0.0f;
        this.animationSource = animationSource;
        switch (this.animationSource.getAlignment()) {
            case 1:
                fromYDelta = -imgHeight;
                break;
            case 2:
                fromXDelta = -imgWidth;
                break;
            case 3:
                fromYDelta = imgHeight;
                break;
            case 4:
                fromXDelta = imgWidth;
                break;
        }
        TranslateAnimation animation = new TranslateAnimation(fromXDelta, 0.0f, fromYDelta, 0.0f);
        animation.setDuration(this.duration);
        animation.setFillAfter(true);
        imgView.setAnimation(animation);
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void startReverseAnimationForSource(AnimationSource animationSource, ImageView imgView, Point margin, int imgWidth, int imgHeight) {
        float toXDelta = 0.0f;
        float toYDelta = 0.0f;
        this.animationSource = animationSource;
        switch (this.animationSource.getAlignment()) {
            case 1:
                toYDelta = -imgHeight;
                break;
            case 2:
                toXDelta = -imgWidth;
                break;
            case 3:
                toYDelta = imgHeight;
                break;
            case 4:
                toXDelta = imgWidth;
                break;
        }
        TranslateAnimation animation = new TranslateAnimation(0.0f, toXDelta, 0.0f, toYDelta);
        animation.setDuration(this.duration);
        animation.setFillAfter(true);
        imgView.setAnimation(animation);
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public long getDuration() {
        return this.duration;
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public boolean isAnimationRunning() {
        return false;
    }
}
