package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.util.Vector;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
abstract class NewsManagerBase {
    private static final String TAG = "NewsManagerBase";
    public static final long THRESHOLD_AVAILABLE_MBYTES = 5;
    protected Context context;
    protected DataTrackeringListener dataTrackingListener;
    protected int m_counter = 0;
    protected String packageName;

    /* JADX INFO: Access modifiers changed from: package-private */
    public abstract void downloadingCompleted(boolean z, Vector<Integer> vector);

    abstract void fetchNewsFromServer();

    public void setDataTrackingListener(DataTrackeringListener dataTrackingListener) {
        this.dataTrackingListener = dataTrackingListener;
    }

    public DataTrackeringListener getDataTrackingListener() {
        return this.dataTrackingListener;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public NewsManagerBase(Context context, String packageName_) {
        Log.v(TAG, "-----------fetchNewsFromServer-NewsManagerBase");
        this.context = context;
        this.packageName = packageName_;
    }

    public static long getInternalAvailableSpace() {
        try {
            StatFs stat = new StatFs(Environment.getDataDirectory().getPath());
            stat.restat(Environment.getDataDirectory().getPath());
            long availableSpace = stat.getAvailableBlocks() * stat.getBlockSize();
            return availableSpace;
        } catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static boolean isMemoryCriteriaSatisfied(Context context) {
        Activity act = (Activity) context;
        ActivityManager activityManager = (ActivityManager) act.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        if (memoryInfo.lowMemory) {
            return false;
        }
        long lAvailBytes = getInternalAvailableSpace();
        long lAvailKBytes = lAvailBytes / 1024;
        long lAvailMBytes = lAvailKBytes / 1024;
        return lAvailMBytes >= 5;
    }
}
