package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import com.flurry.android.AdCreative;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class InfoBadge extends NewsManagerBase implements AnimationSource, View.OnClickListener {
    private static final String PREFS_ID_ADS_ID = "InfoBadge_adsID";
    private static final String PREFS_ID_IS_SUCCESS = "InfoBadge_isSuccess";
    private static final String PREFS_NAME = "InfoBadgePrefFile";
    private static final String TAG = "InfoBadge";
    private static InfoBadge mObjInfoBadge;
    FrameLayout frameLayout;
    private int mAlignment;
    CustomAnimator mAnimator;
    Activity mCurrentActivity;
    DownloadManager mDmThread;
    int mGravity;
    int mInfoBadgeImgHeight;
    int mInfoBadgeImgWidth;
    private boolean mIsInfoBadgeShown;
    private Point mMargin;
    PopupWindow mPopUp;
    Point mPosition;
    String mStrDirPath;
    String mStrFileName;
    private String mURL;
    private long mUpdateInterval;

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ DataTrackeringListener getDataTrackingListener() {
        return super.getDataTrackingListener();
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public /* bridge */ /* synthetic */ void setDataTrackingListener(DataTrackeringListener dataTrackeringListener) {
        super.setDataTrackingListener(dataTrackeringListener);
    }

    public void setURL(String URL) {
        this.mURL = URL;
    }

    public void setAlignment(int alignment) {
        this.mAlignment = alignment;
    }

    public void setMargin(Point margin) {
        this.mMargin = margin;
    }

    public void setPosition(Point position) {
        this.mPosition = position;
    }

    public void setMinimumUpdateIntervalSeconds(long updateInterval) {
        this.mUpdateInterval = updateInterval;
    }

    public CustomAnimator getAnimator() {
        return this.mAnimator;
    }

    public void setAnimator(CustomAnimator animator) {
        this.mAnimator = animator;
    }

    private InfoBadge(Context context, String packageName_) {
        super(context, packageName_);
        this.mStrDirPath = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/Android/data/" + packageName_;
        this.mStrFileName = "infoBadge.json";
        this.mAlignment = 0;
        this.mIsInfoBadgeShown = false;
        this.mInfoBadgeImgWidth = 0;
        this.mInfoBadgeImgHeight = 0;
        this.mGravity = 17;
    }

    public static void createInstance(Context context, String packageName_) {
        if (mObjInfoBadge != null) {
            mObjInfoBadge = null;
        }
        mObjInfoBadge = new InfoBadge(context, packageName_);
    }

    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    void fetchNewsFromServer() {
        if (this.mDmThread == null || !this.mDmThread.isAlive()) {
            Log.d(TAG, "fetchNewsFromServer started");
            SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
            String strCurSavedAdsIDs = settings.getString(PREFS_ID_ADS_ID, "-1");
            this.mDmThread = new DownloadManager(this.mURL, this.packageName, this.mStrFileName, this, strCurSavedAdsIDs);
            this.mDmThread.setInfoBadgeDownloader(true);
            this.mDmThread.start();
        }
    }

    public static InfoBadge getInstance() {
        if (mObjInfoBadge == null) {
            Log.e(TAG, "Info Badge Instance is not created. : ");
        }
        return mObjInfoBadge;
    }

    public void startComponent() {
        if (isMemoryCriteriaSatisfied(this.context) && mObjInfoBadge != null) {
            Activity currentActivity = (Activity) this.context;
            final long updateInterval = this.mUpdateInterval;
            currentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.InfoBadge.1
                @Override // java.lang.Runnable
                public void run() {
                    if (updateInterval != 0) {
                        Timer timer = new Timer();
                        timer.schedule(new TimerTask() { // from class: com.ubisoft.crosspromotion.InfoBadge.1.1
                            @Override // java.util.TimerTask, java.lang.Runnable
                            public void run() {
                                InfoBadge.this.fetchNewsFromServer();
                            }
                        }, 0L, updateInterval);
                    }
                }
            });
        }
    }

    public void showInfoBadge(Activity activity) {
        if (!this.mIsInfoBadgeShown && this.mDmThread != null && !this.mDmThread.isAlive()) {
            this.mCurrentActivity = activity;
            this.mCurrentActivity.runOnUiThread(new Runnable() { // from class: com.ubisoft.crosspromotion.InfoBadge.2
                @Override // java.lang.Runnable
                public void run() {
                    InfoBadge.this.frameLayout = new FrameLayout(InfoBadge.this.mCurrentActivity);
                    File file = new File(InfoBadge.this.mStrDirPath, InfoBadge.this.mStrFileName);
                    StringBuilder text = new StringBuilder();
                    try {
                        if (file.exists()) {
                            BufferedReader br = new BufferedReader(new FileReader(file));
                            while (true) {
                                String line = br.readLine();
                                if (line == null) {
                                    break;
                                }
                                text.append(line);
                            }
                            String strJson = new String(text);
                            InfoBadge.this.parseAndProcessJson(strJson);
                        }
                        InfoBadge.this.mIsInfoBadgeShown = true;
                    } catch (IOException e) {
                    }
                }
            });
        }
    }

    void parseAndProcessJson(String strJson) {
        try {
            JSONArray jsonArray = new JSONArray(strJson);
            int iTotalProbability = 0;
            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject jobj = jsonArray.getJSONObject(i);
                int probability = jobj.getInt("probability");
                iTotalProbability += probability;
            }
            Random random = new Random();
            int iRandom = Math.abs(random.nextInt()) % iTotalProbability;
            JSONObject jobj2 = null;
            int iTotalProbability2 = 0;
            for (int i2 = 0; i2 < jsonArray.length(); i2++) {
                jobj2 = jsonArray.getJSONObject(i2);
                int probability2 = jobj2.getInt("probability");
                iTotalProbability2 += probability2;
                if (iRandom < iTotalProbability2) {
                    break;
                }
            }
            String strTemp = jobj2.getString("adImage");
            int indexOfSlash = strTemp.lastIndexOf(47);
            String strImageUrl = strTemp.substring(indexOfSlash + 1);
            ImageView imgView = new ImageView(this.context);
            Bitmap bm = LoadImage(String.valueOf(this.mStrDirPath) + "/" + strImageUrl);
            this.mInfoBadgeImgWidth = bm.getWidth();
            this.mInfoBadgeImgHeight = bm.getHeight();
            imgView.setImageBitmap(bm);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2, 51);
            switch (this.mAlignment) {
                case 0:
                    this.mGravity = 17;
                    params = new FrameLayout.LayoutParams(-2, -2, this.mGravity);
                    params.leftMargin = this.mMargin.x;
                    params.bottomMargin = this.mMargin.y;
                    break;
                case 1:
                    this.mGravity = 49;
                    params = new FrameLayout.LayoutParams(-2, -2, this.mGravity);
                    params.leftMargin = this.mMargin.x;
                    params.topMargin = this.mMargin.y;
                    break;
                case 2:
                    this.mGravity = 19;
                    params = new FrameLayout.LayoutParams(-2, -2, this.mGravity);
                    params.leftMargin = this.mMargin.x;
                    params.bottomMargin = this.mMargin.y;
                    break;
                case 3:
                    this.mGravity = 81;
                    params = new FrameLayout.LayoutParams(-2, -2, this.mGravity);
                    params.leftMargin = this.mMargin.x;
                    params.bottomMargin = this.mMargin.y;
                    break;
                case 4:
                    this.mGravity = 21;
                    params = new FrameLayout.LayoutParams(-2, -2, this.mGravity);
                    params.rightMargin = this.mMargin.x;
                    params.bottomMargin = this.mMargin.y;
                    break;
            }
            this.frameLayout.setLayoutParams(params);
            if (this.dataTrackingListener != null) {
                this.dataTrackingListener.onLogEvent("CrossPromotion : InfoBadge shown");
            }
            if (this.mAnimator != null) {
                this.mAnimator.startAnimationForSource(this, imgView, this.mMargin, this.mInfoBadgeImgWidth, this.mInfoBadgeImgHeight);
            }
            this.mPopUp = new PopupWindow(this.mCurrentActivity);
            this.mPopUp.setWidth(this.mInfoBadgeImgWidth);
            this.mPopUp.setHeight(this.mInfoBadgeImgHeight);
            this.mPopUp.setWindowLayoutMode(-2, -2);
            this.frameLayout.addView(imgView, params);
            this.mPopUp.setContentView(this.frameLayout);
            this.mPopUp.showAtLocation(this.frameLayout, this.mGravity, this.mPosition.x, this.mPosition.y);
            this.mPopUp.update();
            addButtonsOnFrameLayout(this.frameLayout, jobj2);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void addButtonsOnFrameLayout(FrameLayout frameLayout, JSONObject jobj) {
        if (jobj != null) {
            try {
                int iButtons = jobj.getInt("buttons");
                for (int i = 1; i <= iButtons; i++) {
                    int x = jobj.getInt("x" + i);
                    int y = jobj.getInt("y" + i);
                    int width = jobj.getInt(AdCreative.kFixWidth + i);
                    int height = jobj.getInt(AdCreative.kFixHeight + i);
                    Button btn = new Button(this.context);
                    btn.setBackgroundColor(0);
                    if (jobj.has("url" + i)) {
                        String url = jobj.getString("url" + i);
                        btn.setTag(url);
                    }
                    btn.setWidth(width);
                    btn.setHeight(height);
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                    lp.gravity = 51;
                    lp.leftMargin = x;
                    lp.topMargin = y;
                    frameLayout.addView(btn, lp);
                    btn.setOnClickListener(this);
                }
            } catch (Exception e) {
                System.out.println("Exception while adding InfoBadge Buttons: " + e.toString());
            }
        }
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View v) {
        Object obj = v.getTag();
        if (obj == null) {
            if (this.dataTrackingListener != null) {
                this.dataTrackingListener.onLogEvent("CrossPromotion : InfoBadge Closed");
                return;
            }
            return;
        }
        String strURL = (String) obj;
        if (this.dataTrackingListener != null) {
            HashMap<String, String> params = new HashMap<>();
            params.put("URL", strURL);
            this.dataTrackingListener.onLogEvent("CrossPromotion : InfoBadge continued to URL", params);
        }
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse(strURL));
        this.context.startActivity(browserIntent);
    }

    private Bitmap LoadImage(String strURL) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile(strURL);
            return bitmap;
        } catch (Exception e) {
            return null;
        }
    }

    public void hideInfoBadge() {
        if (this.frameLayout != null && this.frameLayout.getChildCount() > 0) {
            ImageView imgView = (ImageView) this.frameLayout.getChildAt(0);
            if (this.mAnimator != null) {
                this.mAnimator.startReverseAnimationForSource(this, imgView, this.mMargin, this.mInfoBadgeImgWidth, this.mInfoBadgeImgHeight);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable() { // from class: com.ubisoft.crosspromotion.InfoBadge.3
                    @Override // java.lang.Runnable
                    public void run() {
                        InfoBadge.this.removeInfoBadge();
                    }
                }, this.mAnimator.getDuration());
                return;
            }
            removeInfoBadge();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void removeInfoBadge() {
        this.frameLayout.removeAllViewsInLayout();
        this.mPopUp.dismiss();
        this.mIsInfoBadgeShown = false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.ubisoft.crosspromotion.NewsManagerBase
    public void downloadingCompleted(boolean isSuccess, Vector<Integer> vec_adsID) {
        String strAds = "";
        int count = vec_adsID.size();
        for (int i = 0; i < count; i++) {
            if (i != 0) {
                strAds = String.valueOf(strAds) + ",";
            }
            Integer integer = vec_adsID.elementAt(i);
            strAds = String.valueOf(strAds) + integer.intValue();
        }
        SharedPreferences settings = this.context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(PREFS_ID_IS_SUCCESS, isSuccess);
        editor.putString(PREFS_ID_ADS_ID, strAds);
        editor.commit();
    }

    @Override // com.ubisoft.crosspromotion.AnimationSource
    public int getAlignment() {
        return this.mAlignment;
    }

    @Override // com.ubisoft.crosspromotion.AnimationSource
    public void animationDidFinishReversed(boolean reversed) {
    }
}
