package com.ubisoft.crosspromotion;

import android.os.Environment;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
class DownloadManager extends Thread {
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final String TAG = "DownloadManager";
    int mCurSavedAdId;
    String mDownloadUrl;
    boolean mIsInfoBadgeDownloader;
    boolean mIsUrgentNewsDownloader;
    NewsManagerBase mNewsmanager;
    String mPackageName;
    String mStrCurSavedAdsIDs;
    String mStrOutputFile;
    Vector<Integer> mVecAdsID = new Vector<>();
    Vector<String> mVecStrImgs = new Vector<>();

    public boolean isUrgentNewsDownloader() {
        return this.mIsUrgentNewsDownloader;
    }

    public void setUrgentNewsDownloader(boolean isUrgentNewsDownloader) {
        this.mIsUrgentNewsDownloader = isUrgentNewsDownloader;
    }

    public boolean isInfoBadgeDownloader() {
        return this.mIsInfoBadgeDownloader;
    }

    public void setInfoBadgeDownloader(boolean isInfoBadgeDownloader) {
        this.mIsInfoBadgeDownloader = isInfoBadgeDownloader;
    }

    public DownloadManager(String downloadUrl_, String packageName_, String strOutputFile_, NewsManagerBase newsmanager, String strCurSavedAdsIDs_) {
        String strCurSavedAdID;
        this.mDownloadUrl = downloadUrl_;
        this.mPackageName = packageName_;
        this.mStrOutputFile = strOutputFile_;
        this.mNewsmanager = newsmanager;
        this.mStrCurSavedAdsIDs = strCurSavedAdsIDs_;
        this.mCurSavedAdId = -1;
        if (this.mStrCurSavedAdsIDs != null) {
            int iCharPos = this.mStrCurSavedAdsIDs.indexOf(44);
            if (iCharPos != -1) {
                strCurSavedAdID = this.mStrCurSavedAdsIDs.substring(0, iCharPos);
            } else {
                strCurSavedAdID = this.mStrCurSavedAdsIDs;
            }
            this.mCurSavedAdId = Integer.parseInt(strCurSavedAdID.equalsIgnoreCase("") ? "-1" : strCurSavedAdID);
        }
    }

    @Override // java.lang.Thread, java.lang.Runnable
    public void run() {
        boolean isSuccess = downloadData();
        this.mNewsmanager.downloadingCompleted(isSuccess, this.mVecAdsID);
        Log.d(TAG, "DownloadManager Run() isSuccess = " + isSuccess);
    }

    public boolean downloadData() {
        InputStream input = null;
        OutputStream output = null;
        boolean isSuccess = true;
        try {
            try {
                String path = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/Android/data/" + this.mPackageName;
                String fileName = this.mStrOutputFile;
                File fileDir = new File(path);
                fileDir.mkdirs();
                Log.d(TAG, "DownloadManager URL " + this.mDownloadUrl);
                URL url = new URL(this.mDownloadUrl);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(CONNECTION_TIMEOUT);
                connection.connect();
                int fileLength = connection.getContentLength();
                InputStream input2 = new BufferedInputStream(connection.getInputStream());
                try {
                    byte[] data = new byte[fileLength];
                    int count = input2.read(data);
                    input2.close();
                    File file = new File(path, fileName);
                    if (isUrgentNewsDownloader()) {
                        isSuccess = parseUrgentNews(data);
                    } else if (isInfoBadgeDownloader()) {
                        isSuccess = parseInfoBadge(data);
                    }
                    if (isNewContentOnServer() && isSuccess) {
                        OutputStream output2 = new FileOutputStream(file);
                        try {
                            output2.write(data, 0, count);
                            output2.flush();
                            output2.close();
                            int iCount = this.mVecStrImgs.size();
                            int i = 0;
                            while (true) {
                                if (i >= iCount) {
                                    output = output2;
                                    break;
                                }
                                String strImageUrl = this.mVecStrImgs.elementAt(i);
                                boolean isImgDownloaded = downloadImage(strImageUrl);
                                if (isImgDownloaded) {
                                    i++;
                                } else {
                                    isSuccess = false;
                                    output = output2;
                                    break;
                                }
                            }
                        } catch (Exception e) {
                            e = e;
                            output = output2;
                            input = input2;
                            Log.e(TAG, "Exception:" + e);
                            onFailed();
                            if (output != null) {
                                try {
                                    output.close();
                                } catch (Exception e2) {
                                    Log.e(TAG, "Close Exception:" + e2);
                                    onFailed();
                                    return false;
                                }
                            }
                            if (input == null) {
                                return false;
                            }
                            input.close();
                            return false;
                        } catch (Throwable th) {
                            th = th;
                            output = output2;
                            input = input2;
                            if (output != null) {
                                try {
                                    output.close();
                                } catch (Exception e3) {
                                    Log.e(TAG, "Close Exception:" + e3);
                                    onFailed();
                                    throw th;
                                }
                            }
                            if (input != null) {
                                input.close();
                            }
                            throw th;
                        }
                    }
                    if (output != null) {
                        try {
                            output.close();
                        } catch (Exception e4) {
                            Log.e(TAG, "Close Exception:" + e4);
                            onFailed();
                            return false;
                        }
                    }
                    if (input2 != null) {
                        input2.close();
                        return isSuccess;
                    }
                    return isSuccess;
                } catch (Exception e5) {
                    e = e5;
                    input = input2;
                } catch (Throwable th2) {
                    th = th2;
                    input = input2;
                }
            } catch (Exception e6) {
                e = e6;
            }
        } catch (Throwable th3) {
            th = th3;
        }
    }

    public boolean isNewContentOnServer() {
        if (this.mVecAdsID.size() > 0) {
            int iCurAdID = this.mVecAdsID.elementAt(0).intValue();
            return this.mCurSavedAdId != iCurAdID;
        }
        return true;
    }

    public boolean parseUrgentNews(byte[] data) {
        boolean isSuccess = true;
        String strv = new String(data);
        JSONObject jobj = null;
        try {
            JSONArray jsonReply = new JSONArray(strv);
            jobj = jsonReply.getJSONObject(0);
        } catch (JSONException e) {
            Log.d(TAG, "DownloadManager " + e.getMessage());
            isSuccess = false;
        }
        try {
            int id = jobj.getInt("id");
            this.mVecAdsID.add(Integer.valueOf(id));
        } catch (Exception e2) {
            Log.d(TAG, "DownloadManager " + e2.getMessage());
        }
        try {
            String imgURLDlg = jobj.getString("imageUrlDlg");
            if (!imgURLDlg.equals("")) {
                this.mVecStrImgs.add(jobj.getString("imageUrlDlg"));
            }
            Log.d(TAG, "DownloadManager ImageURLDLG" + imgURLDlg);
        } catch (Exception e3) {
            Log.d(TAG, "DownloadManager " + e3.getMessage());
        }
        try {
            String imgURL = jobj.getString("imageUrl");
            if (!imgURL.equals("")) {
                this.mVecStrImgs.add(jobj.getString("imageUrl"));
            }
            Log.d(TAG, "DownloadManager ImageURL " + imgURL);
        } catch (Exception e4) {
            Log.d(TAG, "DownloadManager " + e4.getMessage());
        }
        return isSuccess;
    }

    public boolean parseInfoBadge(byte[] data) {
        try {
            String strv = new String(data);
            JSONArray jsonArray = new JSONArray(strv);
            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject jobj = jsonArray.getJSONObject(i);
                int id = jobj.getInt("id");
                this.mVecAdsID.add(Integer.valueOf(id));
                this.mVecStrImgs.add(jobj.getString("adImage"));
            }
            return true;
        } catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    protected void onSuccess() {
    }

    protected void onFailed() {
    }

    public boolean downloadImage(String strImgDownloadURL) {
        int indexOfSlash = strImgDownloadURL.lastIndexOf(47);
        String strImgOutFile = strImgDownloadURL.substring(indexOfSlash + 1);
        InputStream input = null;
        OutputStream output = null;
        try {
            try {
                String path = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/Android/data/" + this.mPackageName;
                File fileDir = new File(path);
                fileDir.mkdirs();
                URL url = new URL(strImgDownloadURL);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(CONNECTION_TIMEOUT);
                connection.connect();
                connection.getContentLength();
                InputStream input2 = new BufferedInputStream(connection.getInputStream());
                try {
                    File file = new File(path, strImgOutFile);
                    OutputStream output2 = new FileOutputStream(file);
                    try {
                        byte[] data = new byte[1024];
                        long total = 0;
                        while (true) {
                            int count = input2.read(data);
                            if (count == -1) {
                                break;
                            }
                            total += count;
                            output2.write(data, 0, count);
                        }
                        output2.flush();
                        output2.close();
                        if (output2 != null) {
                            try {
                                output2.close();
                            } catch (Exception e) {
                                Log.d(TAG, "Close Exception:" + e);
                                return false;
                            }
                        }
                        if (input2 == null) {
                            return true;
                        }
                        input2.close();
                        output = output2;
                        input = input2;
                        return true;
                    } catch (Exception e2) {
                        e = e2;
                        output = output2;
                        input = input2;
                        Log.d(TAG, "Exception while downloading image :" + strImgDownloadURL + ":" + e);
                        if (output != null) {
                            try {
                                output.close();
                            } catch (Exception e3) {
                                Log.d(TAG, "Close Exception:" + e3);
                                return false;
                            }
                        }
                        if (input == null) {
                            return false;
                        }
                        input.close();
                        return false;
                    } catch (Throwable th) {
                        th = th;
                        output = output2;
                        input = input2;
                        if (output != null) {
                            try {
                                output.close();
                            } catch (Exception e4) {
                                Log.d(TAG, "Close Exception:" + e4);
                                throw th;
                            }
                        }
                        if (input != null) {
                            input.close();
                        }
                        throw th;
                    }
                } catch (Exception e5) {
                    e = e5;
                    input = input2;
                } catch (Throwable th2) {
                    th = th2;
                    input = input2;
                }
            } catch (Throwable th3) {
                th = th3;
            }
        } catch (Exception e6) {
            e = e6;
        }
    }
}
