package com.ubisoft.crosspromotion;

import android.app.Activity;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class CrossPromotionWrapper implements DataTrackeringListener {
    private static final String TAG = "CrossPromotionWrapper";
    private static Class<?> mFlurryClasss;
    private static Method mLogEventMethod;
    private static Method mLogEventWithParamMethod;
    private static CrossPromotionWrapper mInstance = null;
    private static Activity mCurrentActivity = null;

    public static void setCurrentActivity(Activity currentActivity) {
        mCurrentActivity = currentActivity;
    }

    public static void setURL(String webNewsURL, String urgentNewsURL, String urgentNewsURL_hd, String infoBadgeURL, String infoBadgeURL_hd) {
        String finalUrgentNewsURL;
        String finalInfoBadgdeURL;
        Log.d(TAG, String.valueOf(webNewsURL) + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + urgentNewsURL + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + urgentNewsURL_hd);
        DisplayMetrics metrics = new DisplayMetrics();
        Display display = mCurrentActivity.getWindowManager().getDefaultDisplay();
        switch (metrics.densityDpi) {
            case 120:
                finalUrgentNewsURL = urgentNewsURL;
                finalInfoBadgdeURL = infoBadgeURL;
                break;
            case 160:
                if (display.getWidth() > 480) {
                    finalUrgentNewsURL = urgentNewsURL_hd;
                    finalInfoBadgdeURL = infoBadgeURL_hd;
                    break;
                } else {
                    finalUrgentNewsURL = urgentNewsURL;
                    finalInfoBadgdeURL = infoBadgeURL;
                    break;
                }
            default:
                finalUrgentNewsURL = urgentNewsURL_hd;
                finalInfoBadgdeURL = infoBadgeURL_hd;
                break;
        }
        WebNews.getInstance().setURL(webNewsURL);
        UrgentNews.getInstance().setURL(finalUrgentNewsURL);
        InfoBadge.getInstance().setURL(finalInfoBadgdeURL);
    }

    public static void setUpdateTimeInterval(long webNewsTime, long urgentNewsTime, long infoBadgeTime) {
        WebNews.getInstance().setMinimumUpdateIntervalSeconds(webNewsTime);
        UrgentNews.getInstance().setMinimumUpdateIntervalSeconds(urgentNewsTime);
        InfoBadge.getInstance().setMinimumUpdateIntervalSeconds(infoBadgeTime);
    }

    public static void startComponents(boolean urgentNews, boolean webNews, boolean infoBadge) {
        if (urgentNews) {
            UrgentNews.getInstance().startComponent();
        }
        if (webNews) {
            WebNews.getInstance().startComponent();
        }
        if (infoBadge) {
            InfoBadge.getInstance().startComponent();
        }
    }

    public static CrossPromotionWrapper getInstance() {
        if (mInstance == null) {
            mInstance = new CrossPromotionWrapper();
        }
        return mInstance;
    }

    public static void showWebNewsDialog() {
        WebNews.getInstance().showWebNewsDialog();
    }

    public static void showUrgentNewsDialog() {
        UrgentNews.getInstance().showUrgentNewsDialog();
    }

    public static void showInfoBadge() {
        InfoBadge.getInstance().showInfoBadge(mCurrentActivity);
    }

    public static void hideInfoBadge() {
        InfoBadge.getInstance().hideInfoBadge();
    }

    public static boolean canShowUrgentNews() {
        return UrgentNews.getInstance().canLaunchUrgentNews();
    }

    public static boolean hasNewWebNews() {
        return WebNews.getInstance().hasNewWebNews();
    }

    public static void setInfoBadgeParameters(int alignment, int marginX, int marginY, int positionX, int positionY) {
        InfoBadge.getInstance().setAlignment(alignment);
        InfoBadge.getInstance().setMargin(new Point(marginX, marginY));
        InfoBadge.getInstance().setPosition(new Point(positionX, positionY));
    }

    public void init() {
        try {
            mFlurryClasss = Class.forName("com.flurry.android.FlurryAgent");
            mLogEventMethod = mFlurryClasss.getMethod("logEvent", String.class);
            mLogEventWithParamMethod = mFlurryClasss.getMethod("logEvent", String.class, Map.class);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        } catch (SecurityException e3) {
            e3.printStackTrace();
        }
        WebNews.createInstance(mCurrentActivity, mCurrentActivity.getPackageName());
        WebNews.getInstance().setDataTrackingListener(this);
        UrgentNews.createInstance(mCurrentActivity, mCurrentActivity.getPackageName());
        UrgentNews.getInstance().setDataTrackingListener(this);
        InfoBadge.createInstance(mCurrentActivity, mCurrentActivity.getPackageName());
        InfoBadge.getInstance().setDataTrackingListener(this);
    }

    @Override // com.ubisoft.crosspromotion.DataTrackeringListener
    public void onLogEvent(String strEvent) {
        try {
            Log.v(TAG, strEvent);
            mLogEventMethod.invoke(null, strEvent);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        } catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
    }

    @Override // com.ubisoft.crosspromotion.DataTrackeringListener
    public void onLogEvent(String strEvent, Map<String, String> params) {
        try {
            Log.v(TAG, strEvent);
            mLogEventWithParamMethod.invoke(null, strEvent, params);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        } catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
    }
}
