package com.ubisoft.crosspromotion;

import android.graphics.Point;
import android.view.animation.AlphaAnimation;
import android.widget.ImageView;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class AlphaAnimator implements CustomAnimator {
    long duration;
    float fromAlpha;
    float toAlpha;

    public AlphaAnimator() {
        this.fromAlpha = 0.0f;
        this.toAlpha = 1.1f;
    }

    public AlphaAnimator(float fromAlpha, float toAlpha) {
        this.fromAlpha = fromAlpha;
        this.toAlpha = toAlpha;
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public long getDuration() {
        return this.duration;
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void startAnimationForSource(AnimationSource animationSource, ImageView imgView, Point margin, int imgWidth, int imgHeight) {
        AlphaAnimation animation = new AlphaAnimation(this.fromAlpha, this.toAlpha);
        animation.setDuration(this.duration);
        animation.setFillAfter(true);
        imgView.setAnimation(animation);
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public void startReverseAnimationForSource(AnimationSource animationSource, ImageView imgView, Point margin, int imgWidth, int imgHeight) {
        AlphaAnimation animation = new AlphaAnimation(this.toAlpha, this.fromAlpha);
        animation.setDuration(this.duration);
        animation.setFillAfter(true);
        imgView.setAnimation(animation);
    }

    @Override // com.ubisoft.crosspromotion.CustomAnimator
    public boolean isAnimationRunning() {
        return false;
    }
}
