package com.tapjoy;

import android.util.Log;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TapjoyLog {
    private static final int MAX_STRING_SIZE = 4096;
    private static boolean showLog = false;

    public static void enableLogging(boolean enable) {
        Log.i("TapjoyLog", "enableLogging: " + enable);
        showLog = enable;
    }

    public static void i(String tag, String msg) {
        if (showLog) {
            if (msg.length() > MAX_STRING_SIZE) {
                for (int i = 0; i <= msg.length() / MAX_STRING_SIZE; i++) {
                    int start = i * MAX_STRING_SIZE;
                    int end = (i + 1) * MAX_STRING_SIZE;
                    if (end > msg.length()) {
                        end = msg.length();
                    }
                    Log.i(tag, msg.substring(start, end));
                }
                return;
            }
            Log.i(tag, msg);
        }
    }

    public static void e(String tag, String msg) {
        if (showLog) {
            Log.e(tag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (showLog) {
            Log.w(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (showLog) {
            Log.d(tag, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (showLog) {
            Log.v(tag, msg);
        }
    }
}
