package com.tapjoy;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.util.Hashtable;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TapjoyFullScreenAdWebView extends Activity {
    private String htmlRawData;
    private ProgressBar progressBar;
    private WebView webView = null;
    private Dialog dialog = null;
    private boolean resumeCalled = false;
    final String TAPJOY_FULL_SCREEN_AD = "Full Screen Ad";

    @Override // android.app.Activity
    protected void onCreate(Bundle savedInstanceState) {
        Bundle extras = getIntent().getExtras();
        this.htmlRawData = extras.getString(TapjoyConstants.EXTRA_FULLSCREEN_HTML_DATA);
        super.onCreate(savedInstanceState);
        requestWindowFeature(1);
        RelativeLayout layout = new RelativeLayout(this);
        this.webView = new WebView(this);
        this.webView.setWebViewClient(new TapjoyWebViewClient());
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        this.progressBar = new ProgressBar(this, null, 16842874);
        this.progressBar.setVisibility(0);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13);
        this.progressBar.setLayoutParams(layoutParams);
        layout.addView(this.webView, -1, -1);
        layout.addView(this.progressBar);
        setContentView(layout);
        this.webView.loadDataWithBaseURL(TapjoyConstants.TJC_SERVICE_URL, this.htmlRawData, "text/html", "utf-8", null);
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.webView != null) {
            RefreshTask refreshTask = new RefreshTask();
            refreshTask.execute(new Void[0]);
        }
    }

    @Override // android.app.Activity
    protected void onResume() {
        super.onResume();
        if (this.resumeCalled && TapjoyConnectCore.getInstance() != null) {
            TapjoyLog.i("Full Screen Ad", "call connect");
            TapjoyConnectCore.getInstance().callConnect();
        }
        this.resumeCalled = true;
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    private class RefreshTask extends AsyncTask<Void, Void, Boolean> {
        private RefreshTask() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        public Boolean doInBackground(Void... params) {
            try {
                Thread.sleep(200L);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        public void onPostExecute(Boolean result) {
            if (TapjoyFullScreenAdWebView.this.webView != null) {
                TapjoyFullScreenAdWebView.this.webView.loadUrl("javascript:window.onorientationchange();");
            }
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    private class TapjoyWebViewClient extends WebViewClient {
        private TapjoyWebViewClient() {
        }

        @Override // android.webkit.WebViewClient
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            TapjoyFullScreenAdWebView.this.progressBar.setVisibility(0);
            TapjoyFullScreenAdWebView.this.progressBar.bringToFront();
        }

        @Override // android.webkit.WebViewClient
        public void onPageFinished(WebView view, String url) {
            TapjoyFullScreenAdWebView.this.progressBar.setVisibility(8);
        }

        @Override // android.webkit.WebViewClient
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            TapjoyLog.i("Full Screen Ad", "URL = [" + url + "]");
            if (url.startsWith(TapjoyConstants.TJC_VIDEO_AD_URL)) {
                Hashtable<String, String> params = new Hashtable<>();
                int mode = 0;
                String word = "";
                String key = "";
                for (int index = url.indexOf("://") + "://".length(); index < url.length() && index != -1; index++) {
                    char c = url.charAt(index);
                    if (mode == 0) {
                        if (c == '=') {
                            mode = 1;
                            key = Uri.decode(word);
                            word = "";
                        } else {
                            word = word + c;
                        }
                    } else if (mode == 1) {
                        if (c == '&') {
                            mode = 0;
                            String value = Uri.decode(word);
                            word = "";
                            TapjoyLog.i("Full Screen Ad", "k:v: " + key + ", " + value);
                            params.put(key, value);
                        } else {
                            word = word + c;
                        }
                    }
                }
                if (mode == 1 && word.length() > 0) {
                    String value2 = Uri.decode(word);
                    TapjoyLog.i("Full Screen Ad", "k:v: " + key + ", " + value2);
                    params.put(key, value2);
                }
                String videoID = params.get("video_id");
                String currencyAmount = params.get("amount");
                String currencyName = params.get("currency_name");
                String clickURL = params.get("click_url");
                String webviewURL = params.get("video_complete_url");
                String videoURL = params.get("video_url");
                TapjoyLog.i("Full Screen Ad", "videoID: " + videoID);
                TapjoyLog.i("Full Screen Ad", "currencyAmount: " + currencyAmount);
                TapjoyLog.i("Full Screen Ad", "currencyName: " + currencyName);
                TapjoyLog.i("Full Screen Ad", "clickURL: " + clickURL);
                TapjoyLog.i("Full Screen Ad", "webviewURL: " + webviewURL);
                TapjoyLog.i("Full Screen Ad", "videoURL: " + videoURL);
                if (TapjoyVideo.getInstance().startVideo(videoID, currencyName, currencyAmount, clickURL, webviewURL, videoURL)) {
                    TapjoyLog.i("Full Screen Ad", "VIDEO");
                    return true;
                }
                TapjoyLog.e("Full Screen Ad", "Unable to play video: " + videoID);
                TapjoyFullScreenAdWebView.this.dialog = new AlertDialog.Builder(TapjoyFullScreenAdWebView.this).setTitle("").setMessage("Unable to play video.").setPositiveButton("OK", new DialogInterface.OnClickListener() { // from class: com.tapjoy.TapjoyFullScreenAdWebView.TapjoyWebViewClient.1
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.dismiss();
                    }
                }).create();
                try {
                    TapjoyFullScreenAdWebView.this.dialog.show();
                    return true;
                } catch (Exception e) {
                    TapjoyLog.e("Full Screen Ad", "e: " + e.toString());
                    return true;
                }
            } else if (url.contains(TapjoyConstants.TJC_FULLSCREEN_AD_SHOW_OFFERS_URL)) {
                TapjoyLog.i("Full Screen Ad", "show offers");
                TapjoyFullScreenAdWebView.this.showOffers();
                return true;
            } else if (url.contains(TapjoyConstants.TJC_FULLSCREEN_AD_DISMISS_URL)) {
                TapjoyLog.i("Full Screen Ad", TapjoyConstants.TJC_FULLSCREEN_AD_DISMISS_URL);
                TapjoyFullScreenAdWebView.this.finishActivity();
                return true;
            } else if (url.contains(TapjoyConstants.TJC_BASE_REDIRECT_DOMAIN)) {
                TapjoyLog.i("Full Screen Ad", "Open redirecting URL = [" + url + "]");
                view.loadUrl(url);
                return true;
            } else {
                TapjoyLog.i("Full Screen Ad", "Opening URL in new browser = [" + url + "]");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(url));
                TapjoyFullScreenAdWebView.this.startActivity(intent);
                return true;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void showOffers() {
        TapjoyLog.i("Full Screen Ad", "Showing offers");
        Intent offersIntent = new Intent(this, TJCOffersWebView.class);
        offersIntent.putExtra(TapjoyConstants.EXTRA_USER_ID, TapjoyConnectCore.getUserID());
        offersIntent.putExtra(TapjoyConstants.EXTRA_URL_PARAMS, TapjoyConnectCore.getURLParams());
        startActivity(offersIntent);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void finishActivity() {
        finish();
    }
}
