package com.tapjoy;

import android.content.Context;
import android.content.Intent;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TapjoyFullScreenAd {
    private static TapjoyFeaturedAppNotifier featuredAppNotifier;
    private static TapjoyFullScreenAdNotifier fullScreenAdNotifier;
    public static String fullScreenAdURLParams;
    private static String htmlData;
    private static TapjoyURLConnection tapjoyURLConnection = null;
    final String TAPJOY_FULL_SCREEN_AD = "Full Screen Ad";
    private Context context;
    private String currencyID;

    public TapjoyFullScreenAd(Context ctx) {
        this.context = ctx;
        tapjoyURLConnection = new TapjoyURLConnection();
    }

    public void getFullScreenAd(TapjoyFullScreenAdNotifier notifier) {
        getFullScreenAd(null, notifier);
    }

    public void getFullScreenAd(String theCurrencyID, TapjoyFullScreenAdNotifier notifier) {
        fullScreenAdNotifier = notifier;
        getFullScreenAdMain(theCurrencyID);
    }

    public void getFeaturedApp(TapjoyFeaturedAppNotifier notifier) {
        getFeaturedApp(null, notifier);
    }

    public void getFeaturedApp(String theCurrencyID, TapjoyFeaturedAppNotifier notifier) {
        featuredAppNotifier = notifier;
        getFullScreenAdMain(theCurrencyID);
    }

    public void getFullScreenAdMain(String theCurrencyID) {
        TapjoyLog.i("Full Screen Ad", "Getting Full Screen Ad");
        this.currencyID = theCurrencyID;
        TapjoyLog.i("Full Screen Ad", "Getting Full Screen Ad userID: " + TapjoyConnectCore.getUserID() + ", currencyID: " + this.currencyID);
        fullScreenAdURLParams = TapjoyConnectCore.getURLParams();
        fullScreenAdURLParams += "&publisher_user_id=" + TapjoyConnectCore.getUserID();
        if (this.currencyID != null) {
            fullScreenAdURLParams += "&currency_id=" + this.currencyID;
        }
        if (TapjoyConnectCore.getVideoParams().length() > 0) {
            fullScreenAdURLParams += "&" + TapjoyConnectCore.getVideoParams();
        }
        new Thread(new Runnable() { // from class: com.tapjoy.TapjoyFullScreenAd.1
            @Override // java.lang.Runnable
            public void run() {
                TapjoyHttpURLResponse httpResponse = TapjoyFullScreenAd.tapjoyURLConnection.getResponseFromURL("https://ws.tapjoyads.com/get_offers/featured.html?", TapjoyFullScreenAd.fullScreenAdURLParams);
                if (httpResponse != null) {
                    switch (httpResponse.statusCode) {
                        case 200:
                            String unused = TapjoyFullScreenAd.htmlData = httpResponse.response;
                            if (TapjoyFullScreenAd.featuredAppNotifier != null) {
                                TapjoyFullScreenAd.featuredAppNotifier.getFeaturedAppResponse(null);
                            }
                            if (TapjoyFullScreenAd.fullScreenAdNotifier != null) {
                                TapjoyFullScreenAd.fullScreenAdNotifier.getFullScreenAdResponse();
                                return;
                            }
                            return;
                        default:
                            if (TapjoyFullScreenAd.featuredAppNotifier != null) {
                                TapjoyFullScreenAd.featuredAppNotifier.getFeaturedAppResponseFailed("Error retrieving full screen ad data from the server.");
                            }
                            if (TapjoyFullScreenAd.fullScreenAdNotifier != null) {
                                TapjoyFullScreenAd.fullScreenAdNotifier.getFullScreenAdResponseFailed(1);
                                return;
                            }
                            return;
                    }
                }
                if (TapjoyFullScreenAd.featuredAppNotifier != null) {
                    TapjoyFullScreenAd.featuredAppNotifier.getFeaturedAppResponseFailed("Error retrieving full screen ad data from the server.");
                }
                if (TapjoyFullScreenAd.fullScreenAdNotifier != null) {
                    TapjoyFullScreenAd.fullScreenAdNotifier.getFullScreenAdResponseFailed(2);
                }
            }
        }).start();
    }

    public void showFullScreenAd() {
        if (htmlData != null && htmlData.length() > 0) {
            Intent featuredAppIntent = new Intent(this.context, TapjoyFullScreenAdWebView.class);
            featuredAppIntent.setFlags(268435456);
            featuredAppIntent.putExtra(TapjoyConstants.EXTRA_FULLSCREEN_HTML_DATA, htmlData);
            this.context.startActivity(featuredAppIntent);
        }
    }

    public void showFeaturedAppFullScreenAd() {
        if (htmlData != null && htmlData.length() > 0) {
            Intent featuredAppIntent = new Intent(this.context, TapjoyFeaturedAppWebView.class);
            featuredAppIntent.setFlags(268435456);
            featuredAppIntent.putExtra(TapjoyConstants.EXTRA_FULLSCREEN_HTML_DATA, htmlData);
            this.context.startActivity(featuredAppIntent);
        }
    }

    public void setDisplayCount(int count) {
    }
}
