package com.tapjoy;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.AsyncTask;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.Timer;
import java.util.TimerTask;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TapjoyDisplayAd {
    public static final String TAPJOY_DISPLAY_AD = "Banner Ad";
    private static String adClickURL;
    private static int bannerHeight;
    private static int bannerWidth;
    private static Bitmap bitmapImage;
    private static TapjoyDisplayAdNotifier displayAdNotifier;
    private static String displayAdSize;
    public static String displayAdURLParams;
    private static TapjoyURLConnection tapjoyURLConnection = null;
    View adView;
    private boolean autoRefresh;
    private Context context;
    long elapsed_time;
    Bitmap lastAd;
    Timer resumeTimer;
    Timer timer;

    public TapjoyDisplayAd(Context ctx) {
        setDisplayAdSize("640x100");
        this.context = ctx;
        tapjoyURLConnection = new TapjoyURLConnection();
    }

    public void setDisplayAdSize(String dimensions) {
        displayAdSize = dimensions;
        if (dimensions.equals("320x50")) {
            bannerWidth = 320;
            bannerHeight = 50;
        } else if (dimensions.equals("640x100")) {
            bannerWidth = 640;
            bannerHeight = 100;
        } else if (dimensions.equals("768x90")) {
            bannerWidth = 768;
            bannerHeight = 90;
        }
    }

    public String getDisplayAdSize() {
        return displayAdSize;
    }

    public void setBannerAdSize(String dimensions) {
        setDisplayAdSize(dimensions);
    }

    public String getBannerAdSize() {
        return getDisplayAdSize();
    }

    public void enableAutoRefresh(boolean shouldAutoRefresh) {
        this.autoRefresh = shouldAutoRefresh;
    }

    public void getDisplayAd(TapjoyDisplayAdNotifier notifier) {
        TapjoyLog.i(TAPJOY_DISPLAY_AD, "Get Banner Ad");
        getDisplayAd(null, notifier);
    }

    public void getDisplayAd(String currencyID, TapjoyDisplayAdNotifier notifier) {
        TapjoyLog.i(TAPJOY_DISPLAY_AD, "Get Banner Ad, currencyID: " + currencyID);
        displayAdNotifier = notifier;
        displayAdURLParams = TapjoyConnectCore.getURLParams();
        displayAdURLParams += "&publisher_user_id=" + TapjoyConnectCore.getUserID();
        displayAdURLParams += "&size=" + displayAdSize;
        if (currencyID != null) {
            displayAdURLParams += "&currency_id=" + currencyID;
        }
        new GetBannerAdTask().execute("https://ws.tapjoyads.com/display_ad.html?", displayAdURLParams);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public class RefreshTimer extends TimerTask {
        private RefreshTimer() {
        }

        @Override // java.util.TimerTask, java.lang.Runnable
        public void run() {
            TapjoyLog.i(TapjoyDisplayAd.TAPJOY_DISPLAY_AD, "refreshing banner ad...");
            TapjoyDisplayAd.this.getDisplayAd(TapjoyDisplayAd.displayAdNotifier);
            TapjoyDisplayAd.this.timer.cancel();
            TapjoyDisplayAd.this.timer = null;
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    private class CheckForResumeTimer extends TimerTask {
        private CheckForResumeTimer() {
        }

        @Override // java.util.TimerTask, java.lang.Runnable
        public void run() {
            TapjoyDisplayAd.this.elapsed_time += 10000;
            TapjoyLog.i(TapjoyDisplayAd.TAPJOY_DISPLAY_AD, "banner elapsed_time: " + TapjoyDisplayAd.this.elapsed_time + " (" + ((TapjoyDisplayAd.this.elapsed_time / 1000) / 60) + "m " + ((TapjoyDisplayAd.this.elapsed_time / 1000) % 60) + "s)");
            if (TapjoyDisplayAd.this.adView == null) {
                cancel();
                return;
            }
            TapjoyLog.i(TapjoyDisplayAd.TAPJOY_DISPLAY_AD, "adView.isShown: " + TapjoyDisplayAd.this.adView.isShown());
            if (TapjoyDisplayAd.this.adView.isShown() && TapjoyConnectCore.getInstance() != null) {
                TapjoyLog.i(TapjoyDisplayAd.TAPJOY_DISPLAY_AD, "call connect");
                TapjoyConnectCore.getInstance().callConnect();
                cancel();
            }
            if (TapjoyDisplayAd.this.elapsed_time >= TapjoyConstants.RESUME_TOTAL_TIME) {
                cancel();
            }
        }
    }

    public static Bitmap getBitmapImage() {
        return bitmapImage;
    }

    public static String getLinkURL() {
        return adClickURL;
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public class GetBannerAdTask extends AsyncTask<String, Void, TapjoyHttpURLResponse> {
        private GetBannerAdTask() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        public void onProgressUpdate(Void... progress) {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        public void onPostExecute(TapjoyHttpURLResponse httpResponse) {
            if (httpResponse != null) {
                switch (httpResponse.statusCode) {
                    case 200:
                        WebView webView = new WebView(TapjoyDisplayAd.this.context);
                        WebSettings webSettings = webView.getSettings();
                        webSettings.setJavaScriptEnabled(true);
                        webView.setWebViewClient(new WebViewClient() { // from class: com.tapjoy.TapjoyDisplayAd.GetBannerAdTask.1
                            @Override // android.webkit.WebViewClient
                            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                                Intent intent = new Intent(TapjoyDisplayAd.this.context, TJCOffersWebView.class);
                                intent.putExtra(TapjoyConstants.EXTRA_DISPLAY_AD_URL, url);
                                intent.setFlags(268435456);
                                TapjoyDisplayAd.this.context.startActivity(intent);
                                if (TapjoyDisplayAd.this.resumeTimer != null) {
                                    TapjoyDisplayAd.this.resumeTimer.cancel();
                                }
                                TapjoyDisplayAd.this.elapsed_time = 0L;
                                TapjoyDisplayAd.this.resumeTimer = new Timer();
                                TapjoyDisplayAd.this.resumeTimer.schedule(new CheckForResumeTimer(), 10000L, 10000L);
                                return true;
                            }
                        });
                        ViewGroup.LayoutParams layout = new ViewGroup.LayoutParams(TapjoyDisplayAd.bannerWidth, TapjoyDisplayAd.bannerHeight);
                        webView.setLayoutParams(layout);
                        webView.setInitialScale(100);
                        webView.setBackgroundColor(0);
                        webView.loadDataWithBaseURL(TapjoyConstants.TJC_SERVICE_URL, httpResponse.response, "text/html", "utf-8", null);
                        if (TapjoyDisplayAd.this.adView != null) {
                            TapjoyDisplayAd.this.lastAd = TapjoyUtil.createBitmapFromView(TapjoyDisplayAd.this.adView);
                        }
                        TapjoyDisplayAd.this.adView = webView;
                        if (TapjoyDisplayAd.this.lastAd != null) {
                            TapjoyDisplayAd.this.adView.setBackgroundDrawable(new BitmapDrawable(TapjoyDisplayAd.this.lastAd));
                        }
                        TapjoyDisplayAd.displayAdNotifier.getDisplayAdResponse(TapjoyDisplayAd.this.adView);
                        if (TapjoyDisplayAd.this.timer != null) {
                            TapjoyDisplayAd.this.timer.cancel();
                            TapjoyDisplayAd.this.timer = null;
                        }
                        if (TapjoyDisplayAd.this.autoRefresh && TapjoyDisplayAd.this.timer == null) {
                            TapjoyLog.i(TapjoyDisplayAd.TAPJOY_DISPLAY_AD, "will refresh banner ad in 15s...");
                            TapjoyDisplayAd.this.timer = new Timer();
                            TapjoyDisplayAd.this.timer.schedule(new RefreshTimer(), TapjoyConstants.BANNER_AD_REFERSH_TIME);
                            return;
                        }
                        return;
                    default:
                        TapjoyDisplayAd.displayAdNotifier.getDisplayAdResponseFailed("No ad to display.");
                        return;
                }
            }
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        public TapjoyHttpURLResponse doInBackground(String... params) {
            TapjoyHttpURLResponse httpResponse = TapjoyDisplayAd.tapjoyURLConnection.getResponseFromURL("https://ws.tapjoyads.com/display_ad.html?", TapjoyDisplayAd.displayAdURLParams);
            return httpResponse;
        }
    }
}
