package com.tapjoy;

import android.content.Context;
import android.content.Intent;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TapjoyDailyRewardAd {
    private static TapjoyDailyRewardAdNotifier dailyRewardNotifier;
    public static String dailyRewardURLParams;
    private static String htmlData;
    private static TapjoyURLConnection tapjoyURLConnection = null;
    final String TAPJOY_DAILY_REWARD = "Daily Reward";
    private Context context;
    private String currencyID;

    public TapjoyDailyRewardAd(Context ctx) {
        this.context = ctx;
        tapjoyURLConnection = new TapjoyURLConnection();
    }

    public void getDailyRewardAd(TapjoyDailyRewardAdNotifier notifier) {
        TapjoyLog.i("Daily Reward", "Getting Daily Reward Ad");
        getDailyRewardAdWithCurrencyID(null, notifier);
    }

    public void getDailyRewardAdWithCurrencyID(String theCurrencyID, TapjoyDailyRewardAdNotifier notifier) {
        this.currencyID = theCurrencyID;
        TapjoyLog.i("Daily Reward", "Getting Daily Reward ad userID: " + TapjoyConnectCore.getUserID() + ", currencyID: " + this.currencyID);
        dailyRewardNotifier = notifier;
        dailyRewardURLParams = TapjoyConnectCore.getURLParams();
        dailyRewardURLParams += "&publisher_user_id=" + TapjoyConnectCore.getUserID();
        if (this.currencyID != null) {
            dailyRewardURLParams += "&currency_id=" + this.currencyID;
        }
        new Thread(new Runnable() { // from class: com.tapjoy.TapjoyDailyRewardAd.1
            @Override // java.lang.Runnable
            public void run() {
                TapjoyHttpURLResponse httpResponse = TapjoyDailyRewardAd.tapjoyURLConnection.getResponseFromURL("https://ws.tapjoyads.com/reengagement_rewards?", TapjoyDailyRewardAd.dailyRewardURLParams);
                if (httpResponse != null) {
                    switch (httpResponse.statusCode) {
                        case 200:
                            String unused = TapjoyDailyRewardAd.htmlData = httpResponse.response;
                            TapjoyDailyRewardAd.dailyRewardNotifier.getDailyRewardAdResponse();
                            return;
                        case 204:
                            TapjoyDailyRewardAd.dailyRewardNotifier.getDailyRewardAdResponseFailed(1);
                            return;
                        default:
                            return;
                    }
                }
                TapjoyDailyRewardAd.dailyRewardNotifier.getDailyRewardAdResponseFailed(2);
            }
        }).start();
    }

    public void showDailyRewardAd() {
        TapjoyLog.i("Daily Reward", "Displaying Daily Reward ad...");
        if (htmlData != null && htmlData.length() != 0) {
            Intent intent = new Intent(this.context, TapjoyDailyRewardAdWebView.class);
            intent.setFlags(268435456);
            intent.putExtra(TapjoyConstants.EXTRA_RE_ENGAGEMENT_HTML_DATA, htmlData);
            this.context.startActivity(intent);
        }
    }
}
