package com.tapjoy;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.LinearLayout;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import com.unity3d.player.UnityPlayer;
import java.lang.reflect.Field;
import java.util.Hashtable;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public final class TapjoyConnectUnity implements TapjoyNotifier, TapjoyFullScreenAdNotifier, TapjoySpendPointsNotifier, TapjoyDisplayAdNotifier, TapjoyAwardPointsNotifier, TapjoyVideoNotifier, TapjoyDailyRewardAdNotifier {
    public static final String TAPJOY_UNITY = "TapjoyUnity";
    private static Activity activity;
    private static Field activityField;
    private static Context ctx;
    private static View displayAdView;
    private static int displayAdX;
    private static int displayAdY;
    private static Handler handler;
    private static Class<?> unityClass;
    private int tapjoyPointTotal = 0;
    private static TapjoyConnectUnity tapjoyUnity = null;
    private static TapjoyConnect tapjoyConnect = null;
    private static String handlerClassName = null;
    private static Hashtable<String, String> tempFlags = null;
    private static int earnedAmount = 0;
    private static String earnedCurrencyName = "Points";
    private static LinearLayout linearLayout = null;
    static final Runnable mUpdateResults = new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.6
        @Override // java.lang.Runnable
        public void run() {
            TapjoyConnectUnity.updateResultsInUi();
        }
    };
    static final Runnable removeDisplayAd = new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.7
        @Override // java.lang.Runnable
        public void run() {
            if (TapjoyConnectUnity.linearLayout != null) {
                TapjoyConnectUnity.linearLayout.removeAllViews();
            }
        }
    };
    static final Runnable showDefaultEarnedCurrencyAlert = new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.8
        @Override // java.lang.Runnable
        public void run() {
            try {
                new AlertDialog.Builder(TapjoyConnectUnity.ctx).setTitle("Congratulations!").setMessage("You've just earned " + TapjoyConnectUnity.getEarnedAmountTotal() + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + TapjoyConnectUnity.getEarnedCurrencyName()).setPositiveButton("OK", new DialogInterface.OnClickListener() { // from class: com.tapjoy.TapjoyConnectUnity.8.1
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                }).create().show();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public static void requestTapjoyConnect(Context context, String str, String str2) {
        requestTapjoyConnect(context, str, str2, tempFlags);
    }

    public static void requestTapjoyConnect(Context context, String str, String str2, Hashtable<String, String> hashtable) {
        tapjoyUnity = new TapjoyConnectUnity();
        try {
            unityClass = Class.forName("com.unity3d.player.UnityPlayer");
            activityField = unityClass.getField("currentActivity");
            activity = (Activity) activityField.get(unityClass);
        } catch (Exception e) {
            Log.e(TAPJOY_UNITY, "error getting Unity activity: " + e.toString());
        }
        if (activity != null) {
            activity.runOnUiThread(new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.1
                @Override // java.lang.Runnable
                public void run() {
                    Handler unused = TapjoyConnectUnity.handler = new Handler() { // from class: com.tapjoy.TapjoyConnectUnity.1.1
                        @Override // android.os.Handler
                        public void handleMessage(Message message) {
                            super.handleMessage(message);
                            if (message != null) {
                                if (message.arg1 == 42) {
                                    post(TapjoyConnectUnity.mUpdateResults);
                                } else if (message.arg1 == 911) {
                                    post(TapjoyConnectUnity.showDefaultEarnedCurrencyAlert);
                                } else {
                                    post(TapjoyConnectUnity.removeDisplayAd);
                                }
                            }
                        }
                    };
                }
            });
        }
        TapjoyConnectCore.setPlugin(TapjoyConstants.TJC_PLUGIN_UNITY);
        TapjoyConnect.requestTapjoyConnect(context, str, str2, tempFlags, new TapjoyConnectNotifier() { // from class: com.tapjoy.TapjoyConnectUnity.2
            @Override // com.tapjoy.TapjoyConnectNotifier
            public void connectSuccess() {
                UnityPlayer.UnitySendMessage(TapjoyConnectUnity.handlerClassName, "TapjoyConnectSuccess", "connect succeeded");
            }

            @Override // com.tapjoy.TapjoyConnectNotifier
            public void connectFail() {
                UnityPlayer.UnitySendMessage(TapjoyConnectUnity.handlerClassName, "TapjoyConnectSuccess", "connect failed");
            }
        });
        tapjoyConnect = TapjoyConnect.getTapjoyConnectInstance();
        tapjoyConnect.setEarnedPointsNotifier(new TapjoyEarnedPointsNotifier() { // from class: com.tapjoy.TapjoyConnectUnity.3
            @Override // com.tapjoy.TapjoyEarnedPointsNotifier
            public void earnedTapPoints(int i) {
                int unused = TapjoyConnectUnity.earnedAmount = i;
                UnityPlayer.UnitySendMessage(TapjoyConnectUnity.handlerClassName, "CurrencyEarned", "" + i);
            }
        });
    }

    public static TapjoyConnectUnity getTapjoyConnectInstance() {
        if (tapjoyUnity == null) {
            Log.e(TAPJOY_UNITY, "----------------------------------------");
            Log.e(TAPJOY_UNITY, "ERROR -- call requestTapjoyConnect before any other Tapjoy methods");
            Log.e(TAPJOY_UNITY, "----------------------------------------");
        }
        return tapjoyUnity;
    }

    private TapjoyConnectUnity() {
    }

    public void setUserID(String str) {
        tapjoyConnect.setUserID(str);
    }

    public String getUserID() {
        return tapjoyConnect.getUserID();
    }

    public String getAppID() {
        return tapjoyConnect.getAppID();
    }

    public void enablePaidAppWithActionID(String str) {
        tapjoyConnect.enablePaidAppWithActionID(str);
    }

    public void setCurrencyMultiplier(float f) {
        tapjoyConnect.setCurrencyMultiplier(f);
    }

    public float getCurrencyMultiplier() {
        return tapjoyConnect.getCurrencyMultiplier();
    }

    public void actionComplete(String str) {
        tapjoyConnect.actionComplete(str);
    }

    public void showOffers() {
        tapjoyConnect.showOffers();
    }

    public void showOffersWithCurrencyID(String str, boolean z) {
        tapjoyConnect.showOffersWithCurrencyID(str, z);
    }

    public void getTapPoints() {
        tapjoyConnect.getTapPoints(this);
    }

    public void spendTapPoints(int i) {
        tapjoyConnect.spendTapPoints(i, this);
    }

    public void awardTapPoints(int i) {
        tapjoyConnect.awardTapPoints(i, this);
    }

    public void getFullScreenAd() {
        tapjoyConnect.getFullScreenAd(this);
    }

    public void getFullScreenAdWithCurrencyID(String str) {
        tapjoyConnect.getFullScreenAdWithCurrencyID(str, this);
    }

    public void showFullScreenAd() {
        tapjoyConnect.showFullScreenAd();
    }

    public void getDailyRewardAd() {
        tapjoyConnect.getDailyRewardAd(this);
    }

    public void getDailyRewardAdWithCurrencyID(String str) {
        tapjoyConnect.getDailyRewardAdWithCurrencyID(str, this);
    }

    public void showDailyRewardAd() {
        tapjoyConnect.showDailyRewardAd();
    }

    public void setDisplayAdSize(String str) {
        tapjoyConnect.setDisplayAdSize(str);
    }

    public void enableDisplayAdAutoRefresh(boolean z) {
        tapjoyConnect.enableDisplayAdAutoRefresh(z);
    }

    public void getDisplayAd() {
        if (activity != null) {
            activity.runOnUiThread(new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.4
                @Override // java.lang.Runnable
                public void run() {
                    TapjoyConnectUnity.tapjoyConnect.getDisplayAd(TapjoyConnectUnity.this);
                }
            });
        }
    }

    public void getDisplayAdWithCurrencyID(final String str) {
        if (activity != null) {
            activity.runOnUiThread(new Runnable() { // from class: com.tapjoy.TapjoyConnectUnity.5
                @Override // java.lang.Runnable
                public void run() {
                    TapjoyConnectUnity.tapjoyConnect.getDisplayAdWithCurrencyID(str, TapjoyConnectUnity.this);
                }
            });
        }
    }

    public void setVideoCacheCount(int i) {
        tapjoyConnect.setVideoCacheCount(i);
    }

    public void cacheVideos() {
        tapjoyConnect.cacheVideos();
    }

    public void sendShutDownEvent() {
        tapjoyConnect.sendShutDownEvent();
    }

    public void sendIAPEvent(String str, float f, int i, String str2) {
        tapjoyConnect.sendIAPEvent(str, f, i, str2);
    }

    @Override // com.tapjoy.TapjoyDisplayAdNotifier
    public void getDisplayAdResponse(View view) {
        TapjoyLog.i(TAPJOY_UNITY, "getDisplayAdResponse");
        if (view == null) {
            TapjoyLog.i(TAPJOY_UNITY, "null ad");
        } else {
            TapjoyLog.i(TAPJOY_UNITY, "ad not null");
        }
        displayAdView = view;
        UnityPlayer.UnitySendMessage(handlerClassName, "DisplayAdLoaded", "success");
    }

    @Override // com.tapjoy.TapjoyDisplayAdNotifier
    public void getDisplayAdResponseFailed(String str) {
        TapjoyLog.i(TAPJOY_UNITY, "getDisplayAdResponseFailed: " + str);
        UnityPlayer.UnitySendMessage(handlerClassName, "DisplayAdError", str);
    }

    @Override // com.tapjoy.TapjoySpendPointsNotifier
    public void getSpendPointsResponse(String str, int i) {
        this.tapjoyPointTotal = i;
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsSpent", "success");
    }

    @Override // com.tapjoy.TapjoySpendPointsNotifier
    public void getSpendPointsResponseFailed(String str) {
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsSpendError", str);
    }

    @Override // com.tapjoy.TapjoyFullScreenAdNotifier
    public void getFullScreenAdResponse() {
        UnityPlayer.UnitySendMessage(handlerClassName, "FullScreenAdLoaded", "success");
    }

    @Override // com.tapjoy.TapjoyFullScreenAdNotifier
    public void getFullScreenAdResponseFailed(int i) {
        UnityPlayer.UnitySendMessage(handlerClassName, "FullScreenAdError", "" + i);
    }

    @Override // com.tapjoy.TapjoyNotifier
    public void getUpdatePoints(String str, int i) {
        earnedCurrencyName = str;
        this.tapjoyPointTotal = i;
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsLoaded", "success");
    }

    @Override // com.tapjoy.TapjoyNotifier
    public void getUpdatePointsFailed(String str) {
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsLoadedError", str);
    }

    @Override // com.tapjoy.TapjoyAwardPointsNotifier
    public void getAwardPointsResponse(String str, int i) {
        this.tapjoyPointTotal = i;
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsAwarded", "success");
    }

    @Override // com.tapjoy.TapjoyAwardPointsNotifier
    public void getAwardPointsResponseFailed(String str) {
        UnityPlayer.UnitySendMessage(handlerClassName, "TapPointsAwardError", str);
    }

    @Override // com.tapjoy.TapjoyVideoNotifier
    public void videoStart() {
        Log.i(TAPJOY_UNITY, "VIDEO START");
        UnityPlayer.UnitySendMessage(handlerClassName, "VideoStart", "success");
    }

    @Override // com.tapjoy.TapjoyVideoNotifier
    public void videoError(int i) {
        Log.i(TAPJOY_UNITY, "VIDEO ERROR: " + i);
        UnityPlayer.UnitySendMessage(handlerClassName, "VideoError", "" + i);
    }

    @Override // com.tapjoy.TapjoyVideoNotifier
    public void videoComplete() {
        Log.i(TAPJOY_UNITY, "VIDEO COMPLETE");
        UnityPlayer.UnitySendMessage(handlerClassName, "VideoComplete", "success");
    }

    @Override // com.tapjoy.TapjoyDailyRewardAdNotifier
    public void getDailyRewardAdResponse() {
        UnityPlayer.UnitySendMessage(handlerClassName, "DailyRewardAdLoaded", "success");
    }

    @Override // com.tapjoy.TapjoyDailyRewardAdNotifier
    public void getDailyRewardAdResponseFailed(int i) {
        UnityPlayer.UnitySendMessage(handlerClassName, "DailyRewardAdError", "" + i);
    }

    public static void setHandlerClass(String str) {
        Log.i(TAPJOY_UNITY, "setHandlerClass: " + str);
        handlerClassName = str;
    }

    public int getTapPointsTotal() {
        TapjoyLog.i(TAPJOY_UNITY, "getTapPointsTotal: " + this.tapjoyPointTotal);
        return this.tapjoyPointTotal;
    }

    public static int getEarnedAmountTotal() {
        return earnedAmount;
    }

    public static String getEarnedCurrencyName() {
        return earnedCurrencyName;
    }

    public void showDefaultEarnedCurrencyAlert() {
        Message message = new Message();
        message.arg1 = 911;
        if (handler != null) {
            handler.sendMessage(message);
        }
    }

    public static void setHandler(Handler handler2) {
    }

    public void hideDisplayAd() {
        TapjoyLog.i(TAPJOY_UNITY, "removeDisplayAd");
        if (handler != null) {
            handler.sendMessage(Message.obtain());
        }
    }

    public void showDisplayAd() {
        TapjoyLog.i(TAPJOY_UNITY, "showDisplayAd");
        Message message = new Message();
        message.arg1 = 42;
        if (handler != null) {
            handler.sendMessage(message);
        }
    }

    public void setDisplayAdPosition(int i, int i2) {
        displayAdX = i;
        displayAdY = i2;
        Message message = new Message();
        message.arg1 = 42;
        if (handler != null) {
            handler.sendMessage(message);
        }
    }

    public int getDisplayAdX() {
        return displayAdX;
    }

    public int getDisplayAdY() {
        return displayAdY;
    }

    public static void setFlagKeyValue(String str, String str2) {
        if (tempFlags == null) {
            tempFlags = new Hashtable<>();
        }
        TapjoyLog.i(TAPJOY_UNITY, "setFlagKeyValue: " + str + ", " + str2);
        tempFlags.put(str, str2);
    }

    static void updateResultsInUi() {
        try {
            WindowManager windowManager = (WindowManager) activity.getSystemService("window");
            int width = windowManager.getDefaultDisplay().getWidth();
            int height = windowManager.getDefaultDisplay().getHeight();
            if (displayAdView != null) {
                int i = displayAdView.getLayoutParams().width;
                int i2 = displayAdView.getLayoutParams().height;
                if (width < i) {
                    int intValue = Double.valueOf(Double.valueOf(Double.valueOf(width).doubleValue() / Double.valueOf(i).doubleValue()).doubleValue() * 100.0d).intValue();
                    ((WebView) displayAdView).getSettings().setSupportZoom(true);
                    ((WebView) displayAdView).setPadding(0, 0, 0, 0);
                    ((WebView) displayAdView).setVerticalScrollBarEnabled(false);
                    ((WebView) displayAdView).setHorizontalScrollBarEnabled(false);
                    ((WebView) displayAdView).setInitialScale(intValue);
                    displayAdView.setLayoutParams(new ViewGroup.LayoutParams(width, (i2 * width) / i));
                }
                if (linearLayout != null) {
                    linearLayout.removeAllViews();
                }
                linearLayout = new LinearLayout(activity);
                linearLayout.setLayoutParams(new ViewGroup.LayoutParams(width, height));
                linearLayout.setPadding(getTapjoyConnectInstance().getDisplayAdX(), getTapjoyConnectInstance().getDisplayAdY(), 0, 0);
                linearLayout.addView(displayAdView);
                activity.getWindow().addContentView(linearLayout, new ViewGroup.LayoutParams(width, height));
            }
        } catch (Exception e) {
            Log.e("TapjoyPluginActivity", "exception adding display ad: " + e.toString());
        }
    }
}
