package com.tapjoy;

import android.content.Context;
import android.util.Log;
import java.util.Hashtable;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public final class TapjoyConnect {
    public static final String TAPJOY_CONNECT = "TapjoyConnect";
    private static TapjoyConnect tapjoyConnectInstance = null;
    private static TJCOffers tapjoyOffers = null;
    private static TapjoyFullScreenAd tapjoyFullScreenAd = null;
    private static TapjoyDisplayAd tapjoyDisplayAd = null;
    private static TapjoyVideo tapjoyVideo = null;
    private static TapjoyEvent tapjoyEvent = null;
    private static TapjoyDailyRewardAd tapjoyDailyRewardAd = null;
    private static Hashtable<String, String> connectFlags = null;

    public static void setFlagKeyValue(String key, String value) {
        if (connectFlags == null) {
            connectFlags = new Hashtable<>();
        }
        connectFlags.put(key, value);
    }

    public static void enableLogging(boolean enable) {
        TapjoyLog.enableLogging(enable);
    }

    public static void requestTapjoyConnect(Context context, String appID, String secretKey) {
        requestTapjoyConnect(context, appID, secretKey, connectFlags);
    }

    public static void requestTapjoyConnect(Context context, String appID, String secretKey, Hashtable<String, String> flags) {
        requestTapjoyConnect(context, appID, secretKey, flags, null);
    }

    public static void requestTapjoyConnect(Context context, String appID, String secretKey, Hashtable<String, String> flags, TapjoyConnectNotifier notifier) {
        TapjoyConnectCore.setSDKType(TapjoyConstants.TJC_SDK_TYPE_OFFERS);
        tapjoyConnectInstance = new TapjoyConnect(context, appID, secretKey, flags, notifier);
        tapjoyOffers = new TJCOffers(context);
        tapjoyFullScreenAd = new TapjoyFullScreenAd(context);
        tapjoyDisplayAd = new TapjoyDisplayAd(context);
        tapjoyVideo = new TapjoyVideo(context);
        tapjoyEvent = new TapjoyEvent(context);
        tapjoyDailyRewardAd = new TapjoyDailyRewardAd(context);
        connectFlags = null;
    }

    public static TapjoyConnect getTapjoyConnectInstance() {
        if (tapjoyConnectInstance == null) {
            Log.e("TapjoyConnect", "----------------------------------------");
            Log.e("TapjoyConnect", "ERROR -- call requestTapjoyConnect before any other Tapjoy methods");
            Log.e("TapjoyConnect", "----------------------------------------");
        }
        return tapjoyConnectInstance;
    }

    private TapjoyConnect(Context context, String appID, String secretKey, Hashtable<String, String> flags, TapjoyConnectNotifier notifier) {
        TapjoyConnectCore.requestTapjoyConnect(context, appID, secretKey, flags, notifier);
    }

    public void setUserID(String userID) {
        TapjoyConnectCore.setUserID(userID);
    }

    public String getUserID() {
        return TapjoyConnectCore.getUserID();
    }

    public String getAppID() {
        return TapjoyConnectCore.getAppID();
    }

    public void enablePaidAppWithActionID(String paidAppPayPerActionID) {
        TapjoyConnectCore.getInstance().enablePaidAppWithActionID(paidAppPayPerActionID);
    }

    public void setCurrencyMultiplier(float multiplier) {
        TapjoyConnectCore.getInstance().setCurrencyMultiplier(multiplier);
    }

    public float getCurrencyMultiplier() {
        return TapjoyConnectCore.getInstance().getCurrencyMultiplier();
    }

    public void actionComplete(String actionID) {
        TapjoyConnectCore.getInstance().actionComplete(actionID);
    }

    public void showOffers() {
        tapjoyOffers.showOffers();
    }

    public void showOffersWithCurrencyID(String currencyID, boolean enableCurrencySelector) {
        tapjoyOffers.showOffersWithCurrencyID(currencyID, enableCurrencySelector);
    }

    public void getTapPoints(TapjoyNotifier notifier) {
        tapjoyOffers.getTapPoints(notifier);
    }

    public void spendTapPoints(int amount, TapjoySpendPointsNotifier notifier) {
        tapjoyOffers.spendTapPoints(amount, notifier);
    }

    public void awardTapPoints(int amount, TapjoyAwardPointsNotifier notifier) {
        tapjoyOffers.awardTapPoints(amount, notifier);
    }

    public void setEarnedPointsNotifier(TapjoyEarnedPointsNotifier notifier) {
        tapjoyOffers.setEarnedPointsNotifier(notifier);
    }

    public void getFullScreenAd(TapjoyFullScreenAdNotifier notifier) {
        tapjoyFullScreenAd.getFullScreenAd(notifier);
    }

    public void getFullScreenAdWithCurrencyID(String currencyID, TapjoyFullScreenAdNotifier notifier) {
        tapjoyFullScreenAd.getFullScreenAd(currencyID, notifier);
    }

    public void showFullScreenAd() {
        tapjoyFullScreenAd.showFullScreenAd();
    }

    public void getFeaturedApp(TapjoyFeaturedAppNotifier notifier) {
        tapjoyFullScreenAd.getFeaturedApp(notifier);
    }

    public void getFeaturedAppWithCurrencyID(String currencyID, TapjoyFeaturedAppNotifier notifier) {
        tapjoyFullScreenAd.getFeaturedApp(currencyID, notifier);
    }

    public void setFeaturedAppDisplayCount(int count) {
        tapjoyFullScreenAd.setDisplayCount(count);
    }

    public void showFeaturedAppFullScreenAd() {
        tapjoyFullScreenAd.showFeaturedAppFullScreenAd();
    }

    public void getDailyRewardAd(TapjoyDailyRewardAdNotifier notifier) {
        tapjoyDailyRewardAd.getDailyRewardAd(notifier);
    }

    public void getDailyRewardAdWithCurrencyID(String currencyID, TapjoyDailyRewardAdNotifier notifier) {
        tapjoyDailyRewardAd.getDailyRewardAdWithCurrencyID(currencyID, notifier);
    }

    public void showDailyRewardAd() {
        tapjoyDailyRewardAd.showDailyRewardAd();
    }

    public void setDisplayAdSize(String dimensions) {
        tapjoyDisplayAd.setDisplayAdSize(dimensions);
    }

    public void setBannerAdSize(String dimensions) {
        tapjoyDisplayAd.setBannerAdSize(dimensions);
    }

    public void enableDisplayAdAutoRefresh(boolean shouldAutoRefresh) {
        tapjoyDisplayAd.enableAutoRefresh(shouldAutoRefresh);
    }

    public void enableBannerAdAutoRefresh(boolean shouldAutoRefresh) {
        tapjoyDisplayAd.enableAutoRefresh(shouldAutoRefresh);
    }

    public void getDisplayAd(TapjoyDisplayAdNotifier notifier) {
        tapjoyDisplayAd.getDisplayAd(notifier);
    }

    public void getDisplayAdWithCurrencyID(String currencyID, TapjoyDisplayAdNotifier notifier) {
        tapjoyDisplayAd.getDisplayAd(currencyID, notifier);
    }

    public void initVideoAd(TapjoyVideoNotifier notifier) {
        tapjoyVideo.initVideoAd(notifier);
    }

    public void setVideoCacheCount(int count) {
        tapjoyVideo.setVideoCacheCount(count);
    }

    public void enableVideoCache(boolean enable) {
        tapjoyVideo.enableVideoCache(enable);
    }

    public void cacheVideos() {
        tapjoyVideo.cacheVideos();
    }

    public void setVideoNotifier(TapjoyVideoNotifier notifier) {
        tapjoyVideo.setVideoNotifier(notifier);
    }

    public void sendShutDownEvent() {
        tapjoyEvent.sendShutDownEvent();
    }

    public void sendIAPEvent(String name, float price, int quantity, String currencyCode) {
        tapjoyEvent.sendIAPEvent(name, price, quantity, currencyCode);
    }
}
