package com.pushwoosh.unity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class PWUnityPlayerProxyActivity extends Activity {
    @Override // android.app.Activity
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String[] classNames = {"com.pushwoosh.unity.PWUnityPlayerActivity", "com.pushwoosh.unity.PWUnityPlayerNativeActivity"};
        copyPlayerPrefs(this, classNames);
        try {
            boolean supportsNative = Build.VERSION.SDK_INT >= 9;
            Class<?> activity = Class.forName(classNames[supportsNative ? (char) 1 : (char) 0]);
            Intent intent = new Intent(this, activity);
            intent.addFlags(65536);
            Bundle extras = getIntent().getExtras();
            if (extras != null) {
                intent.putExtras(extras);
            }
            startActivity(intent);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } finally {
            finish();
        }
    }

    protected static void copyPlayerPrefs(Context context, String[] activityClassNames) {
        SharedPreferences packagePrefs = context.getSharedPreferences(context.getPackageName(), 0);
        if (packagePrefs.getAll().isEmpty()) {
            SharedPreferences.Editor playerPrefs = packagePrefs.edit();
            for (String name : activityClassNames) {
                SharedPreferences prefs = context.getSharedPreferences(name, 0);
                Map<String, ?> keys = prefs.getAll();
                if (!keys.isEmpty()) {
                    for (Map.Entry<String, ?> entry : keys.entrySet()) {
                        Object value = entry.getValue();
                        if (value.getClass() == Integer.class) {
                            playerPrefs.putInt(entry.getKey(), ((Integer) value).intValue());
                        } else if (value.getClass() == Float.class) {
                            playerPrefs.putFloat(entry.getKey(), ((Float) value).floatValue());
                        } else if (value.getClass() == String.class) {
                            playerPrefs.putString(entry.getKey(), (String) value);
                        }
                    }
                    playerPrefs.commit();
                }
            }
        }
    }
}
