package com.pushwoosh.unity;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.arellomobile.android.push.PushManager;
import com.arellomobile.android.push.PushwooshProxy;
import com.unity3d.player.UnityPlayerActivity;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class PWUnityPlayerActivity extends UnityPlayerActivity {
    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.unity3d.player.UnityPlayerActivity, android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PushwooshProxy.instance().setContext(this);
        try {
            ApplicationInfo ai = getPackageManager().getApplicationInfo(getApplicationContext().getPackageName(), 128);
            String pwAppid = ai.metaData.getString("PW_APPID");
            System.out.println("App ID: " + pwAppid);
            String projectId = ai.metaData.getString("PW_PROJECT_ID").substring(1);
            System.out.println("Project ID: " + projectId);
            PushManager pushManager = new PushManager(this, pwAppid, projectId);
            pushManager.onStartup(this);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        checkMessage(getIntent());
    }

    private void checkMessage(Intent intent) {
        if (intent != null) {
            if (intent.hasExtra(PushManager.PUSH_RECEIVE_EVENT)) {
                PushwooshProxy.instance().onPushReceiveEvent(intent.getExtras().getString(PushManager.PUSH_RECEIVE_EVENT));
            } else if (intent.hasExtra(PushManager.REGISTER_EVENT)) {
                PushwooshProxy.instance().onRegisterEvent(intent.getExtras().getString(PushManager.REGISTER_EVENT));
            } else if (intent.hasExtra(PushManager.UNREGISTER_EVENT)) {
                PushwooshProxy.instance().onUnRegisterEvent(intent.getExtras().getString(PushManager.UNREGISTER_EVENT));
            } else if (intent.hasExtra(PushManager.REGISTER_ERROR_EVENT)) {
                PushwooshProxy.instance().onRegisterErrorEvent(intent.getExtras().getString(PushManager.REGISTER_ERROR_EVENT));
            } else if (intent.hasExtra(PushManager.UNREGISTER_ERROR_EVENT)) {
                PushwooshProxy.instance().onUnRegisterErrorEvent(intent.getExtras().getString(PushManager.UNREGISTER_ERROR_EVENT));
            }
        }
    }

    @Override // android.app.Activity
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        checkMessage(intent);
    }
}
