package com.prime31;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class WebViewActivity extends Activity {
    private ProgressDialog _spinner;
    private WebView _webView;

    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this._spinner = new ProgressDialog(this);
        this._spinner.requestWindowFeature(1);
        this._spinner.setMessage("Loading...");
        String url = getIntent().getExtras().getString("url");
        setUpWebView(url.toLowerCase().contains("twitter"));
        this._webView.loadUrl(url);
    }

    private void setUpWebView(boolean setUserAgentString) {
        this._webView = new WebView(this);
        this._webView.setWebViewClient(new P31WebViewClient(this, null));
        this._webView.getSettings().setLoadWithOverviewMode(true);
        this._webView.getSettings().setUseWideViewPort(true);
        this._webView.getSettings().setJavaScriptEnabled(true);
        this._webView.getSettings().setPluginsEnabled(true);
        this._webView.getSettings().setAllowFileAccess(true);
        this._webView.getSettings().setGeolocationEnabled(true);
        this._webView.getSettings().setSupportZoom(true);
        this._webView.getSettings().setBuiltInZoomControls(true);
        this._webView.getSettings().setSaveFormData(true);
        this._webView.getSettings().setSavePassword(true);
        this._webView.getSettings().setAppCacheEnabled(true);
        this._webView.getSettings().setDatabaseEnabled(true);
        if (setUserAgentString) {
            this._webView.getSettings().setUserAgentString("Mozilla/5.0 (Linux; U; Android 2.0; en-us; Droid Build/ESD20) AppleWebKit/530.17 (KHTML, like Gecko) Version/4.0 Mobile Safari/530.17");
        }
        setContentView(this._webView);
    }

    @Override // android.app.Activity
    public void onBackPressed() {
        EtceteraPlugin.instance().UnitySendMessage("EtceteraAndroidManager", "webViewCancelled", "");
        super.onBackPressed();
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public class P31WebViewClient extends WebViewClient {
        private P31WebViewClient() {
        }

        /* synthetic */ P31WebViewClient(WebViewActivity webViewActivity, P31WebViewClient p31WebViewClient) {
            this();
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WebViewActivity.this._spinner.dismiss();
        }

        @Override // android.webkit.WebViewClient
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            WebViewActivity.this._spinner.show();
        }

        @Override // android.webkit.WebViewClient
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            WebViewActivity.this._spinner.dismiss();
        }
    }
}
