package com.prime31;

import android.content.Context;
import android.content.SharedPreferences;
import org.scribe.model.Token;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TwitterSession {
    private static final String SHARED = "Twitter_Preferences";
    private static final String TWEET_AUTH_KEY = "auth_key";
    private static final String TWEET_AUTH_SECRET_KEY = "auth_secret_key";
    private static final String TWEET_USER_NAME = "user_name";
    private SharedPreferences.Editor editor;
    private SharedPreferences sharedPref;

    public TwitterSession(Context context) {
        this.sharedPref = context.getSharedPreferences(SHARED, 0);
        this.editor = this.sharedPref.edit();
    }

    public void storeAccessToken(Token accessToken, String username) {
        this.editor.putString(TWEET_AUTH_KEY, accessToken.getToken());
        this.editor.putString(TWEET_AUTH_SECRET_KEY, accessToken.getSecret());
        this.editor.putString(TWEET_USER_NAME, username);
        this.editor.commit();
    }

    public void resetAccessToken() {
        this.editor.putString(TWEET_AUTH_KEY, null);
        this.editor.putString(TWEET_AUTH_SECRET_KEY, null);
        this.editor.putString(TWEET_USER_NAME, null);
        this.editor.commit();
    }

    public String getUsername() {
        return this.sharedPref.getString(TWEET_USER_NAME, "");
    }

    public Token getAccessToken() {
        String token = this.sharedPref.getString(TWEET_AUTH_KEY, null);
        String tokenSecret = this.sharedPref.getString(TWEET_AUTH_SECRET_KEY, null);
        if (token == null || tokenSecret == null) {
            return null;
        }
        return new Token(token, tokenSecret);
    }
}
