package com.prime31;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.Timer;
import java.util.TimerTask;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class TwitterDialog extends Dialog {
    static final FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
    static final int MARGIN = 4;
    static final int PADDING = 2;
    private static final String TAG = "Prime31-TD";
    private FrameLayout _content;
    private DialogListener _listener;
    private ProgressDialog _spinner;
    private TextView _title;
    private String _url;
    private WebView _webView;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public interface DialogListener {
        void onComplete(String str);

        void onError(String str);
    }

    public TwitterDialog(Context context, String url, DialogListener listener) {
        super(context, 16973831);
        this._url = url;
        this._listener = listener;
    }

    @Override // android.app.Dialog
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this._spinner = new ProgressDialog(getContext());
        this._spinner.requestWindowFeature(1);
        this._spinner.setMessage("Loading...");
        this._content = new FrameLayout(getContext());
        setUpTitle();
        setUpWebView();
        addContentView(this._content, new ViewGroup.LayoutParams(-1, -1));
        this._content.setVisibility(4);
        Log.i(TAG, "showing Twitter dialog filling parents horizontally and vertically");
    }

    private void setUpTitle() {
        requestWindowFeature(1);
        this._title = new TextView(getContext());
        this._title.setText("Twitter");
        this._title.setTextColor(-1);
        this._title.setTypeface(Typeface.DEFAULT_BOLD);
        this._title.setBackgroundColor(-4466711);
        this._title.setPadding(6, 4, 4, 4);
        this._title.setCompoundDrawablePadding(6);
        this._content.addView(this._title);
    }

    private void setUpWebView() {
        this._webView = new WebView(getContext());
        this._webView.getSettings().setJavaScriptEnabled(true);
        this._webView.getSettings().setSavePassword(false);
        this._webView.setVerticalScrollBarEnabled(false);
        this._webView.setHorizontalScrollBarEnabled(false);
        this._webView.setWebViewClient(new TwitterWebViewClient(this, null));
        this._webView.loadUrl(this._url);
        this._webView.setLayoutParams(FILL);
        this._webView.setVisibility(4);
        this._content.addView(this._webView);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public class TwitterWebViewClient extends WebViewClient {
        private TwitterWebViewClient() {
        }

        /* synthetic */ TwitterWebViewClient(TwitterDialog twitterDialog, TwitterWebViewClient twitterWebViewClient) {
            this();
        }

        @Override // android.webkit.WebViewClient
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.d(TwitterDialog.TAG, "Redirect URL " + url);
            if (url.startsWith(TwitterPlugin.callbackUrlPrefix)) {
                Log.d(TwitterDialog.TAG, "found our redirect url. getting out of here and dismissing web view");
                if (url.contains("denied")) {
                    TwitterDialog.this._listener.onError("canceled");
                } else {
                    TwitterDialog.this._listener.onComplete(url);
                }
                final Timer timer = new Timer();
                timer.scheduleAtFixedRate(new TimerTask() { // from class: com.prime31.TwitterDialog.TwitterWebViewClient.1
                    @Override // java.util.TimerTask, java.lang.Runnable
                    public void run() {
                        TwitterDialog.this.dismiss();
                        timer.cancel();
                    }
                }, 10000, 1000);
                return true;
            }
            if (url.startsWith("authorize")) {
            }
            return false;
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            Log.d(TwitterDialog.TAG, "Page error: " + description);
            TwitterDialog.this._listener.onError(description);
            TwitterDialog.this.dismiss();
        }

        @Override // android.webkit.WebViewClient
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Log.d(TwitterDialog.TAG, "Loading URL: " + url);
            super.onPageStarted(view, url, favicon);
            TwitterDialog.this._spinner.show();
            TwitterDialog.this._content.setVisibility(4);
        }

        @Override // android.webkit.WebViewClient
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            String title = TwitterDialog.this._webView.getTitle();
            if (title != null && title.length() > 0) {
                TwitterDialog.this._title.setText(title);
            }
            TwitterDialog.this._spinner.dismiss();
            TwitterDialog.this._content.setBackgroundColor(0);
            TwitterDialog.this._content.setVisibility(0);
            TwitterDialog.this._webView.setVisibility(0);
        }
    }
}
