package com.prime31;

import android.app.Activity;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.MediaController;
import java.io.FileInputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class P31VideoPlayerActivity extends Activity implements MediaPlayer.OnBufferingUpdateListener, MediaPlayer.OnCompletionListener, MediaPlayer.OnPreparedListener, MediaPlayer.OnVideoSizeChangedListener, SurfaceHolder.Callback, MediaController.MediaPlayerControl {
    private static final String SAVED_POSITION = "SAVED_POSITION";
    private static final String TAG = "Prime31";
    private int _bufferedPercent;
    private SurfaceHolder _holder;
    private FrameLayout _layout;
    private MediaController _mediaController;
    private MediaPlayer _mediaPlayer;
    private String _path;
    private SurfaceView _preview;
    private int _scalingMode;
    private boolean _showControls;
    private int _videoHeight;
    private int _videoWidth;
    private int _savedPositionBeforeRotation = 0;
    private boolean _isVideoSizeKnown = false;
    private boolean _isVideoReadyToBePlayed = false;
    private boolean _isRemoteVideo = false;
    private boolean _closeOnTouch = false;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public enum ScalingMode {
        NONE,
        ASPECT_FIT,
        FILL;

        /* renamed from: values  reason: to resolve conflict with enum method */
        public static ScalingMode[] valuesCustom() {
            ScalingMode[] valuesCustom = values();
            int length = valuesCustom.length;
            ScalingMode[] scalingModeArr = new ScalingMode[length];
            System.arraycopy(valuesCustom, 0, scalingModeArr, 0, length);
            return scalingModeArr;
        }
    }

    @Override // android.app.Activity
    public void onCreate(Bundle icicle) {
        setTheme(16973831);
        super.onCreate(icicle);
        Bundle returnData = (Bundle) getLastNonConfigurationInstance();
        if (returnData != null) {
            this._savedPositionBeforeRotation = returnData.getInt(SAVED_POSITION);
            Log.i(TAG, "retrieved saved position: " + this._savedPositionBeforeRotation);
        }
        this._layout = new FrameLayout(this);
        this._preview = new SurfaceView(this);
        this._layout.addView(this._preview);
        setContentView(this._layout);
        this._holder = this._preview.getHolder();
        this._holder.addCallback(this);
        this._holder.setType(3);
        Bundle extras = getIntent().getExtras();
        this._showControls = extras.getBoolean("showControls");
        if (!this._showControls) {
            this._closeOnTouch = extras.getBoolean("closeOnTouch");
        }
        this._path = extras.getString("path");
        this._isRemoteVideo = this._path.startsWith("http");
        this._layout.setBackgroundColor(extras.getInt("color"));
        this._scalingMode = extras.getInt("scalingMode");
    }

    @Override // android.app.Activity
    protected void onStop() {
        super.onStop();
        Log.i(TAG, "onStop");
        releaseMediaPlayer();
    }

    @Override // android.app.Activity
    public Object onRetainNonConfigurationInstance() {
        Bundle data = new Bundle();
        data.putInt(SAVED_POSITION, this._savedPositionBeforeRotation);
        return data;
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private void playVideo() {
        Log.e(TAG, "preparing to play video: " + this._path);
        doCleanUp();
        try {
            this._mediaPlayer = new MediaPlayer();
            if (this._isRemoteVideo) {
                this._mediaPlayer.setDataSource(this._path);
            } else {
                String cachesDir = getCacheDir().getAbsolutePath();
                if (this._path.contains(cachesDir)) {
                    Log.i(TAG, "playing video from caches through a FileInputStream");
                    FileInputStream fileInputStream = new FileInputStream(this._path);
                    this._mediaPlayer.setDataSource(fileInputStream.getFD());
                } else {
                    Log.i(TAG, "playing video from assets");
                    AssetFileDescriptor afd = getAssets().openFd(this._path);
                    this._mediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                }
            }
            this._mediaPlayer.setDisplay(this._holder);
            this._mediaPlayer.prepare();
            this._mediaPlayer.setOnBufferingUpdateListener(this);
            this._mediaPlayer.setOnCompletionListener(this);
            this._mediaPlayer.setOnPreparedListener(this);
            this._mediaPlayer.setOnVideoSizeChangedListener(this);
            this._mediaPlayer.setAudioStreamType(3);
            if (this._showControls) {
                this._mediaController = new MediaController(this);
                this._mediaController.setMediaPlayer(this);
                this._mediaController.setAnchorView(this._preview);
                this._mediaController.setEnabled(true);
                this._mediaController.show();
            }
        } catch (Exception e) {
            Log.e(TAG, "error: " + e.getMessage());
        }
    }

    private void stopAndReleaseVideoPlayer() {
        if (this._mediaPlayer != null) {
            if (this._mediaPlayer.isPlaying()) {
                this._mediaPlayer.stop();
            }
            releaseMediaPlayer();
        }
    }

    private void adjustVideoSize() {
        if (this._scalingMode != ScalingMode.FILL.ordinal() && this._mediaPlayer != null && !this._mediaPlayer.isPlaying()) {
            WindowManager winMan = (WindowManager) getSystemService("window");
            int winHeight = winMan.getDefaultDisplay().getHeight();
            int winWidth = winMan.getDefaultDisplay().getWidth();
            int width = 0;
            int height = 0;
            if (this._scalingMode == ScalingMode.ASPECT_FIT.ordinal()) {
                float ratio = this._videoWidth / this._videoHeight;
                float windowRatio = winWidth / winHeight;
                if (windowRatio <= ratio) {
                    width = winWidth;
                    height = (int) (width * (this._videoHeight / this._videoWidth));
                } else {
                    height = winHeight;
                    width = (int) (height * ratio);
                }
            } else if (this._scalingMode == ScalingMode.NONE.ordinal()) {
                width = this._videoWidth;
                height = this._videoHeight;
            }
            Log.i(TAG, "calculated video width: " + width + ", height: " + height);
            FrameLayout.LayoutParams localLayoutParams = new FrameLayout.LayoutParams(width, height, 17);
            this._layout.updateViewLayout(this._preview, localLayoutParams);
        }
    }

    @Override // android.media.MediaPlayer.OnBufferingUpdateListener
    public void onBufferingUpdate(MediaPlayer arg0, int percent) {
        this._bufferedPercent = percent;
    }

    @Override // android.media.MediaPlayer.OnCompletionListener
    public void onCompletion(MediaPlayer arg0) {
        Log.i(TAG, "onCompletion");
        if (!this._showControls) {
            Log.i(TAG, "video complete. releasing player and finishing");
            releaseMediaPlayer();
            finish();
        }
    }

    @Override // android.media.MediaPlayer.OnVideoSizeChangedListener
    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Log.v(TAG, "onVideoSizeChanged called");
        if (width == 0 || height == 0) {
            Log.e(TAG, "invalid video width(" + width + ") or height(" + height + ")");
            return;
        }
        this._isVideoSizeKnown = true;
        this._videoWidth = width;
        this._videoHeight = height;
        if (this._isVideoReadyToBePlayed && this._isVideoSizeKnown) {
            adjustVideoSize();
            startVideoPlayback();
        }
    }

    @Override // android.media.MediaPlayer.OnPreparedListener
    public void onPrepared(MediaPlayer mediaplayer) {
        Log.d(TAG, "onPrepared called");
        this._isVideoReadyToBePlayed = true;
        if (this._isVideoReadyToBePlayed && this._isVideoSizeKnown) {
            adjustVideoSize();
            startVideoPlayback();
        }
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceChanged(SurfaceHolder surfaceholder, int i, int j, int k) {
        Log.d(TAG, "surfaceChanged called");
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceDestroyed(SurfaceHolder surfaceholder) {
        Log.d(TAG, "surfaceDestroyed called");
    }

    @Override // android.view.SurfaceHolder.Callback
    public void surfaceCreated(SurfaceHolder holder) {
        Log.d(TAG, "surfaceCreated called");
        playVideo();
    }

    @Override // android.app.Activity
    protected void onPause() {
        super.onPause();
        releaseMediaPlayer();
        doCleanUp();
    }

    @Override // android.app.Activity
    protected void onDestroy() {
        super.onDestroy();
        releaseMediaPlayer();
        doCleanUp();
    }

    @Override // android.app.Activity
    public boolean onTouchEvent(MotionEvent evt) {
        if (this._mediaController != null && this._mediaPlayer != null) {
            this._mediaController.onTouchEvent(evt);
        } else if (!this._showControls && this._mediaPlayer != null && this._closeOnTouch) {
            Log.i(TAG, "screen touched and closeOnTouch is true. releasing player and finishing");
            releaseMediaPlayer();
            finish();
        }
        return super.onTouchEvent(evt);
    }

    private void releaseMediaPlayer() {
        if (this._mediaPlayer != null) {
            this._mediaPlayer.release();
            this._mediaPlayer = null;
        }
    }

    private void doCleanUp() {
        this._videoWidth = 0;
        this._videoHeight = 0;
        this._isVideoReadyToBePlayed = false;
        this._isVideoSizeKnown = false;
    }

    private void startVideoPlayback() {
        this._holder.setFixedSize(this._videoWidth, this._videoHeight);
        if (this._savedPositionBeforeRotation > 0) {
            this._mediaPlayer.seekTo(this._savedPositionBeforeRotation);
            this._savedPositionBeforeRotation = 0;
        }
        this._mediaPlayer.start();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public boolean canPause() {
        return true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public boolean canSeekBackward() {
        return true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public boolean canSeekForward() {
        return true;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public int getBufferPercentage() {
        return this._bufferedPercent;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public int getCurrentPosition() {
        if (this._mediaPlayer == null) {
            return 0;
        }
        this._savedPositionBeforeRotation = this._mediaPlayer.getCurrentPosition();
        return this._savedPositionBeforeRotation;
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public int getDuration() {
        if (this._mediaPlayer == null) {
            return 0;
        }
        return this._mediaPlayer.getDuration();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public boolean isPlaying() {
        if (this._mediaPlayer == null) {
            return false;
        }
        return this._mediaPlayer.isPlaying();
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public void pause() {
        if (this._mediaPlayer != null) {
            this._mediaPlayer.pause();
        }
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public void seekTo(int pos) {
        if (this._mediaPlayer != null) {
            this._mediaPlayer.seekTo(pos);
        }
    }

    @Override // android.widget.MediaController.MediaPlayerControl
    public void start() {
        if (this._mediaPlayer != null) {
            this._mediaPlayer.start();
        }
    }
}
