package com.prime31;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.urbanairship.UAirship;
import com.urbanairship.push.PushManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class P31UAIntentReceiver extends BroadcastReceiver {
    private static final String TAG = "Prime31";

    @Override // android.content.BroadcastReceiver
    public void onReceive(Context context, Intent intent) {
        Log.i(TAG, "Received intent: " + intent.toString());
        String action = intent.getAction();
        if (action.equals(PushManager.ACTION_PUSH_RECEIVED)) {
            int id = intent.getIntExtra(PushManager.EXTRA_NOTIFICATION_ID, 0);
            Log.i(TAG, "Received push notification. Alert: " + intent.getStringExtra(PushManager.EXTRA_ALERT) + " [NotificationID=" + id + "]");
            logPushExtras(intent);
        } else if (action.equals(PushManager.ACTION_NOTIFICATION_OPENED)) {
            Log.i(TAG, "User clicked notification. Message: " + intent.getStringExtra(PushManager.EXTRA_ALERT));
            logPushExtras(intent);
            try {
                Intent launch = new Intent("android.intent.action.MAIN");
                launch.setFlags(268435456);
                launch.setClass(UAirship.shared().getApplicationContext(), Class.forName("com.unity3d.player.UnityPlayerProxyActivity"));
                UAirship.shared().getApplicationContext().startActivity(launch);
            } catch (Exception e) {
                Log.i(TAG, "Error trying to relaunch after push received: " + e.getMessage());
            }
        } else if (action.equals(PushManager.ACTION_REGISTRATION_FINISHED)) {
            Log.i(TAG, "Registration complete. APID:" + intent.getStringExtra(PushManager.EXTRA_APID) + ". Valid: " + intent.getBooleanExtra(PushManager.EXTRA_REGISTRATION_VALID, false));
        }
    }

    private void logPushExtras(Intent intent) {
        Set<String> keys = intent.getExtras().keySet();
        for (String key : keys) {
            List<String> ignoredKeys = Arrays.asList("collapse_key", "from", PushManager.EXTRA_NOTIFICATION_ID, PushManager.EXTRA_PUSH_ID, PushManager.EXTRA_ALERT);
            if (!ignoredKeys.contains(key)) {
                Log.i(TAG, "Push Notification Extra: [" + key + " : " + intent.getStringExtra(key) + "]");
            }
        }
    }
}
