package com.prime31;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class GoogleIABProxyActivity extends Activity {
    private static final int RC_REQUEST = 10001;
    private static final String TAG = "Prime31-Proxy";
    private Boolean _created = false;

    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this._created.booleanValue()) {
            Log.i("Prime31", "activity created twice. stopping one instance");
            return;
        }
        this._created = true;
        try {
            String sku = getIntent().getExtras().getString("sku");
            String developerPayload = getIntent().getExtras().getString("developerPayload");
            Log.i(TAG, "proxy received action. sku: " + sku);
            GoogleIABPlugin.instance().helper.launchPurchaseFlow(this, sku, RC_REQUEST, GoogleIABPlugin.instance(), developerPayload);
        } catch (Exception e) {
            Log.i(TAG, "unhandled exception while attempting to purchase item: " + e.getMessage());
            Log.i(TAG, "going to end the async operation with null data to clear out the queue");
            GoogleIABPlugin.instance().helper.handleActivityResult(RC_REQUEST, 0, null);
            finish();
        }
    }

    @Override // android.app.Activity
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        IABConstants.logEntering(getClass().getSimpleName(), "onActivityResult", new Object[]{Integer.valueOf(requestCode), Integer.valueOf(resultCode), data});
        if (!GoogleIABPlugin.instance().helper.handleActivityResult(requestCode, resultCode, data)) {
            super.onActivityResult(requestCode, resultCode, data);
        } else {
            Log.d(TAG, "onActivityResult handled by IABUtil. All done here.");
        }
        finish();
    }
}
