package com.prime31;

import android.content.Intent;
import android.util.Log;
import com.prime31.util.IabHelper;
import com.prime31.util.IabResult;
import com.prime31.util.Inventory;
import com.prime31.util.Purchase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class GoogleIABPlugin extends GoogleIABPluginBase implements IabHelper.QueryInventoryFinishedListener, IabHelper.OnIabPurchaseFinishedListener, IabHelper.OnConsumeFinishedListener, IabHelper.OnConsumeMultiFinishedListener {
    static final int RC_REQUEST = 10001;
    private boolean _hasQueriedInventory = false;
    private List<Purchase> _purchases;
    public IabHelper helper;

    private Purchase getPurchasedProductForSku(String sku) {
        for (Purchase p : this._purchases) {
            if (p.getSku().equalsIgnoreCase(sku)) {
                return p;
            }
        }
        return null;
    }

    public void enableLogging(boolean shouldEnable) {
        IABConstants.DEBUG = shouldEnable;
    }

    public void setAutoVerifySignatures(boolean shouldVerify) {
        IabHelper.autoVerifySignatures = shouldVerify;
    }

    public void init(String publicKey) {
        IABConstants.logEntering(getClass().getSimpleName(), "init", publicKey);
        this._purchases = new ArrayList();
        this.helper = new IabHelper(getActivity(), publicKey);
        this.helper.startSetup(new IabHelper.OnIabSetupFinishedListener() { // from class: com.prime31.GoogleIABPlugin.1
            @Override // com.prime31.util.IabHelper.OnIabSetupFinishedListener
            public void onIabSetupFinished(IabResult result) {
                if (result.isSuccess()) {
                    GoogleIABPlugin.this.UnitySendMessage("GoogleIABManager", "billingSupported", "");
                    return;
                }
                Log.i("Prime31", "billing not supported: " + result.getMessage());
                GoogleIABPlugin.this.UnitySendMessage("GoogleIABManager", "billingNotSupported", result.getMessage());
            }
        });
    }

    public void unbindService() {
        IABConstants.logEntering(getClass().getSimpleName(), "unbindService");
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
    }

    public void queryInventory(final String[] skus) {
        IABConstants.logEntering(getClass().getSimpleName(), "queryInventory", (Object[]) skus);
        if (this.helper == null) {
            Log.i("Prime31", "The billing service is not running");
        } else {
            getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.GoogleIABPlugin.2
                @Override // java.lang.Runnable
                public void run() {
                    GoogleIABPlugin.this.helper.queryInventoryAsync(true, Arrays.asList(skus), GoogleIABPlugin.this);
                }
            });
        }
    }

    public void purchaseProduct(final String sku, final String developerPayload) {
        IABConstants.logEntering(getClass().getSimpleName(), "purchaseProduct", new Object[]{sku, developerPayload});
        if (this.helper == null) {
            Log.i("Prime31", "The billing service is not running");
            return;
        }
        if (!this._hasQueriedInventory) {
            Log.w("Prime31", "You have not queried your inventory yet so the plugin does not have the required information to protect you from coding errors.");
        }
        for (Purchase p : this._purchases) {
            if (p.getSku().equalsIgnoreCase(sku)) {
                UnitySendMessage("GoogleIABManager", "purchaseFailed", String.valueOf(sku) + ": you have attempted to purchase an item that has already been purchased.");
                Log.i("Prime31", "Attempting to purchase an item that has already been purchased. Aborting to avoid exception. sku: " + sku);
                return;
            }
        }
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.GoogleIABPlugin.3
            @Override // java.lang.Runnable
            public void run() {
                Intent proxyStarter = new Intent(GoogleIABPlugin.this.getActivity(), GoogleIABProxyActivity.class);
                proxyStarter.putExtra("sku", sku);
                proxyStarter.putExtra("developerPayload", developerPayload);
                GoogleIABPlugin.this.getActivity().startActivity(proxyStarter);
            }
        });
    }

    public void consumeProduct(String sku) {
        IABConstants.logEntering(getClass().getSimpleName(), "consumeProduct", sku);
        if (this.helper == null) {
            Log.i("Prime31", "The billing service is not running");
            return;
        }
        if (!this._hasQueriedInventory) {
            Log.w("Prime31", "You have not queried your inventory yet so the plugin does not have the required information to protect you from coding errors.");
        }
        final Purchase p = getPurchasedProductForSku(sku);
        if (p == null) {
            Log.i("Prime31", "Attempting to consume an item that has not been purchased. Aborting to avoid exception. sku: " + sku);
            UnitySendMessage("GoogleIABManager", "consumePurchaseFailed", String.valueOf(sku) + ": you cannot consume a project that has not been purchased or if you have not first queried your inventory to retreive the purchases.");
            return;
        }
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.GoogleIABPlugin.4
            @Override // java.lang.Runnable
            public void run() {
                GoogleIABPlugin.this.helper.consumeAsync(p, GoogleIABPlugin.this);
            }
        });
    }

    public void consumeProducts(String[] skus) {
        IABConstants.logEntering(getClass().getSimpleName(), "consumeProducts", (Object[]) skus);
        if (this.helper == null) {
            Log.i("Prime31", "The billing service is not running");
        } else if (this._purchases == null || this._purchases.size() == 0) {
            Log.e("Prime31", "there are no purchases available to consume");
        } else {
            final List<Purchase> confirmedPurchases = new ArrayList<>();
            for (String sku : skus) {
                Purchase p = getPurchasedProductForSku(sku);
                if (p != null) {
                    confirmedPurchases.add(p);
                }
            }
            if (confirmedPurchases.size() != skus.length) {
                Log.i("Prime31", "Attempting to consume " + skus.length + " item(s) but only " + confirmedPurchases.size() + " item(s) were found to be purchased. Aborting.");
            } else {
                getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.GoogleIABPlugin.5
                    @Override // java.lang.Runnable
                    public void run() {
                        GoogleIABPlugin.this.helper.consumeAsync(confirmedPurchases, GoogleIABPlugin.this);
                    }
                });
            }
        }
    }

    @Override // com.prime31.util.IabHelper.QueryInventoryFinishedListener
    public void onQueryInventoryFinished(IabResult result, Inventory inv) {
        if (result.isSuccess()) {
            this._hasQueriedInventory = true;
            this._purchases = inv.getAllPurchases();
            UnitySendMessage("GoogleIABManager", "queryInventorySucceeded", inv.getAllSkusAndPurchasesAsJson());
            return;
        }
        UnitySendMessage("GoogleIABManager", "queryInventoryFailed", result.getMessage());
    }

    @Override // com.prime31.util.IabHelper.OnIabPurchaseFinishedListener
    public void onIabPurchaseCompleteAwaitingVerification(String purchaseData, String signature) {
        try {
            JSONObject json = new JSONObject();
            json.put("purchaseData", purchaseData);
            json.put("signature", signature);
            UnitySendMessage("GoogleIABManager", "purchaseCompleteAwaitingVerification", json.toString());
        } catch (JSONException e) {
            Log.i("Prime31", "failed to create JSON packet: " + e.getMessage());
        }
    }

    @Override // com.prime31.util.IabHelper.OnIabPurchaseFinishedListener
    public void onIabPurchaseFinished(IabResult result, Purchase info) {
        if (result.isSuccess()) {
            this._purchases.add(info);
            UnitySendMessage("GoogleIABManager", "purchaseSucceeded", info.toJson());
            return;
        }
        UnitySendMessage("GoogleIABManager", "purchaseFailed", result.getMessage());
    }

    @Override // com.prime31.util.IabHelper.OnConsumeFinishedListener
    public void onConsumeFinished(Purchase purchase, IabResult result) {
        if (result.isSuccess()) {
            this._purchases.remove(purchase);
            UnitySendMessage("GoogleIABManager", "consumePurchaseSucceeded", purchase.toJson());
            return;
        }
        String res = String.valueOf(purchase.getSku()) + ": " + result.getMessage();
        UnitySendMessage("GoogleIABManager", "consumePurchaseFailed", res);
    }

    @Override // com.prime31.util.IabHelper.OnConsumeMultiFinishedListener
    public void onConsumeMultiFinished(List<Purchase> purchases, List<IabResult> results) {
        for (int i = 0; i < results.size(); i++) {
            IabResult result = results.get(i);
            Purchase purchase = purchases.get(i);
            if (result.isSuccess()) {
                this._purchases.remove(purchase);
                UnitySendMessage("GoogleIABManager", "consumePurchaseSucceeded", purchase.toJson());
            } else {
                String res = String.valueOf(purchase.getSku()) + ": " + result.getMessage();
                UnitySendMessage("GoogleIABManager", "consumePurchaseFailed", res);
            }
        }
    }
}
