package com.prime31;

import android.app.Activity;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Log;
import com.flurry.android.Constants;
import com.urbanairship.analytics.EventDataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class EtceteraProxyActivity extends Activity {
    public static final String PROXY_ALBUM = "album";
    public static final String PROXY_CAMERA = "camera";
    public static final String PROXY_VIDEO = "video";
    private static String _destinationFilePath;
    private static String _type;
    private final int RESULT_CAMERA = 111;
    private final int RESULT_ALBUM = 222;
    private final int RESULT_VIDEO = 333;

    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        _type = getIntent().getExtras().getString(EventDataManager.Events.COLUMN_NAME_TYPE);
        Log.i("Prime31-Proxy", "proxy received action: " + _type);
        if (_type.equals(PROXY_ALBUM)) {
            Intent intent = new Intent();
            intent.setType("image/*");
            intent.setAction("android.intent.action.GET_CONTENT");
            startActivityForResult(Intent.createChooser(intent, "Select Picture"), 222);
        } else if (_type.equals(PROXY_CAMERA)) {
            Intent intent2 = new Intent("android.media.action.IMAGE_CAPTURE");
            if (hasImageCaptureBug()) {
                intent2.putExtra("output", Uri.fromFile(new File("/sdcard/tmp")));
            } else {
                intent2.putExtra("output", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            }
            startActivityForResult(intent2, 111);
        } else if (_type.equals(PROXY_VIDEO)) {
            _destinationFilePath = getIntent().getExtras().getString("path");
            startActivityForResult(new Intent("android.media.action.VIDEO_CAPTURE"), 333);
        }
    }

    public boolean hasImageCaptureBug() {
        return true;
    }

    public String getPath(Uri uri) {
        if (uri == null) {
            return null;
        }
        String[] projection = {"_data"};
        Cursor cursor = managedQuery(uri, projection, null, null, null);
        if (cursor != null) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(column_index);
        }
        return null;
    }

    @Override // android.app.Activity
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
        } catch (Exception e) {
            Log.e("Prime31-Proxy", "fatal error retrieving image: " + e.getMessage());
            if (requestCode == 222) {
                EtceteraPlugin.instance().photoAlbumItemChosen(null);
            } else if (requestCode == 111) {
                EtceteraPlugin.instance().cameraPhotoTaken(null);
            } else if (requestCode == 333) {
                EtceteraPlugin.instance().videoTaken(null);
            }
        }
        if (requestCode == 222) {
            Log.i("Prime31-Proxy", "processing ALBUM result");
            handleAlbum(resultCode, data);
        } else if (requestCode == 111) {
            Log.i("Prime31-Proxy", "processing CAMERA result");
            handleCamera(resultCode, data);
        } else {
            if (requestCode == 333) {
                Log.i("Prime31-Proxy", "processing VIDEO result");
                handleVideo(resultCode, data);
            }
            finish();
        }
        finish();
    }

    private void handleCamera(int resultCode, Intent data) {
        Uri uri;
        Log.i("Prime31-Proxy", "camera completed. going to try to find the image after checking result");
        if (resultCode == -1) {
            if (hasImageCaptureBug()) {
                File fi = new File("/sdcard/tmp");
                try {
                    String savedImagePath = MediaStore.Images.Media.insertImage(getContentResolver(), fi.getAbsolutePath(), (String) null, (String) null);
                    uri = Uri.parse(savedImagePath);
                } catch (FileNotFoundException e) {
                    Log.i("Prime31-Proxy", "camera failed to write image to disk location: " + fi.getAbsolutePath());
                } catch (Exception e2) {
                    Log.e("Prime31-Proxy", "error saving image to media store: " + e2.getMessage());
                    Log.e("Prime31-Proxy", "absolute path of file is: " + fi.getAbsolutePath());
                }
                if (uri == null) {
                    Log.i("Prime31-Proxy", "uri is null. could not insert image into MediaStore");
                    try {
                        Uri uri2 = data.getData();
                        Log.i("Prime31-Proxy", "last ditch check for buggy devices. direct uri get returns: " + uri2);
                        EtceteraPlugin.instance().cameraPhotoTaken(getPath(uri2));
                        return;
                    } catch (Exception e3) {
                        Log.e("Prime31-Proxy", "last ditch effor for naughty devices failed: " + e3.getMessage());
                        EtceteraPlugin.instance().cameraPhotoTaken(null);
                        return;
                    }
                }
                EtceteraPlugin.instance().cameraPhotoTaken(getPath(uri));
                return;
            }
            EtceteraPlugin.instance().cameraPhotoTaken(getPath(data.getData()));
            return;
        }
        EtceteraPlugin.instance().cameraPhotoTaken(null);
        Log.i("Prime31-Proxy", "camera failed. resultCode: " + resultCode);
        String cacheDir = getCacheDir().getAbsolutePath();
        String filePath = String.valueOf(cacheDir) + "/someImage.jpg";
        File f = new File(filePath);
        Log.i("Prime31-Proxy", "does the file somehow exist anyway?: " + f.exists());
    }

    private void handleAlbum(int resultCode, Intent data) {
        if (resultCode == -1) {
            Uri selectedImageUri = data.getData();
            Log.i("Prime31-Proxy", "gettng Intends extra data. imageUri: " + selectedImageUri);
            String fileManagerPath = selectedImageUri.getPath();
            String selectedImagePath = getPath(selectedImageUri);
            Log.i("Prime31-Proxy", "selectedImagePath: " + selectedImagePath);
            Log.i("Prime31-Proxy", "fileManagerPath: " + fileManagerPath);
            if (selectedImagePath != null) {
                EtceteraPlugin.instance().photoAlbumItemChosen(selectedImagePath);
                return;
            } else if (fileManagerPath != null) {
                EtceteraPlugin.instance().photoAlbumItemChosen(fileManagerPath);
                return;
            } else {
                EtceteraPlugin.instance().photoAlbumItemChosen(null);
                return;
            }
        }
        EtceteraPlugin.instance().photoAlbumItemChosen(null);
    }

    private void handleVideo(int resultCode, Intent data) {
        if (resultCode == -1) {
            try {
                AssetFileDescriptor videoAsset = getContentResolver().openAssetFileDescriptor(data.getData(), Constants.ALIGN_RIGHT);
                FileInputStream fis = videoAsset.createInputStream();
                File tmpFile = new File(_destinationFilePath);
                FileOutputStream fos = new FileOutputStream(tmpFile);
                byte[] buf = new byte[1024];
                while (true) {
                    int len = fis.read(buf);
                    if (len > 0) {
                        fos.write(buf, 0, len);
                    } else {
                        fis.close();
                        fos.close();
                        Log.i("Prime31", "wrote file to: " + _destinationFilePath);
                        EtceteraPlugin.instance().videoTaken(_destinationFilePath);
                        return;
                    }
                }
            } catch (IOException e) {
                Log.i("Prime31-Proxy", "error saving video: " + e.getMessage());
                EtceteraPlugin.instance().videoTaken(null);
            }
        } else {
            EtceteraPlugin.instance().videoTaken(null);
        }
    }
}
