package com.prime31;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.speech.tts.TextToSpeech;
import android.text.Html;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.EventDataManager;
import com.urbanairship.push.PushManager;
import com.urbanairship.push.PushPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class EtceteraPlugin implements TextToSpeech.OnInitListener, TextToSpeech.OnUtteranceCompletedListener {
    private static EtceteraPlugin _instance;
    public Activity _activity;
    private ProgressDialog _dialog;
    private TextToSpeech _tts;
    private Field _unityPlayerActivityField;
    private Class<?> _unityPlayerClass;
    private Method _unitySendMessageMethod;
    public boolean isAmazonAppStore = false;
    private int _utteranceId = 0;
    private int _desiredWidth = 512;
    private int _desiredHeight = 512;
    private String _desiredFileName = "image.jpg";
    private final String DONT_SHOW_AGAIN_KEY = "RTADontShowAgain";
    private final String LAUNCH_COUNT_KEY = "RTALaunchCount";
    private final String FIRST_LAUNCH_DATE_KEY = "RTAFirstLaunchDate";
    private final String LAST_TIME_ASKED = "RTALastTimeAsked";

    public static EtceteraPlugin instance() {
        if (_instance == null) {
            _instance = new EtceteraPlugin();
        }
        return _instance;
    }

    public EtceteraPlugin() {
        try {
            this._unityPlayerClass = Class.forName("com.unity3d.player.UnityPlayer");
            this._unityPlayerActivityField = this._unityPlayerClass.getField("currentActivity");
            this._unitySendMessageMethod = this._unityPlayerClass.getMethod("UnitySendMessage", String.class, String.class, String.class);
        } catch (ClassNotFoundException e) {
            Log.i("Prime31", "could not find UnityPlayer class: " + e.getMessage());
        } catch (NoSuchFieldException e2) {
            Log.i("Prime31", "could not find currentActivity field: " + e2.getMessage());
        } catch (Exception e3) {
            Log.i("Prime31", "unkown exception occurred locating UnityPlayer.currentActivity: " + e3.getMessage());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public Activity getActivity() {
        if (this._unityPlayerActivityField != null) {
            try {
                return (Activity) this._unityPlayerActivityField.get(this._unityPlayerClass);
            } catch (Exception e) {
                Log.i("Prime31", "error getting currentActivity: " + e.getMessage());
            }
        }
        return this._activity;
    }

    public void UnitySendMessage(String go, String m, String p) {
        if (this._unitySendMessageMethod != null) {
            try {
                this._unitySendMessageMethod.invoke(null, go, m, p);
                return;
            } catch (IllegalAccessException e) {
                Log.i("Prime31", "could not find UnitySendMessage method: " + e.getMessage());
                return;
            } catch (IllegalArgumentException e2) {
                Log.i("Prime31", "could not find UnitySendMessage method: " + e2.getMessage());
                return;
            } catch (InvocationTargetException e3) {
                Log.i("Prime31", "could not find UnitySendMessage method: " + e3.getMessage());
                return;
            }
        }
        Log.i("Prime31", "UnitySendMessage: " + go + ", " + m + ", " + p);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public TextToSpeech tts() {
        if (this._tts == null) {
            this._tts = new TextToSpeech(getActivity(), this);
            this._tts.setOnUtteranceCompletedListener(this);
        }
        return this._tts;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public HashMap<String, String> getTtsUtteranceIdHashMap() {
        HashMap<String, String> map = new HashMap<>();
        map.put("utteranceId", Integer.toString(this._utteranceId));
        this._utteranceId++;
        return map;
    }

    public float getScreenDensity() {
        DisplayMetrics metrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.density;
    }

    public void playMovie(final String path, final int bgColor, final boolean showControls, final int scalingMode, final boolean closeOnTouch) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.1
            @Override // java.lang.Runnable
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putString("path", path);
                bundle.putBoolean("showControls", showControls);
                bundle.putInt("color", bgColor);
                bundle.putInt("scalingMode", scalingMode);
                bundle.putBoolean("closeOnTouch", closeOnTouch);
                Intent newIntent = new Intent(EtceteraPlugin.this.getActivity().getApplicationContext(), P31VideoPlayerActivity.class);
                newIntent.putExtras(bundle);
                EtceteraPlugin.this.getActivity().startActivity(newIntent);
            }
        });
    }

    public void showToast(final String text, final boolean shortDuration) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.2
            @Override // java.lang.Runnable
            public void run() {
                Toast.makeText(EtceteraPlugin.this.getActivity(), text, shortDuration ? 0 : 1).show();
            }
        });
    }

    public void showAlert(final String title, final String message, final String positiveButton, final String negativeButton) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.3
            @Override // java.lang.Runnable
            public void run() {
                AlertDialog.Builder message2 = new AlertDialog.Builder(EtceteraPlugin.this.getActivity()).setTitle(title).setMessage(message);
                String str = positiveButton;
                final String str2 = positiveButton;
                AlertDialog.Builder positiveButton2 = message2.setPositiveButton(str, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.3.1
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog, int whichButton) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "alertButtonClicked", str2);
                    }
                });
                String str3 = negativeButton;
                final String str4 = negativeButton;
                positiveButton2.setNegativeButton(str3, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.3.2
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog, int whichButton) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "alertButtonClicked", str4);
                    }
                }).setOnCancelListener(new DialogInterface.OnCancelListener() { // from class: com.prime31.EtceteraPlugin.3.3
                    @Override // android.content.DialogInterface.OnCancelListener
                    public void onCancel(DialogInterface arg0) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "alertCancelled", "");
                    }
                }).setCancelable(false).show();
            }
        });
    }

    public void showAlertPrompt(final String title, final String message, final String promptHint, final String promptText, final String positiveButton, final String negativeButton) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.4
            @Override // java.lang.Runnable
            public void run() {
                final EditText input = new EditText(EtceteraPlugin.this.getActivity());
                input.setHint(promptHint);
                input.setText(promptText);
                AlertDialog.Builder dialog = new AlertDialog.Builder(EtceteraPlugin.this.getActivity()).setTitle(title).setMessage(message).setView(input).setPositiveButton(positiveButton, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.4.1
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog2, int whichButton) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "promptFinishedWithText", input.getText().toString());
                    }
                }).setOnCancelListener(new DialogInterface.OnCancelListener() { // from class: com.prime31.EtceteraPlugin.4.2
                    @Override // android.content.DialogInterface.OnCancelListener
                    public void onCancel(DialogInterface arg0) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "promptCancelled", "");
                    }
                });
                if (negativeButton.length() > 0) {
                    dialog.setNegativeButton(negativeButton, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.4.3
                        @Override // android.content.DialogInterface.OnClickListener
                        public void onClick(DialogInterface dialog2, int whichButton) {
                            EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "promptCancelled", "");
                        }
                    });
                }
                dialog.setCancelable(false).show();
            }
        });
    }

    public void showAlertPromptWithTwoFields(final String title, final String message, final String promptHintOne, final String promptTextOne, final String promptHintTwo, final String promptTextTwo, final String positiveButton, final String negativeButton) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.5
            @Override // java.lang.Runnable
            public void run() {
                LinearLayout layout = new LinearLayout(EtceteraPlugin.this.getActivity());
                layout.setOrientation(1);
                layout.setLayoutParams(new LinearLayout.LayoutParams(-1, -2));
                final EditText text1 = new EditText(EtceteraPlugin.this.getActivity());
                final EditText text2 = new EditText(EtceteraPlugin.this.getActivity());
                text1.setHint(promptHintOne);
                text1.setText(promptTextOne);
                text2.setHint(promptHintTwo);
                text2.setText(promptTextTwo);
                layout.addView(text1);
                layout.addView(text2);
                new AlertDialog.Builder(EtceteraPlugin.this.getActivity()).setTitle(title).setMessage(message).setView(layout).setPositiveButton(positiveButton, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.5.1
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog, int whichButton) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "promptFinishedWithText", String.valueOf(text1.getText().toString()) + "|||" + text2.getText().toString());
                    }
                }).setNegativeButton(negativeButton, new DialogInterface.OnClickListener() { // from class: com.prime31.EtceteraPlugin.5.2
                    @Override // android.content.DialogInterface.OnClickListener
                    public void onClick(DialogInterface dialog, int whichButton) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "twoFieldPromptCancelled", "");
                    }
                }).setOnCancelListener(new DialogInterface.OnCancelListener() { // from class: com.prime31.EtceteraPlugin.5.3
                    @Override // android.content.DialogInterface.OnCancelListener
                    public void onCancel(DialogInterface arg0) {
                        EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "twoFieldPromptCancelled", "");
                    }
                }).setCancelable(false).show();
            }
        });
    }

    public void showProgressDialog(final String title, final String message) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.6
            @Override // java.lang.Runnable
            public void run() {
                EtceteraPlugin.this._dialog = ProgressDialog.show(EtceteraPlugin.this.getActivity(), title, message, true);
            }
        });
    }

    public void hideProgressDialog() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.7
            @Override // java.lang.Runnable
            public void run() {
                if (EtceteraPlugin.this._dialog != null) {
                    EtceteraPlugin.this._dialog.dismiss();
                    EtceteraPlugin.this._dialog = null;
                }
            }
        });
    }

    public void showWebView(String dialogTitle, final String url) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.8
            @Override // java.lang.Runnable
            public void run() {
                Intent proxyStarter = new Intent(EtceteraPlugin.this.getActivity(), WebViewActivity.class);
                proxyStarter.putExtra("url", url);
                EtceteraPlugin.this.getActivity().startActivity(proxyStarter);
            }
        });
    }

    public void showEmailComposer(final String toAddress, final String subject, final String text, final boolean isHTML, final String attachmentFilePath) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.9
            @Override // java.lang.Runnable
            public void run() {
                Log.i("Prime31", "preparing ACTION_SEND Intent");
                Intent emailIntent = new Intent("android.intent.action.SEND");
                if (isHTML) {
                    emailIntent.setType("text/html");
                    emailIntent.putExtra("android.intent.extra.TEXT", Html.fromHtml(text));
                } else {
                    emailIntent.setType("plain/text");
                    emailIntent.putExtra("android.intent.extra.TEXT", text);
                }
                emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{toAddress});
                emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
                if (attachmentFilePath != null && attachmentFilePath.length() > 0) {
                    File file = new File(attachmentFilePath);
                    Uri attachmentUri = Uri.fromFile(file);
                    emailIntent.putExtra("android.intent.extra.STREAM", attachmentUri);
                    Log.i("prime31", "added attachment to intent");
                }
                Log.i("Prime31", "starting Activity with Intent chooser");
                EtceteraPlugin.this.getActivity().startActivity(Intent.createChooser(emailIntent, "Send mail..."));
            }
        });
    }

    public void showSMSComposer(final String text) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.10
            @Override // java.lang.Runnable
            public void run() {
                try {
                    Intent sendIntent = new Intent("android.intent.action.VIEW");
                    sendIntent.putExtra("sms_body", text);
                    sendIntent.setType("vnd.android-dir/mms-sms");
                    EtceteraPlugin.this.getActivity().startActivity(sendIntent);
                } catch (ActivityNotFoundException e) {
                    Log.e("Prime31", "no SMS actvity found: " + e.getMessage());
                }
            }
        });
    }

    public void promptToTakePhoto(int desiredWidth, int desiredHeight, String name) {
        this._desiredWidth = desiredWidth;
        this._desiredHeight = desiredHeight;
        this._desiredFileName = name;
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.11
            @Override // java.lang.Runnable
            public void run() {
                Intent proxyStarter = new Intent(EtceteraPlugin.this.getActivity(), EtceteraProxyActivity.class);
                proxyStarter.putExtra(EventDataManager.Events.COLUMN_NAME_TYPE, EtceteraProxyActivity.PROXY_CAMERA);
                EtceteraPlugin.this.getActivity().startActivity(proxyStarter);
            }
        });
    }

    public void promptToTakeVideo(String name) {
        if (!name.endsWith("3gp")) {
            if (name.contains(".")) {
                String substring = name.substring(0, name.length() - 3);
                name = String.valueOf(substring) + "3gp";
            } else {
                name = String.valueOf(name) + ".3gp";
            }
        }
        this._desiredFileName = name;
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.12
            @Override // java.lang.Runnable
            public void run() {
                Intent proxyStarter = new Intent(EtceteraPlugin.this.getActivity(), EtceteraProxyActivity.class);
                proxyStarter.putExtra(EventDataManager.Events.COLUMN_NAME_TYPE, EtceteraProxyActivity.PROXY_VIDEO);
                String cacheDir = EtceteraPlugin.this.getActivity().getCacheDir().getAbsolutePath();
                String destPath = String.valueOf(cacheDir) + "/" + EtceteraPlugin.this._desiredFileName;
                proxyStarter.putExtra("path", destPath);
                EtceteraPlugin.this.getActivity().startActivity(proxyStarter);
            }
        });
    }

    public void promptForPictureFromAlbum(int desiredWidth, int desiredHeight, String name) {
        this._desiredWidth = desiredWidth;
        this._desiredHeight = desiredHeight;
        this._desiredFileName = name;
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.13
            @Override // java.lang.Runnable
            public void run() {
                Intent proxyStarter = new Intent(EtceteraPlugin.this.getActivity(), EtceteraProxyActivity.class);
                proxyStarter.putExtra(EventDataManager.Events.COLUMN_NAME_TYPE, EtceteraProxyActivity.PROXY_ALBUM);
                EtceteraPlugin.this.getActivity().startActivity(proxyStarter);
            }
        });
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
        } finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private void resizeImageAtPath(String sourcePath, String destPath) throws FileNotFoundException {
        Bitmap bitmapOrg = BitmapFactory.decodeFile(sourcePath);
        Log.i("Prime31", "found image: " + bitmapOrg);
        if (bitmapOrg == null) {
            File source = new File(sourcePath);
            File dest = new File(destPath);
            try {
                copyFile(source, dest);
            } catch (IOException e) {
                Log.e("Prime31", "failed to perform fallback copy of file: " + e.getMessage());
                throw new FileNotFoundException();
            }
        }
        Log.i("Prime31", "resizing image at path: " + sourcePath);
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        if (this._desiredWidth == 0 && this._desiredHeight == 0) {
            this._desiredWidth = width;
            this._desiredHeight = height;
        }
        float scaleWidth = this._desiredWidth / width;
        float scaleHeight = this._desiredHeight / height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap(bitmapOrg, 0, 0, width, height, matrix, true);
        FileOutputStream out = new FileOutputStream(destPath);
        resizedBitmap.compress(Bitmap.CompressFormat.JPEG, 70, out);
    }

    public void scaleImageAtPath(String sourcePath, float scale) {
        FileOutputStream out;
        Bitmap bitmapOrg = BitmapFactory.decodeFile(sourcePath);
        if (bitmapOrg == null) {
            Log.e("Prime31", "could not find image at path: " + sourcePath);
            return;
        }
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizedBitmap = Bitmap.createBitmap(bitmapOrg, 0, 0, width, height, matrix, true);
        try {
            out = new FileOutputStream(sourcePath);
        } catch (FileNotFoundException e) {
            e = e;
        }
        try {
            resizedBitmap.compress(Bitmap.CompressFormat.JPEG, 70, out);
        } catch (FileNotFoundException e2) {
            e = e2;
            Log.i("Prime31", "error saving image to disk: " + e.getMessage());
        }
    }

    public boolean saveImageToGallery(String imagePath, String title) {
        ContentValues v = new ContentValues();
        v.put("title", title);
        v.put("date_added", Long.valueOf(new Date().getTime()));
        v.put("datetaken", Long.valueOf(new Date().getTime()));
        v.put("date_modified", Long.valueOf(new Date().getTime()));
        v.put("mime_type", "image/png");
        try {
            File f = new File(imagePath);
            File parent = f.getParentFile();
            String path = parent.toString().toLowerCase();
            String name = parent.getName().toLowerCase();
            v.put("bucket_id", Integer.valueOf(path.hashCode()));
            v.put("bucket_display_name", name);
            v.put("_size", Long.valueOf(f.length()));
            v.put("_data", imagePath);
            ContentResolver c = getActivity().getContentResolver();
            Uri uri = c.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, v);
            P31MediaScanner client = new P31MediaScanner(f);
            MediaScannerConnection scanner = new MediaScannerConnection(getActivity(), client);
            client.setScanner(scanner);
            scanner.connect();
            Log.i("Prime31", " saved to gallery with uri: " + uri);
            return true;
        } catch (Exception e) {
            Log.i("Prime31", "saveImageToGallery failed: " + e.getMessage());
            return false;
        }
    }

    public void photoAlbumItemChosen(String path) {
        if (path == null) {
            UnitySendMessage("EtceteraAndroidManager", "albumChooserCancelled", "");
            return;
        }
        Log.i("Prime31", "going to resize the file at path: " + path);
        String cacheDir = getActivity().getCacheDir().getAbsolutePath();
        String destPath = String.valueOf(cacheDir) + "/" + this._desiredFileName;
        try {
            resizeImageAtPath(path, destPath);
            UnitySendMessage("EtceteraAndroidManager", "albumChooserSucceeded", destPath);
        } catch (FileNotFoundException e) {
            Log.i("Prime31", "file could not be found to resize it: " + path);
            UnitySendMessage("EtceteraAndroidManager", "albumChooserCancelled", "");
        }
    }

    public void cameraPhotoTaken(String path) {
        if (path == null) {
            UnitySendMessage("EtceteraAndroidManager", "photoChooserCancelled", "");
            return;
        }
        Log.i("Prime31", "going to resize the file at path: " + path);
        String cacheDir = getActivity().getCacheDir().getAbsolutePath();
        String destPath = String.valueOf(cacheDir) + "/" + this._desiredFileName;
        try {
            resizeImageAtPath(path, destPath);
            UnitySendMessage("EtceteraAndroidManager", "photoChooserSucceeded", destPath);
        } catch (FileNotFoundException e) {
            Log.i("Prime31", "file could not be found to resize it: " + path);
            UnitySendMessage("EtceteraAndroidManager", "photoChooserCancelled", "");
        }
    }

    public void videoTaken(String path) {
        if (path == null) {
            UnitySendMessage("EtceteraAndroidManager", "videoRecordingCancelled", "");
        } else {
            UnitySendMessage("EtceteraAndroidManager", "videoRecordingSucceeded", path);
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public class P31MediaScanner implements MediaScannerConnection.MediaScannerConnectionClient {
        private File _file;
        private MediaScannerConnection _scanner;
        private boolean _scannerConnected;

        public P31MediaScanner(File f) {
            this._file = f;
        }

        public void setScanner(MediaScannerConnection scanner) {
            Log.i("Prime31", "scanner set");
            this._scanner = scanner;
            if (this._scannerConnected) {
                this._scanner.scanFile(this._file.getAbsolutePath(), "image/png");
            }
        }

        @Override // android.media.MediaScannerConnection.MediaScannerConnectionClient
        public void onMediaScannerConnected() {
            Log.i("Prime31", "scanner connected");
            if (this._scanner != null) {
                this._scanner.scanFile(this._file.getAbsolutePath(), "image/png");
            }
            this._scannerConnected = true;
        }

        @Override // android.media.MediaScannerConnection.OnScanCompletedListener
        public void onScanCompleted(String path, Uri arg1) {
            Log.i("Prime31", "scanner finished for file: " + path);
        }
    }

    public void initTTS() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.14
            @Override // java.lang.Runnable
            public void run() {
                EtceteraPlugin.this.tts();
            }
        });
    }

    public void teardownTTS() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.15
            @Override // java.lang.Runnable
            public void run() {
                if (EtceteraPlugin.this._tts != null) {
                    EtceteraPlugin.this._tts.stop();
                    EtceteraPlugin.this._tts.shutdown();
                    EtceteraPlugin.this._tts = null;
                }
            }
        });
    }

    public void speak(final String text, final int queueMode) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.16
            @Override // java.lang.Runnable
            public void run() {
                HashMap<String, String> map = EtceteraPlugin.this.getTtsUtteranceIdHashMap();
                int status = EtceteraPlugin.this.tts().speak(text, queueMode, map);
                if (status == -1) {
                    EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "ttsFailedToSpeak", "");
                }
            }
        });
    }

    public void stop() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.17
            @Override // java.lang.Runnable
            public void run() {
                int status = EtceteraPlugin.this.tts().stop();
                if (status == -1) {
                    Log.i("Prime31", "tts failed to stop");
                }
            }
        });
    }

    public void playSilence(final long durationInMs, final int queueMode) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.18
            @Override // java.lang.Runnable
            public void run() {
                HashMap<String, String> map = EtceteraPlugin.this.getTtsUtteranceIdHashMap();
                int status = EtceteraPlugin.this.tts().playSilence(durationInMs, queueMode, map);
                if (status == -1) {
                    Log.i("Prime31", "tts failed to play silence");
                }
            }
        });
    }

    public void setPitch(final float pitch) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.19
            @Override // java.lang.Runnable
            public void run() {
                int status = EtceteraPlugin.this.tts().setPitch(pitch);
                if (status == -1) {
                    Log.i("Prime31", "tts failed to set pitch");
                }
            }
        });
    }

    public void setSpeechRate(final float rate) {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.20
            @Override // java.lang.Runnable
            public void run() {
                int status = EtceteraPlugin.this.tts().setSpeechRate(rate);
                if (status == -1) {
                    Log.i("Prime31", "tts failed to set speech rate");
                }
            }
        });
    }

    @Override // android.speech.tts.TextToSpeech.OnInitListener
    public void onInit(int status) {
        if (status == 0) {
            UnitySendMessage("EtceteraAndroidManager", "ttsInitialized", "1");
        } else {
            UnitySendMessage("EtceteraAndroidManager", "ttsInitialized", "0");
        }
    }

    @Override // android.speech.tts.TextToSpeech.OnUtteranceCompletedListener
    public void onUtteranceCompleted(String utteranceId) {
        UnitySendMessage("EtceteraAndroidManager", "ttsUtteranceCompleted", utteranceId);
    }

    public void askForReview(int launchesUntilPrompt, int hoursUntilFirstPrompt, int hoursBetweenPrompts, String title, String message, String appPackageName) {
        SharedPreferences prefs = getActivity().getSharedPreferences("RTA", 0);
        if (!prefs.getBoolean("RTADontShowAgain", false)) {
            SharedPreferences.Editor editor = prefs.edit();
            long launchCount = prefs.getLong("RTALaunchCount", 0L) + 1;
            editor.putLong("RTALaunchCount", launchCount);
            Long firstLaunchDate = Long.valueOf(prefs.getLong("RTAFirstLaunchDate", 0L));
            if (firstLaunchDate.longValue() == 0) {
                Log.i("Prime31", "first launch date not set in prefs. setting it now");
                firstLaunchDate = Long.valueOf(System.currentTimeMillis());
                editor.putLong("RTAFirstLaunchDate", firstLaunchDate.longValue());
            }
            if (launchCount >= launchesUntilPrompt) {
                Log.i("Prime31", "launch count > launchesUntilPrompt. checking to see if first launch was greater than hoursUntilPrompt");
                if (System.currentTimeMillis() >= firstLaunchDate.longValue() + (hoursUntilFirstPrompt * 60 * 60 * 1000)) {
                    Log.i("Prime31", "hoursUntilFirstPrompt have expired so we are clear to proceed");
                    Long lastPromptDate = Long.valueOf(prefs.getLong("RTALastTimeAsked", 0L));
                    if (lastPromptDate.longValue() == 0 || System.currentTimeMillis() >= lastPromptDate.longValue() + (hoursBetweenPrompts * 60 * 60 * 1000)) {
                        Log.i("Prime31", "lastPromptDate is either 0 or enough time has elapsed to prompt again");
                        editor.putLong("RTALastTimeAsked", System.currentTimeMillis());
                        askForReviewNow(title, message, appPackageName);
                    }
                }
            }
            editor.commit();
        }
    }

    public void askForReviewNow(final String title, final String message, final String appPackageName) {
        final SharedPreferences prefs = getActivity().getSharedPreferences("RTA", 0);
        if (!prefs.getBoolean("RTADontShowAgain", false)) {
            getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.21
                @Override // java.lang.Runnable
                public void run() {
                    final Dialog dialog = new Dialog(EtceteraPlugin.this.getActivity());
                    dialog.setTitle(title);
                    LinearLayout ll = new LinearLayout(EtceteraPlugin.this.getActivity());
                    ll.setPadding(5, 0, 5, 0);
                    ll.setOrientation(1);
                    TextView tv = new TextView(EtceteraPlugin.this.getActivity());
                    tv.setIncludeFontPadding(true);
                    tv.setText(message);
                    tv.setWidth(500);
                    ll.addView(tv);
                    View v = new View(EtceteraPlugin.this.getActivity());
                    v.setLayoutParams(new ViewGroup.LayoutParams(10, 10));
                    ll.addView(v);
                    Button b1 = new Button(EtceteraPlugin.this.getActivity());
                    b1.setText("Yes, rate it!");
                    final SharedPreferences sharedPreferences = prefs;
                    final String str = appPackageName;
                    b1.setOnClickListener(new View.OnClickListener() { // from class: com.prime31.EtceteraPlugin.21.1
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v2) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putBoolean("RTADontShowAgain", true);
                            editor.commit();
                            EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "askForReviewWillOpenMarket", "");
                            String prefix = "market://";
                            if (Build.VERSION.SDK_INT >= 11) {
                                Log.i("Prime31", "we have Honeycomb so redirect to the webpage instead of the Market");
                                prefix = "https://market.android.com/";
                            }
                            if (!EtceteraPlugin.this.isAmazonAppStore) {
                                EtceteraPlugin.this.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(String.valueOf(prefix) + "details?id=" + str)));
                            } else {
                                EtceteraPlugin.this.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(String.valueOf("amzn://apps/android?p=") + str)));
                            }
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b1);
                    Button b2 = new Button(EtceteraPlugin.this.getActivity());
                    b2.setText("Remind me later");
                    b2.setOnClickListener(new View.OnClickListener() { // from class: com.prime31.EtceteraPlugin.21.2
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v2) {
                            EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "askForReviewRemindMeLater", "");
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b2);
                    Button b3 = new Button(EtceteraPlugin.this.getActivity());
                    b3.setText("Don't ask again");
                    final SharedPreferences sharedPreferences2 = prefs;
                    b3.setOnClickListener(new View.OnClickListener() { // from class: com.prime31.EtceteraPlugin.21.3
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v2) {
                            EtceteraPlugin.this.UnitySendMessage("EtceteraAndroidManager", "askForReviewDontAskAgain", "");
                            SharedPreferences.Editor editor = sharedPreferences2.edit();
                            editor.putBoolean("RTADontShowAgain", true);
                            editor.commit();
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b3);
                    dialog.setContentView(ll);
                    dialog.show();
                    int screenWidth = EtceteraPlugin.this.getActivity().getWindowManager().getDefaultDisplay().getWidth();
                    float width = screenWidth * 0.8f;
                    if (Build.VERSION.SDK_INT >= 11) {
                        width = 450.0f;
                    }
                    WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                    lp.copyFrom(dialog.getWindow().getAttributes());
                    lp.width = (int) width;
                    dialog.getWindow().setAttributes(lp);
                }
            });
        }
    }

    public void resetAskForReview() {
        SharedPreferences prefs = getActivity().getSharedPreferences("RTA", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.commit();
    }

    public void urbanAirshipActivityStarted() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.22
            @Override // java.lang.Runnable
            public void run() {
                UAirship.shared().getAnalytics().activityStarted(EtceteraPlugin.this.getActivity());
            }
        });
    }

    public void urbanAirshipActivityStopped() {
        getActivity().runOnUiThread(new Runnable() { // from class: com.prime31.EtceteraPlugin.23
            @Override // java.lang.Runnable
            public void run() {
                UAirship.shared().getAnalytics().activityStopped(EtceteraPlugin.this.getActivity());
            }
        });
    }

    public void urbanAirshipEnablePush() {
        PushManager.enablePush();
    }

    public void urbanAirshipDisablePush() {
        PushManager.disablePush();
    }

    public String urbanAirshipGetAPID() {
        PushPreferences prefs = PushManager.shared().getPreferences();
        return prefs.getPushId();
    }
}
