package com.flurry.org.codehaus.jackson.util;

import com.flurry.org.codehaus.jackson.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class VersionUtil {
    public static final String VERSION_FILE = "VERSION.txt";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");

    public static Version versionFor(Class<?> cls) {
        Version version = null;
        try {
            InputStream in = cls.getResourceAsStream(VERSION_FILE);
            if (in != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                version = parseVersion(br.readLine());
                try {
                    in.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } catch (IOException e2) {
        }
        return version == null ? Version.unknownVersion() : version;
    }

    public static Version parseVersion(String versionStr) {
        if (versionStr == null) {
            return null;
        }
        String versionStr2 = versionStr.trim();
        if (versionStr2.length() != 0) {
            String[] parts = VERSION_SEPARATOR.split(versionStr2);
            if (parts.length >= 2) {
                int major = parseVersionPart(parts[0]);
                int minor = parseVersionPart(parts[1]);
                int patch = parts.length > 2 ? parseVersionPart(parts[2]) : 0;
                String snapshot = parts.length > 3 ? parts[3] : null;
                return new Version(major, minor, patch, snapshot);
            }
            return null;
        }
        return null;
    }

    protected static int parseVersionPart(String partStr) {
        String partStr2 = partStr.toString();
        int len = partStr2.length();
        int number = 0;
        for (int i = 0; i < len; i++) {
            char c = partStr2.charAt(i);
            if (c > '9' || c < '0') {
                break;
            }
            number = (number * 10) + (c - '0');
        }
        return number;
    }
}
