package com.flurry.org.codehaus.jackson.util;

import com.flurry.org.codehaus.jackson.JsonGenerationException;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.PrettyPrinter;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class MinimalPrettyPrinter implements PrettyPrinter {
    public static final String DEFAULT_ROOT_VALUE_SEPARATOR = " ";
    protected String _rootValueSeparator;

    public MinimalPrettyPrinter() {
        this(DEFAULT_ROOT_VALUE_SEPARATOR);
    }

    public MinimalPrettyPrinter(String rootValueSeparator) {
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        this._rootValueSeparator = rootValueSeparator;
    }

    public void setRootValueSeparator(String sep) {
        this._rootValueSeparator = sep;
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeRootValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        if (this._rootValueSeparator != null) {
            jg.writeRaw(this._rootValueSeparator);
        }
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeStartObject(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw('{');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void beforeObjectEntries(JsonGenerator jg) throws IOException, JsonGenerationException {
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(':');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(',');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException, JsonGenerationException {
        jg.writeRaw('}');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeStartArray(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw('[');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void beforeArrayValues(JsonGenerator jg) throws IOException, JsonGenerationException {
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeArrayValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(',');
    }

    @Override // com.flurry.org.codehaus.jackson.PrettyPrinter
    public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException, JsonGenerationException {
        jg.writeRaw(']');
    }
}
