package com.flurry.org.codehaus.jackson.util;

import com.flurry.org.codehaus.jackson.Base64Variant;
import com.flurry.org.codehaus.jackson.FormatSchema;
import com.flurry.org.codehaus.jackson.JsonGenerationException;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonStreamContext;
import com.flurry.org.codehaus.jackson.ObjectCodec;
import com.flurry.org.codehaus.jackson.SerializableString;
import com.flurry.org.codehaus.jackson.Version;
import com.flurry.org.codehaus.jackson.io.SerializedString;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class JsonGeneratorDelegate extends JsonGenerator {
    protected JsonGenerator delegate;

    public JsonGeneratorDelegate(JsonGenerator d) {
        this.delegate = d;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator, java.io.Closeable, java.lang.AutoCloseable
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void copyCurrentEvent(JsonParser jp) throws IOException, JsonProcessingException {
        this.delegate.copyCurrentEvent(jp);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void copyCurrentStructure(JsonParser jp) throws IOException, JsonProcessingException {
        this.delegate.copyCurrentStructure(jp);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public JsonGenerator disable(JsonGenerator.Feature f) {
        return this.delegate.disable(f);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public JsonGenerator enable(JsonGenerator.Feature f) {
        return this.delegate.enable(f);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public ObjectCodec getCodec() {
        return this.delegate.getCodec();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public JsonStreamContext getOutputContext() {
        return this.delegate.getOutputContext();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void setSchema(FormatSchema schema) {
        this.delegate.setSchema(schema);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public boolean canUseSchema(FormatSchema schema) {
        return this.delegate.canUseSchema(schema);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator, com.flurry.org.codehaus.jackson.Versioned
    public Version version() {
        return this.delegate.version();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public Object getOutputTarget() {
        return this.delegate.getOutputTarget();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public boolean isEnabled(JsonGenerator.Feature f) {
        return this.delegate.isEnabled(f);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public JsonGenerator setCodec(ObjectCodec oc) {
        this.delegate.setCodec(oc);
        return this;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public JsonGenerator useDefaultPrettyPrinter() {
        this.delegate.useDefaultPrettyPrinter();
        return this;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeBinary(b64variant, data, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this.delegate.writeBoolean(state);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeEndArray() throws IOException, JsonGenerationException {
        this.delegate.writeEndArray();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeEndObject() throws IOException, JsonGenerationException {
        this.delegate.writeEndObject();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        this.delegate.writeFieldName(name);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeFieldName(SerializedString name) throws IOException, JsonGenerationException {
        this.delegate.writeFieldName(name);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        this.delegate.writeFieldName(name);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNull() throws IOException, JsonGenerationException {
        this.delegate.writeNull();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(int v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(long v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(double v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(float v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(BigDecimal v) throws IOException, JsonGenerationException {
        this.delegate.writeNumber(v);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.delegate.writeNumber(encodedValue);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeObject(Object pojo) throws IOException, JsonProcessingException {
        this.delegate.writeObject(pojo);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this.delegate.writeRaw(text);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeRaw(text, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeRaw(text, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.delegate.writeRaw(c);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this.delegate.writeRawValue(text);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRawValue(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeRawValue(text, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRawValue(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeRawValue(text, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeStartArray() throws IOException, JsonGenerationException {
        this.delegate.writeStartArray();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeStartObject() throws IOException, JsonGenerationException {
        this.delegate.writeStartObject();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeString(String text) throws IOException, JsonGenerationException {
        this.delegate.writeString(text);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.delegate.writeString(text, offset, len);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeString(SerializableString text) throws IOException, JsonGenerationException {
        this.delegate.writeString(text);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.delegate.writeRawUTF8String(text, offset, length);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.delegate.writeUTF8String(text, offset, length);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonGenerator
    public void writeTree(JsonNode rootNode) throws IOException, JsonProcessingException {
        this.delegate.writeTree(rootNode);
    }
}
