package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.map.TypeSerializer;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public abstract class ValueNode extends BaseJsonNode {
    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.JsonNode
    public abstract JsonToken asToken();

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean isValueNode() {
        return true;
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.map.JsonSerializableWithType
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(this, jg);
        serialize(jg, provider);
        typeSer.writeTypeSuffixForScalar(this, jg);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public String toString() {
        return asText();
    }
}
