package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.apache.avro.file.DataFileConstants;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public final class NullNode extends ValueNode {
    public static final NullNode instance = new NullNode();

    private NullNode() {
    }

    public static NullNode getInstance() {
        return instance;
    }

    @Override // com.flurry.org.codehaus.jackson.node.ValueNode, com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.JsonNode
    public JsonToken asToken() {
        return JsonToken.VALUE_NULL;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean isNull() {
        return true;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public String asText() {
        return DataFileConstants.NULL_CODEC;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public int asInt(int defaultValue) {
        return 0;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public long asLong(long defaultValue) {
        return 0L;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public double asDouble(double defaultValue) {
        return 0.0d;
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.map.JsonSerializable
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNull();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean equals(Object o) {
        return o == this;
    }
}
