package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.map.TypeSerializer;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public final class MissingNode extends BaseJsonNode {
    private static final MissingNode instance = new MissingNode();

    private MissingNode() {
    }

    public static MissingNode getInstance() {
        return instance;
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.JsonNode
    public JsonToken asToken() {
        return JsonToken.NOT_AVAILABLE;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean isMissingNode() {
        return true;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public String asText() {
        return "";
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public int asInt(int defaultValue) {
        return 0;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public long asLong(long defaultValue) {
        return 0L;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public double asDouble(double defaultValue) {
        return 0.0d;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public JsonNode path(String fieldName) {
        return this;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public JsonNode path(int index) {
        return this;
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.map.JsonSerializable
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNull();
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.map.JsonSerializableWithType
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        jg.writeNull();
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean equals(Object o) {
        return o == this;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public String toString() {
        return "";
    }
}
