package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public final class BooleanNode extends ValueNode {
    public static final BooleanNode TRUE = new BooleanNode();
    public static final BooleanNode FALSE = new BooleanNode();

    private BooleanNode() {
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override // com.flurry.org.codehaus.jackson.node.ValueNode, com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.JsonNode
    public JsonToken asToken() {
        return this == TRUE ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean isBoolean() {
        return true;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean getBooleanValue() {
        return this == TRUE;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public String asText() {
        return this == TRUE ? "true" : "false";
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean asBoolean() {
        return this == TRUE;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean asBoolean(boolean defaultValue) {
        return this == TRUE;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public int asInt(int defaultValue) {
        return this == TRUE ? 1 : 0;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public long asLong(long defaultValue) {
        return this == TRUE ? 1L : 0L;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public double asDouble(double defaultValue) {
        return this == TRUE ? 1.0d : 0.0d;
    }

    @Override // com.flurry.org.codehaus.jackson.node.BaseJsonNode, com.flurry.org.codehaus.jackson.map.JsonSerializable
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeBoolean(this == TRUE);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonNode
    public boolean equals(Object o) {
        return o == this;
    }
}
