package com.flurry.org.codehaus.jackson.map.ser;

import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import java.lang.reflect.Method;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class AnyGetterWriter {
    protected final Method _anyGetter;
    protected final com.flurry.org.codehaus.jackson.map.ser.std.MapSerializer _serializer;

    public AnyGetterWriter(AnnotatedMethod anyGetter, com.flurry.org.codehaus.jackson.map.ser.std.MapSerializer serializer) {
        this._anyGetter = anyGetter.getAnnotated();
        this._serializer = serializer;
    }

    public void getAndSerialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        Object value = this._anyGetter.invoke(bean, new Object[0]);
        if (value != null) {
            if (!(value instanceof Map)) {
                throw new JsonMappingException("Value returned by 'any-getter' (" + this._anyGetter.getName() + "()) not java.util.Map but " + value.getClass().getName());
            }
            this._serializer.serializeFields((Map) value, jgen, provider);
        }
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        this._serializer.resolve(provider);
    }
}
