package com.flurry.org.codehaus.jackson.map.introspect;

import com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class POJOPropertyBuilder extends BeanPropertyDefinition implements Comparable<POJOPropertyBuilder> {
    protected Node<AnnotatedParameter> _ctorParameters;
    protected Node<AnnotatedField> _fields;
    protected Node<AnnotatedMethod> _getters;
    protected final String _internalName;
    protected final String _name;
    protected Node<AnnotatedMethod> _setters;

    public POJOPropertyBuilder(String internalName) {
        this._internalName = internalName;
        this._name = internalName;
    }

    public POJOPropertyBuilder(POJOPropertyBuilder src, String newName) {
        this._internalName = src._internalName;
        this._name = newName;
        this._fields = src._fields;
        this._ctorParameters = src._ctorParameters;
        this._getters = src._getters;
        this._setters = src._setters;
    }

    public POJOPropertyBuilder withName(String newName) {
        return new POJOPropertyBuilder(this, newName);
    }

    @Override // java.lang.Comparable
    public int compareTo(POJOPropertyBuilder other) {
        if (this._ctorParameters != null) {
            if (other._ctorParameters == null) {
                return -1;
            }
        } else if (other._ctorParameters != null) {
            return 1;
        }
        return getName().compareTo(other.getName());
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition, com.flurry.org.codehaus.jackson.map.util.Named
    public String getName() {
        return this._name;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public String getInternalName() {
        return this._internalName;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public boolean hasField() {
        return this._fields != null;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedMember getAccessor() {
        AnnotatedMember m = getGetter();
        if (m == null) {
            return getField();
        }
        return m;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedMember getMutator() {
        AnnotatedMember m = getConstructorParameter();
        if (m == null) {
            AnnotatedMember m2 = getSetter();
            if (m2 == null) {
                return getField();
            }
            return m2;
        }
        return m;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public boolean couldSerialize() {
        return (this._getters == null && this._fields == null) ? false : true;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedMethod getGetter() {
        if (this._getters == null) {
            return null;
        }
        AnnotatedMethod getter = this._getters.value;
        for (Node node = this._getters.next; node != null; node = node.next) {
            AnnotatedMethod nextGetter = (AnnotatedMethod) node.value;
            Class<?> getterClass = getter.getDeclaringClass();
            Class<?> nextClass = nextGetter.getDeclaringClass();
            if (getterClass != nextClass) {
                if (getterClass.isAssignableFrom(nextClass)) {
                    getter = nextGetter;
                } else if (!nextClass.isAssignableFrom(getterClass)) {
                }
            }
            throw new IllegalArgumentException("Conflicting getter definitions for property \"" + getName() + "\": " + getter.getFullName() + " vs " + nextGetter.getFullName());
        }
        return getter;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedMethod getSetter() {
        if (this._setters == null) {
            return null;
        }
        AnnotatedMethod setter = this._setters.value;
        for (Node node = this._setters.next; node != null; node = node.next) {
            AnnotatedMethod nextSetter = (AnnotatedMethod) node.value;
            Class<?> setterClass = setter.getDeclaringClass();
            Class<?> nextClass = nextSetter.getDeclaringClass();
            if (setterClass != nextClass) {
                if (setterClass.isAssignableFrom(nextClass)) {
                    setter = nextSetter;
                } else if (!nextClass.isAssignableFrom(setterClass)) {
                }
            }
            throw new IllegalArgumentException("Conflicting setter definitions for property \"" + getName() + "\": " + setter.getFullName() + " vs " + nextSetter.getFullName());
        }
        return setter;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField field = this._fields.value;
        for (Node node = this._fields.next; node != null; node = node.next) {
            AnnotatedField nextField = (AnnotatedField) node.value;
            Class<?> fieldClass = field.getDeclaringClass();
            Class<?> nextClass = nextField.getDeclaringClass();
            if (fieldClass != nextClass) {
                if (fieldClass.isAssignableFrom(nextClass)) {
                    field = nextField;
                } else if (!nextClass.isAssignableFrom(fieldClass)) {
                }
            }
            throw new IllegalArgumentException("Multiple fields representing property \"" + getName() + "\": " + field.getFullName() + " vs " + nextField.getFullName());
        }
        return field;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanPropertyDefinition
    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        Node node = this._ctorParameters;
        while (!(((AnnotatedParameter) node.value).getOwner() instanceof AnnotatedConstructor)) {
            node = node.next;
            if (node == null) {
                return this._ctorParameters.value;
            }
        }
        return (AnnotatedParameter) node.value;
    }

    public void addField(AnnotatedField a, String ename, boolean visible, boolean ignored) {
        this._fields = new Node<>(a, this._fields, ename, visible, ignored);
    }

    public void addCtor(AnnotatedParameter a, String ename, boolean visible, boolean ignored) {
        this._ctorParameters = new Node<>(a, this._ctorParameters, ename, visible, ignored);
    }

    public void addGetter(AnnotatedMethod a, String ename, boolean visible, boolean ignored) {
        this._getters = new Node<>(a, this._getters, ename, visible, ignored);
    }

    public void addSetter(AnnotatedMethod a, String ename, boolean visible, boolean ignored) {
        this._setters = new Node<>(a, this._setters, ename, visible, ignored);
    }

    public void addAll(POJOPropertyBuilder src) {
        this._fields = merge(this._fields, src._fields);
        this._ctorParameters = merge(this._ctorParameters, src._ctorParameters);
        this._getters = merge(this._getters, src._getters);
        this._setters = merge(this._setters, src._setters);
    }

    private static <T> Node<T> merge(Node<T> chain1, Node<T> chain2) {
        if (chain1 == null) {
            return chain2;
        }
        return chain2 == null ? chain1 : chain1.append(chain2);
    }

    public void removeIgnored() {
        this._fields = _removeIgnored(this._fields);
        this._getters = _removeIgnored(this._getters);
        this._setters = _removeIgnored(this._setters);
        this._ctorParameters = _removeIgnored(this._ctorParameters);
    }

    public void removeNonVisible() {
        this._getters = _removeNonVisible(this._getters);
        this._ctorParameters = _removeNonVisible(this._ctorParameters);
        if (this._getters == null) {
            this._fields = _removeNonVisible(this._fields);
            this._setters = _removeNonVisible(this._setters);
        }
    }

    public void trimByVisibility() {
        this._fields = _trimByVisibility(this._fields);
        this._getters = _trimByVisibility(this._getters);
        this._setters = _trimByVisibility(this._setters);
        this._ctorParameters = _trimByVisibility(this._ctorParameters);
    }

    public void mergeAnnotations(boolean forSerialization) {
        if (forSerialization) {
            if (this._getters != null) {
                AnnotationMap ann = _mergeAnnotations(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this._getters.withValue(this._getters.value.withAnnotations(ann));
            } else if (this._fields != null) {
                AnnotationMap ann2 = _mergeAnnotations(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this._fields.withValue(this._fields.value.withAnnotations(ann2));
            }
        } else if (this._ctorParameters != null) {
            AnnotationMap ann3 = _mergeAnnotations(0, this._ctorParameters, this._setters, this._fields, this._getters);
            this._ctorParameters = this._ctorParameters.withValue(this._ctorParameters.value.withAnnotations(ann3));
        } else if (this._setters != null) {
            AnnotationMap ann4 = _mergeAnnotations(0, this._setters, this._fields, this._getters);
            this._setters = this._setters.withValue(this._setters.value.withAnnotations(ann4));
        } else if (this._fields != null) {
            AnnotationMap ann5 = _mergeAnnotations(0, this._fields, this._getters);
            this._fields = this._fields.withValue(this._fields.value.withAnnotations(ann5));
        }
    }

    private AnnotationMap _mergeAnnotations(int index, Node<? extends AnnotatedMember>... nodes) {
        AnnotationMap ann = ((AnnotatedMember) nodes[index].value).getAllAnnotations();
        while (true) {
            index++;
            if (index < nodes.length) {
                if (nodes[index] != null) {
                    return AnnotationMap.merge(ann, _mergeAnnotations(index, nodes));
                }
            } else {
                return ann;
            }
        }
    }

    private <T> Node<T> _removeIgnored(Node<T> node) {
        return node == null ? node : node.withoutIgnored();
    }

    private <T> Node<T> _removeNonVisible(Node<T> node) {
        return node == null ? node : node.withoutNonVisible();
    }

    private <T> Node<T> _trimByVisibility(Node<T> node) {
        return node == null ? node : node.trimByVisibility();
    }

    public boolean anyExplicitNames() {
        return _anyExplicitNames(this._fields) || _anyExplicitNames(this._getters) || _anyExplicitNames(this._setters) || _anyExplicitNames(this._ctorParameters);
    }

    private <T> boolean _anyExplicitNames(Node<T> n) {
        while (n != null) {
            if (n.explicitName == null || n.explicitName.length() <= 0) {
                n = n.next;
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean anyVisible() {
        return _anyVisible(this._fields) || _anyVisible(this._getters) || _anyVisible(this._setters) || _anyVisible(this._ctorParameters);
    }

    private <T> boolean _anyVisible(Node<T> n) {
        while (n != null) {
            if (!n.isVisible) {
                n = n.next;
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean anyIgnorals() {
        return _anyIgnorals(this._fields) || _anyIgnorals(this._getters) || _anyIgnorals(this._setters) || _anyIgnorals(this._ctorParameters);
    }

    public boolean anyDeserializeIgnorals() {
        return _anyIgnorals(this._fields) || _anyIgnorals(this._setters) || _anyIgnorals(this._ctorParameters);
    }

    public boolean anySerializeIgnorals() {
        return _anyIgnorals(this._fields) || _anyIgnorals(this._getters);
    }

    private <T> boolean _anyIgnorals(Node<T> n) {
        while (n != null) {
            if (!n.isMarkedIgnored) {
                n = n.next;
            } else {
                return true;
            }
        }
        return false;
    }

    public String findNewName() {
        Node<? extends AnnotatedMember> renamed = findRenamed(this._fields, null);
        Node<? extends AnnotatedMember> renamed2 = findRenamed(this._ctorParameters, findRenamed(this._setters, findRenamed(this._getters, renamed)));
        if (renamed2 == null) {
            return null;
        }
        return renamed2.explicitName;
    }

    /* JADX WARN: Code restructure failed: missing block: B:0:?, code lost:
        r5 = r5;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    private com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder.Node<? extends com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember> findRenamed(com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder.Node<? extends com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember> r5, com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder.Node<? extends com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember> r6) {
        /*
            r4 = this;
        L0:
            if (r5 == 0) goto L62
            java.lang.String r0 = r5.explicitName
            if (r0 != 0) goto L9
        L6:
            com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder$Node<T> r5 = r5.next
            goto L0
        L9:
            java.lang.String r1 = r4._name
            boolean r1 = r0.equals(r1)
            if (r1 != 0) goto L6
            if (r6 != 0) goto L15
            r6 = r5
            goto L6
        L15:
            java.lang.String r1 = r6.explicitName
            boolean r1 = r0.equals(r1)
            if (r1 != 0) goto L6
            java.lang.IllegalStateException r1 = new java.lang.IllegalStateException
            java.lang.StringBuilder r2 = new java.lang.StringBuilder
            r2.<init>()
            java.lang.String r3 = "Conflicting property name definitions: '"
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = r6.explicitName
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = "' (for "
            java.lang.StringBuilder r2 = r2.append(r3)
            T r3 = r6.value
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = ") vs '"
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = r5.explicitName
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = "' (for "
            java.lang.StringBuilder r2 = r2.append(r3)
            T r3 = r5.value
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r3 = ")"
            java.lang.StringBuilder r2 = r2.append(r3)
            java.lang.String r2 = r2.toString()
            r1.<init>(r2)
            throw r1
        L62:
            return r6
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder.findRenamed(com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder$Node, com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder$Node):com.flurry.org.codehaus.jackson.map.introspect.POJOPropertyBuilder$Node");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        sb.append("]");
        return sb.toString();
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class Node<T> {
        public final String explicitName;
        public final boolean isMarkedIgnored;
        public final boolean isVisible;
        public final Node<T> next;
        public final T value;

        public Node(T v, Node<T> n, String explName, boolean visible, boolean ignored) {
            this.value = v;
            this.next = n;
            if (explName == null) {
                this.explicitName = null;
            } else {
                this.explicitName = explName.length() == 0 ? null : explName;
            }
            this.isVisible = visible;
            this.isMarkedIgnored = ignored;
        }

        public Node<T> withValue(T newValue) {
            return newValue == this.value ? this : new Node<>(newValue, this.next, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Node<T> withNext(Node<T> newNext) {
            return newNext == this.next ? this : new Node<>(this.value, newNext, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Node<T> withoutIgnored() {
            Node<T> newNext;
            if (!this.isMarkedIgnored) {
                return (this.next == null || (newNext = this.next.withoutIgnored()) == this.next) ? this : withNext(newNext);
            } else if (this.next == null) {
                return null;
            } else {
                return this.next.withoutIgnored();
            }
        }

        public Node<T> withoutNonVisible() {
            Node<T> newNext = this.next == null ? null : this.next.withoutNonVisible();
            return this.isVisible ? withNext(newNext) : newNext;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public Node<T> append(Node<T> appendable) {
            return this.next == null ? withNext(appendable) : withNext(this.next.append(appendable));
        }

        public Node<T> trimByVisibility() {
            if (this.next == null) {
                return this;
            }
            Node<T> newNext = this.next.trimByVisibility();
            if (this.explicitName != null) {
                if (newNext.explicitName == null) {
                    return withNext(null);
                }
                return withNext(newNext);
            } else if (newNext.explicitName == null) {
                if (this.isVisible == newNext.isVisible) {
                    return withNext(newNext);
                }
                return this.isVisible ? withNext(null) : newNext;
            } else {
                return newNext;
            }
        }

        public String toString() {
            String msg = this.value.toString() + "[visible=" + this.isVisible + "]";
            if (this.next != null) {
                return msg + ", " + this.next.toString();
            }
            return msg;
        }
    }
}
