package com.flurry.org.codehaus.jackson.map.introspect;

import com.flurry.org.codehaus.jackson.map.util.ClassUtil;
import java.lang.reflect.Member;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public abstract class AnnotatedMember extends Annotated {
    protected final AnnotationMap _annotations;

    public abstract Class<?> getDeclaringClass();

    public abstract Member getMember();

    public abstract void setValue(Object obj, Object obj2) throws UnsupportedOperationException, IllegalArgumentException;

    /* JADX INFO: Access modifiers changed from: protected */
    public AnnotatedMember(AnnotationMap annotations) {
        this._annotations = annotations;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.codehaus.jackson.map.introspect.Annotated
    public AnnotationMap getAllAnnotations() {
        return this._annotations;
    }

    public final void fixAccess() {
        ClassUtil.checkAndFixAccess(getMember());
    }
}
